/*
 * Decompiled with CFR 0.152.
 */
package java.util.concurrent.atomic;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.function.IntBinaryOperator;
import java.util.function.IntUnaryOperator;
import sun.misc.Unsafe;
import sun.reflect.CallerSensitive;
import sun.reflect.Reflection;
import sun.reflect.misc.ReflectUtil;

public abstract class AtomicIntegerFieldUpdater<T> {
    @CallerSensitive
    public static <U> AtomicIntegerFieldUpdater<U> newUpdater(Class<U> tclass, String fieldName) {
        return new AtomicIntegerFieldUpdaterImpl<U>(tclass, fieldName, Reflection.getCallerClass());
    }

    protected AtomicIntegerFieldUpdater() {
    }

    public abstract boolean compareAndSet(T var1, int var2, int var3);

    public abstract boolean weakCompareAndSet(T var1, int var2, int var3);

    public abstract void set(T var1, int var2);

    public abstract void lazySet(T var1, int var2);

    public abstract int get(T var1);

    public int getAndSet(T obj, int newValue) {
        int prev;
        while (!this.compareAndSet(obj, prev = this.get(obj), newValue)) {
        }
        return prev;
    }

    public int getAndIncrement(T obj) {
        int next;
        int prev;
        while (!this.compareAndSet(obj, prev = this.get(obj), next = prev + 1)) {
        }
        return prev;
    }

    public int getAndDecrement(T obj) {
        int next;
        int prev;
        while (!this.compareAndSet(obj, prev = this.get(obj), next = prev - 1)) {
        }
        return prev;
    }

    public int getAndAdd(T obj, int delta) {
        int next;
        int prev;
        while (!this.compareAndSet(obj, prev = this.get(obj), next = prev + delta)) {
        }
        return prev;
    }

    public int incrementAndGet(T obj) {
        int next;
        int prev;
        while (!this.compareAndSet(obj, prev = this.get(obj), next = prev + 1)) {
        }
        return next;
    }

    public int decrementAndGet(T obj) {
        int next;
        int prev;
        while (!this.compareAndSet(obj, prev = this.get(obj), next = prev - 1)) {
        }
        return next;
    }

    public int addAndGet(T obj, int delta) {
        int next;
        int prev;
        while (!this.compareAndSet(obj, prev = this.get(obj), next = prev + delta)) {
        }
        return next;
    }

    public final int getAndUpdate(T obj, IntUnaryOperator updateFunction) {
        int next;
        int prev;
        while (!this.compareAndSet(obj, prev = this.get(obj), next = updateFunction.applyAsInt(prev))) {
        }
        return prev;
    }

    public final int updateAndGet(T obj, IntUnaryOperator updateFunction) {
        int next;
        int prev;
        while (!this.compareAndSet(obj, prev = this.get(obj), next = updateFunction.applyAsInt(prev))) {
        }
        return next;
    }

    public final int getAndAccumulate(T obj, int x, IntBinaryOperator accumulatorFunction) {
        int next;
        int prev;
        while (!this.compareAndSet(obj, prev = this.get(obj), next = accumulatorFunction.applyAsInt(prev, x))) {
        }
        return prev;
    }

    public final int accumulateAndGet(T obj, int x, IntBinaryOperator accumulatorFunction) {
        int next;
        int prev;
        while (!this.compareAndSet(obj, prev = this.get(obj), next = accumulatorFunction.applyAsInt(prev, x))) {
        }
        return next;
    }

    private static class AtomicIntegerFieldUpdaterImpl<T>
    extends AtomicIntegerFieldUpdater<T> {
        private static final Unsafe U = Unsafe.getUnsafe();
        private final long offset;
        private final Class<T> tclass;
        private final Class<?> cclass;

        AtomicIntegerFieldUpdaterImpl(final Class<T> tclass, final String fieldName, Class<?> caller) {
            int modifiers;
            Field field;
            try {
                field = AccessController.doPrivileged(new PrivilegedExceptionAction<Field>(){

                    @Override
                    public Field run() throws NoSuchFieldException {
                        return tclass.getDeclaredField(fieldName);
                    }
                });
                modifiers = field.getModifiers();
                ReflectUtil.ensureMemberAccess(caller, tclass, null, modifiers);
                ClassLoader cl = tclass.getClassLoader();
                ClassLoader ccl = caller.getClassLoader();
                if (!(ccl == null || ccl == cl || cl != null && AtomicIntegerFieldUpdaterImpl.isAncestor(cl, ccl))) {
                    ReflectUtil.checkPackageAccess(tclass);
                }
            }
            catch (PrivilegedActionException pae) {
                throw new RuntimeException(pae.getException());
            }
            catch (Exception ex) {
                throw new RuntimeException(ex);
            }
            Class<?> fieldt = field.getType();
            if (fieldt != Integer.TYPE) {
                throw new IllegalArgumentException("Must be integer type");
            }
            if (!Modifier.isVolatile(modifiers)) {
                throw new IllegalArgumentException("Must be volatile type");
            }
            this.cclass = Modifier.isProtected(modifiers) && caller != tclass ? caller : null;
            this.tclass = tclass;
            this.offset = U.objectFieldOffset(field);
        }

        private static boolean isAncestor(ClassLoader first, ClassLoader second) {
            ClassLoader acl = first;
            do {
                if (second != (acl = acl.getParent())) continue;
                return true;
            } while (acl != null);
            return false;
        }

        private void fullCheck(T obj) {
            if (!this.tclass.isInstance(obj)) {
                throw new ClassCastException();
            }
            if (this.cclass != null) {
                this.ensureProtectedAccess(obj);
            }
        }

        @Override
        public boolean compareAndSet(T obj, int expect, int update) {
            if (obj == null || obj.getClass() != this.tclass || this.cclass != null) {
                this.fullCheck(obj);
            }
            return U.compareAndSwapInt(obj, this.offset, expect, update);
        }

        @Override
        public boolean weakCompareAndSet(T obj, int expect, int update) {
            if (obj == null || obj.getClass() != this.tclass || this.cclass != null) {
                this.fullCheck(obj);
            }
            return U.compareAndSwapInt(obj, this.offset, expect, update);
        }

        @Override
        public void set(T obj, int newValue) {
            if (obj == null || obj.getClass() != this.tclass || this.cclass != null) {
                this.fullCheck(obj);
            }
            U.putIntVolatile(obj, this.offset, newValue);
        }

        @Override
        public void lazySet(T obj, int newValue) {
            if (obj == null || obj.getClass() != this.tclass || this.cclass != null) {
                this.fullCheck(obj);
            }
            U.putOrderedInt(obj, this.offset, newValue);
        }

        @Override
        public final int get(T obj) {
            if (obj == null || obj.getClass() != this.tclass || this.cclass != null) {
                this.fullCheck(obj);
            }
            return U.getIntVolatile(obj, this.offset);
        }

        @Override
        public int getAndSet(T obj, int newValue) {
            if (obj == null || obj.getClass() != this.tclass || this.cclass != null) {
                this.fullCheck(obj);
            }
            return U.getAndSetInt(obj, this.offset, newValue);
        }

        @Override
        public int getAndIncrement(T obj) {
            return this.getAndAdd(obj, 1);
        }

        @Override
        public int getAndDecrement(T obj) {
            return this.getAndAdd(obj, -1);
        }

        @Override
        public int getAndAdd(T obj, int delta) {
            if (obj == null || obj.getClass() != this.tclass || this.cclass != null) {
                this.fullCheck(obj);
            }
            return U.getAndAddInt(obj, this.offset, delta);
        }

        @Override
        public int incrementAndGet(T obj) {
            return this.getAndAdd(obj, 1) + 1;
        }

        @Override
        public int decrementAndGet(T obj) {
            return this.getAndAdd(obj, -1) - 1;
        }

        @Override
        public int addAndGet(T obj, int delta) {
            return this.getAndAdd(obj, delta) + delta;
        }

        private void ensureProtectedAccess(T obj) {
            if (this.cclass.isInstance(obj)) {
                return;
            }
            throw new RuntimeException(new IllegalAccessException("Class " + this.cclass.getName() + " can not access a protected member of class " + this.tclass.getName() + " using an instance of " + obj.getClass().getName()));
        }
    }
}

