/*
 * Decompiled with CFR 0.152.
 */
package java.util.concurrent.atomic;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.LongBinaryOperator;
import java.util.function.LongUnaryOperator;
import sun.misc.Unsafe;
import sun.reflect.CallerSensitive;
import sun.reflect.Reflection;
import sun.reflect.misc.ReflectUtil;

public abstract class AtomicLongFieldUpdater<T> {
    @CallerSensitive
    public static <U> AtomicLongFieldUpdater<U> newUpdater(Class<U> tclass, String fieldName) {
        Class caller = Reflection.getCallerClass();
        if (AtomicLong.VM_SUPPORTS_LONG_CAS) {
            return new CASUpdater<U>(tclass, fieldName, caller);
        }
        return new LockedUpdater<U>(tclass, fieldName, caller);
    }

    protected AtomicLongFieldUpdater() {
    }

    public abstract boolean compareAndSet(T var1, long var2, long var4);

    public abstract boolean weakCompareAndSet(T var1, long var2, long var4);

    public abstract void set(T var1, long var2);

    public abstract void lazySet(T var1, long var2);

    public abstract long get(T var1);

    public long getAndSet(T obj, long newValue) {
        long prev;
        while (!this.compareAndSet(obj, prev = this.get(obj), newValue)) {
        }
        return prev;
    }

    public long getAndIncrement(T obj) {
        long next;
        long prev;
        while (!this.compareAndSet(obj, prev = this.get(obj), next = prev + 1L)) {
        }
        return prev;
    }

    public long getAndDecrement(T obj) {
        long next;
        long prev;
        while (!this.compareAndSet(obj, prev = this.get(obj), next = prev - 1L)) {
        }
        return prev;
    }

    public long getAndAdd(T obj, long delta) {
        long next;
        long prev;
        while (!this.compareAndSet(obj, prev = this.get(obj), next = prev + delta)) {
        }
        return prev;
    }

    public long incrementAndGet(T obj) {
        long next;
        long prev;
        while (!this.compareAndSet(obj, prev = this.get(obj), next = prev + 1L)) {
        }
        return next;
    }

    public long decrementAndGet(T obj) {
        long next;
        long prev;
        while (!this.compareAndSet(obj, prev = this.get(obj), next = prev - 1L)) {
        }
        return next;
    }

    public long addAndGet(T obj, long delta) {
        long next;
        long prev;
        while (!this.compareAndSet(obj, prev = this.get(obj), next = prev + delta)) {
        }
        return next;
    }

    public final long getAndUpdate(T obj, LongUnaryOperator updateFunction) {
        long next;
        long prev;
        while (!this.compareAndSet(obj, prev = this.get(obj), next = updateFunction.applyAsLong(prev))) {
        }
        return prev;
    }

    public final long updateAndGet(T obj, LongUnaryOperator updateFunction) {
        long next;
        long prev;
        while (!this.compareAndSet(obj, prev = this.get(obj), next = updateFunction.applyAsLong(prev))) {
        }
        return next;
    }

    public final long getAndAccumulate(T obj, long x, LongBinaryOperator accumulatorFunction) {
        long next;
        long prev;
        while (!this.compareAndSet(obj, prev = this.get(obj), next = accumulatorFunction.applyAsLong(prev, x))) {
        }
        return prev;
    }

    public final long accumulateAndGet(T obj, long x, LongBinaryOperator accumulatorFunction) {
        long next;
        long prev;
        while (!this.compareAndSet(obj, prev = this.get(obj), next = accumulatorFunction.applyAsLong(prev, x))) {
        }
        return next;
    }

    private static boolean isAncestor(ClassLoader first, ClassLoader second) {
        ClassLoader acl = first;
        do {
            if (second != (acl = acl.getParent())) continue;
            return true;
        } while (acl != null);
        return false;
    }

    private static class LockedUpdater<T>
    extends AtomicLongFieldUpdater<T> {
        private static final Unsafe U = Unsafe.getUnsafe();
        private final long offset;
        private final Class<T> tclass;
        private final Class<?> cclass;

        LockedUpdater(final Class<T> tclass, final String fieldName, Class<?> caller) {
            Field field = null;
            int modifiers = 0;
            try {
                field = AccessController.doPrivileged(new PrivilegedExceptionAction<Field>(){

                    @Override
                    public Field run() throws NoSuchFieldException {
                        return tclass.getDeclaredField(fieldName);
                    }
                });
                modifiers = field.getModifiers();
                ReflectUtil.ensureMemberAccess(caller, tclass, null, modifiers);
                ClassLoader cl = tclass.getClassLoader();
                ClassLoader ccl = caller.getClassLoader();
                if (!(ccl == null || ccl == cl || cl != null && AtomicLongFieldUpdater.isAncestor(cl, ccl))) {
                    ReflectUtil.checkPackageAccess(tclass);
                }
            }
            catch (PrivilegedActionException pae) {
                throw new RuntimeException(pae.getException());
            }
            catch (Exception ex) {
                throw new RuntimeException(ex);
            }
            Class<?> fieldt = field.getType();
            if (fieldt != Long.TYPE) {
                throw new IllegalArgumentException("Must be long type");
            }
            if (!Modifier.isVolatile(modifiers)) {
                throw new IllegalArgumentException("Must be volatile type");
            }
            this.cclass = Modifier.isProtected(modifiers) && caller != tclass ? caller : null;
            this.tclass = tclass;
            this.offset = U.objectFieldOffset(field);
        }

        private void fullCheck(T obj) {
            if (!this.tclass.isInstance(obj)) {
                throw new ClassCastException();
            }
            if (this.cclass != null) {
                this.ensureProtectedAccess(obj);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean compareAndSet(T obj, long expect, long update) {
            if (obj == null || obj.getClass() != this.tclass || this.cclass != null) {
                this.fullCheck(obj);
            }
            LockedUpdater lockedUpdater = this;
            synchronized (lockedUpdater) {
                long v = U.getLong(obj, this.offset);
                if (v != expect) {
                    return false;
                }
                U.putLong(obj, this.offset, update);
                return true;
            }
        }

        @Override
        public boolean weakCompareAndSet(T obj, long expect, long update) {
            return this.compareAndSet(obj, expect, update);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void set(T obj, long newValue) {
            if (obj == null || obj.getClass() != this.tclass || this.cclass != null) {
                this.fullCheck(obj);
            }
            LockedUpdater lockedUpdater = this;
            synchronized (lockedUpdater) {
                U.putLong(obj, this.offset, newValue);
            }
        }

        @Override
        public void lazySet(T obj, long newValue) {
            this.set(obj, newValue);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public long get(T obj) {
            if (obj == null || obj.getClass() != this.tclass || this.cclass != null) {
                this.fullCheck(obj);
            }
            LockedUpdater lockedUpdater = this;
            synchronized (lockedUpdater) {
                return U.getLong(obj, this.offset);
            }
        }

        private void ensureProtectedAccess(T obj) {
            if (this.cclass.isInstance(obj)) {
                return;
            }
            throw new RuntimeException(new IllegalAccessException("Class " + this.cclass.getName() + " can not access a protected member of class " + this.tclass.getName() + " using an instance of " + obj.getClass().getName()));
        }
    }

    private static class CASUpdater<T>
    extends AtomicLongFieldUpdater<T> {
        private static final Unsafe U = Unsafe.getUnsafe();
        private final long offset;
        private final Class<T> tclass;
        private final Class<?> cclass;

        CASUpdater(final Class<T> tclass, final String fieldName, Class<?> caller) {
            int modifiers;
            Field field;
            try {
                field = AccessController.doPrivileged(new PrivilegedExceptionAction<Field>(){

                    @Override
                    public Field run() throws NoSuchFieldException {
                        return tclass.getDeclaredField(fieldName);
                    }
                });
                modifiers = field.getModifiers();
                ReflectUtil.ensureMemberAccess(caller, tclass, null, modifiers);
                ClassLoader cl = tclass.getClassLoader();
                ClassLoader ccl = caller.getClassLoader();
                if (!(ccl == null || ccl == cl || cl != null && AtomicLongFieldUpdater.isAncestor(cl, ccl))) {
                    ReflectUtil.checkPackageAccess(tclass);
                }
            }
            catch (PrivilegedActionException pae) {
                throw new RuntimeException(pae.getException());
            }
            catch (Exception ex) {
                throw new RuntimeException(ex);
            }
            Class<?> fieldt = field.getType();
            if (fieldt != Long.TYPE) {
                throw new IllegalArgumentException("Must be long type");
            }
            if (!Modifier.isVolatile(modifiers)) {
                throw new IllegalArgumentException("Must be volatile type");
            }
            this.cclass = Modifier.isProtected(modifiers) && caller != tclass ? caller : null;
            this.tclass = tclass;
            this.offset = U.objectFieldOffset(field);
        }

        private void fullCheck(T obj) {
            if (!this.tclass.isInstance(obj)) {
                throw new ClassCastException();
            }
            if (this.cclass != null) {
                this.ensureProtectedAccess(obj);
            }
        }

        @Override
        public boolean compareAndSet(T obj, long expect, long update) {
            if (obj == null || obj.getClass() != this.tclass || this.cclass != null) {
                this.fullCheck(obj);
            }
            return U.compareAndSwapLong(obj, this.offset, expect, update);
        }

        @Override
        public boolean weakCompareAndSet(T obj, long expect, long update) {
            if (obj == null || obj.getClass() != this.tclass || this.cclass != null) {
                this.fullCheck(obj);
            }
            return U.compareAndSwapLong(obj, this.offset, expect, update);
        }

        @Override
        public void set(T obj, long newValue) {
            if (obj == null || obj.getClass() != this.tclass || this.cclass != null) {
                this.fullCheck(obj);
            }
            U.putLongVolatile(obj, this.offset, newValue);
        }

        @Override
        public void lazySet(T obj, long newValue) {
            if (obj == null || obj.getClass() != this.tclass || this.cclass != null) {
                this.fullCheck(obj);
            }
            U.putOrderedLong(obj, this.offset, newValue);
        }

        @Override
        public long get(T obj) {
            if (obj == null || obj.getClass() != this.tclass || this.cclass != null) {
                this.fullCheck(obj);
            }
            return U.getLongVolatile(obj, this.offset);
        }

        @Override
        public long getAndSet(T obj, long newValue) {
            if (obj == null || obj.getClass() != this.tclass || this.cclass != null) {
                this.fullCheck(obj);
            }
            return U.getAndSetLong(obj, this.offset, newValue);
        }

        @Override
        public long getAndIncrement(T obj) {
            return this.getAndAdd(obj, 1L);
        }

        @Override
        public long getAndDecrement(T obj) {
            return this.getAndAdd(obj, -1L);
        }

        @Override
        public long getAndAdd(T obj, long delta) {
            if (obj == null || obj.getClass() != this.tclass || this.cclass != null) {
                this.fullCheck(obj);
            }
            return U.getAndAddLong(obj, this.offset, delta);
        }

        @Override
        public long incrementAndGet(T obj) {
            return this.getAndAdd(obj, 1L) + 1L;
        }

        @Override
        public long decrementAndGet(T obj) {
            return this.getAndAdd(obj, -1L) - 1L;
        }

        @Override
        public long addAndGet(T obj, long delta) {
            return this.getAndAdd(obj, delta) + delta;
        }

        private void ensureProtectedAccess(T obj) {
            if (this.cclass.isInstance(obj)) {
                return;
            }
            throw new RuntimeException(new IllegalAccessException("Class " + this.cclass.getName() + " can not access a protected member of class " + this.tclass.getName() + " using an instance of " + obj.getClass().getName()));
        }
    }
}

