/*
 * Decompiled with CFR 0.152.
 */
package java.util.concurrent.atomic;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.function.BinaryOperator;
import java.util.function.UnaryOperator;
import sun.misc.Unsafe;
import sun.reflect.CallerSensitive;
import sun.reflect.Reflection;
import sun.reflect.misc.ReflectUtil;

public abstract class AtomicReferenceFieldUpdater<T, V> {
    @CallerSensitive
    public static <U, W> AtomicReferenceFieldUpdater<U, W> newUpdater(Class<U> tclass, Class<W> vclass, String fieldName) {
        return new AtomicReferenceFieldUpdaterImpl<U, W>(tclass, vclass, fieldName, Reflection.getCallerClass());
    }

    protected AtomicReferenceFieldUpdater() {
    }

    public abstract boolean compareAndSet(T var1, V var2, V var3);

    public abstract boolean weakCompareAndSet(T var1, V var2, V var3);

    public abstract void set(T var1, V var2);

    public abstract void lazySet(T var1, V var2);

    public abstract V get(T var1);

    public V getAndSet(T obj, V newValue) {
        V prev;
        while (!this.compareAndSet(obj, prev = this.get(obj), newValue)) {
        }
        return prev;
    }

    public final V getAndUpdate(T obj, UnaryOperator<V> updateFunction) {
        Object next;
        V prev;
        while (!this.compareAndSet(obj, prev = this.get(obj), next = updateFunction.apply(prev))) {
        }
        return prev;
    }

    public final V updateAndGet(T obj, UnaryOperator<V> updateFunction) {
        Object next;
        V prev;
        while (!this.compareAndSet(obj, prev = this.get(obj), next = updateFunction.apply(prev))) {
        }
        return (V)next;
    }

    public final V getAndAccumulate(T obj, V x, BinaryOperator<V> accumulatorFunction) {
        Object next;
        V prev;
        while (!this.compareAndSet(obj, prev = this.get(obj), next = accumulatorFunction.apply(prev, x))) {
        }
        return prev;
    }

    public final V accumulateAndGet(T obj, V x, BinaryOperator<V> accumulatorFunction) {
        Object next;
        V prev;
        while (!this.compareAndSet(obj, prev = this.get(obj), next = accumulatorFunction.apply(prev, x))) {
        }
        return (V)next;
    }

    private static final class AtomicReferenceFieldUpdaterImpl<T, V>
    extends AtomicReferenceFieldUpdater<T, V> {
        private static final Unsafe U = Unsafe.getUnsafe();
        private final long offset;
        private final Class<T> tclass;
        private final Class<V> vclass;
        private final Class<?> cclass;

        AtomicReferenceFieldUpdaterImpl(final Class<T> tclass, Class<V> vclass, final String fieldName, Class<?> caller) {
            Class<?> fieldClass;
            int modifiers;
            Field field;
            try {
                field = AccessController.doPrivileged(new PrivilegedExceptionAction<Field>(){

                    @Override
                    public Field run() throws NoSuchFieldException {
                        return tclass.getDeclaredField(fieldName);
                    }
                });
                modifiers = field.getModifiers();
                ReflectUtil.ensureMemberAccess(caller, tclass, null, modifiers);
                ClassLoader cl = tclass.getClassLoader();
                ClassLoader ccl = caller.getClassLoader();
                if (!(ccl == null || ccl == cl || cl != null && AtomicReferenceFieldUpdaterImpl.isAncestor(cl, ccl))) {
                    ReflectUtil.checkPackageAccess(tclass);
                }
                fieldClass = field.getType();
            }
            catch (PrivilegedActionException pae) {
                throw new RuntimeException(pae.getException());
            }
            catch (Exception ex) {
                throw new RuntimeException(ex);
            }
            if (vclass != fieldClass) {
                throw new ClassCastException();
            }
            if (!Modifier.isVolatile(modifiers)) {
                throw new IllegalArgumentException("Must be volatile type");
            }
            this.cclass = Modifier.isProtected(modifiers) && caller != tclass ? caller : null;
            this.tclass = tclass;
            this.vclass = vclass == Object.class ? null : vclass;
            this.offset = U.objectFieldOffset(field);
        }

        private static boolean isAncestor(ClassLoader first, ClassLoader second) {
            ClassLoader acl = first;
            do {
                if (second != (acl = acl.getParent())) continue;
                return true;
            } while (acl != null);
            return false;
        }

        void targetCheck(T obj) {
            if (!this.tclass.isInstance(obj)) {
                throw new ClassCastException();
            }
            if (this.cclass != null) {
                this.ensureProtectedAccess(obj);
            }
        }

        void updateCheck(T obj, V update) {
            if (!this.tclass.isInstance(obj) || update != null && this.vclass != null && !this.vclass.isInstance(update)) {
                throw new ClassCastException();
            }
            if (this.cclass != null) {
                this.ensureProtectedAccess(obj);
            }
        }

        @Override
        public boolean compareAndSet(T obj, V expect, V update) {
            if (obj == null || obj.getClass() != this.tclass || this.cclass != null || update != null && this.vclass != null && this.vclass != update.getClass()) {
                this.updateCheck(obj, update);
            }
            return U.compareAndSwapObject(obj, this.offset, expect, update);
        }

        @Override
        public boolean weakCompareAndSet(T obj, V expect, V update) {
            if (obj == null || obj.getClass() != this.tclass || this.cclass != null || update != null && this.vclass != null && this.vclass != update.getClass()) {
                this.updateCheck(obj, update);
            }
            return U.compareAndSwapObject(obj, this.offset, expect, update);
        }

        @Override
        public void set(T obj, V newValue) {
            if (obj == null || obj.getClass() != this.tclass || this.cclass != null || newValue != null && this.vclass != null && this.vclass != newValue.getClass()) {
                this.updateCheck(obj, newValue);
            }
            U.putObjectVolatile(obj, this.offset, newValue);
        }

        @Override
        public void lazySet(T obj, V newValue) {
            if (obj == null || obj.getClass() != this.tclass || this.cclass != null || newValue != null && this.vclass != null && this.vclass != newValue.getClass()) {
                this.updateCheck(obj, newValue);
            }
            U.putOrderedObject(obj, this.offset, newValue);
        }

        @Override
        public V get(T obj) {
            if (obj == null || obj.getClass() != this.tclass || this.cclass != null) {
                this.targetCheck(obj);
            }
            return (V)U.getObjectVolatile(obj, this.offset);
        }

        @Override
        public V getAndSet(T obj, V newValue) {
            if (obj == null || obj.getClass() != this.tclass || this.cclass != null || newValue != null && this.vclass != null && this.vclass != newValue.getClass()) {
                this.updateCheck(obj, newValue);
            }
            return (V)U.getAndSetObject(obj, this.offset, newValue);
        }

        private void ensureProtectedAccess(T obj) {
            if (this.cclass.isInstance(obj)) {
                return;
            }
            throw new RuntimeException(new IllegalAccessException("Class " + this.cclass.getName() + " can not access a protected member of class " + this.tclass.getName() + " using an instance of " + obj.getClass().getName()));
        }
    }
}

