/*
 * Decompiled with CFR 0.152.
 */
package java.util.concurrent.atomic;

import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.concurrent.atomic.Striped64;
import java.util.function.LongBinaryOperator;

public class LongAccumulator
extends Striped64
implements Serializable {
    private static final long serialVersionUID = 7249069246863182397L;
    private final LongBinaryOperator function;
    private final long identity;

    public LongAccumulator(LongBinaryOperator accumulatorFunction, long identity) {
        this.function = accumulatorFunction;
        this.base = this.identity = identity;
    }

    public void accumulate(long x) {
        long b;
        long r;
        Striped64.Cell[] as = this.cells;
        if (this.cells != null || (r = this.function.applyAsLong(b = this.base, x)) != b && !this.casBase(b, r)) {
            long v;
            Striped64.Cell a;
            int m;
            boolean uncontended = true;
            if (as == null || (m = as.length - 1) < 0 || (a = as[LongAccumulator.getProbe() & m]) == null || !(uncontended = (r = this.function.applyAsLong(v = a.value, x)) == v || a.cas(v, r))) {
                this.longAccumulate(x, this.function, uncontended);
            }
        }
    }

    public long get() {
        Striped64.Cell[] as = this.cells;
        long result = this.base;
        if (as != null) {
            for (Striped64.Cell a : as) {
                if (a == null) continue;
                result = this.function.applyAsLong(result, a.value);
            }
        }
        return result;
    }

    public void reset() {
        Striped64.Cell[] as = this.cells;
        this.base = this.identity;
        if (as != null) {
            for (Striped64.Cell a : as) {
                if (a == null) continue;
                a.reset(this.identity);
            }
        }
    }

    public long getThenReset() {
        Striped64.Cell[] as = this.cells;
        long result = this.base;
        this.base = this.identity;
        if (as != null) {
            for (Striped64.Cell a : as) {
                if (a == null) continue;
                long v = a.value;
                a.reset(this.identity);
                result = this.function.applyAsLong(result, v);
            }
        }
        return result;
    }

    public String toString() {
        return Long.toString(this.get());
    }

    @Override
    public long longValue() {
        return this.get();
    }

    @Override
    public int intValue() {
        return (int)this.get();
    }

    @Override
    public float floatValue() {
        return this.get();
    }

    @Override
    public double doubleValue() {
        return this.get();
    }

    private Object writeReplace() {
        return new SerializationProxy(this);
    }

    private void readObject(ObjectInputStream s) throws InvalidObjectException {
        throw new InvalidObjectException("Proxy required");
    }

    private static class SerializationProxy
    implements Serializable {
        private static final long serialVersionUID = 7249069246863182397L;
        private final long value;
        private final LongBinaryOperator function;
        private final long identity;

        SerializationProxy(LongAccumulator a) {
            this.function = a.function;
            this.identity = a.identity;
            this.value = a.get();
        }

        private Object readResolve() {
            LongAccumulator a = new LongAccumulator(this.function, this.identity);
            a.base = this.value;
            return a;
        }
    }
}

