//==============================================================================
//	
//	This file is originally taken from PRISM. We take and modify it in accordance
//  with our needs.
//	
//==============================================================================
#include <util.h>
#include <cudd.h>

// DD_PrintVector/Matrix accuracy flags

#define ACCURACY_ZERO_ONE 1
#define ACCURACY_LOW 2
#define ACCURACY_NORMAL 3
#define ACCURACY_HIGH 4
#define ACCURACY_LIST 5

// DD_MatrixMultiply method flags

#define MM_CMU 1
#define MM_BOULDER 2

//------------------------------------------------------------------------------

DdNode *DD_SetVectorElement(DdManager *ddman, DdNode *dd, DdNode **vars, int num_vars, long index, double value);
DdNode *DD_SetMatrixElement(DdManager *ddman, DdNode *dd, DdNode **rvars, int num_rvars, DdNode **cvars, int num_cvars, long rindex, long cindex, double value);
DdNode *DD_Set3DMatrixElement(DdManager *ddman, DdNode *dd, DdNode **rvars, int num_rvars, DdNode **cvars, int num_cvars, DdNode **lvars, int num_lvars, long rindex, long cindex, long lindex, double value);
double DD_GetVectorElement(DdManager *ddman, DdNode *dd, DdNode **vars, int num_vars, long index);
DdNode *DD_Identity(DdManager *ddman, DdNode **rvars, DdNode **cvars, int num_vars);
DdNode *DD_Transpose(DdManager *ddman, DdNode *dd, DdNode **row_vars, DdNode **col_vars, int num_vars);
DdNode *DD_MatrixMultiply(DdManager *ddman, DdNode *dd1, DdNode *dd2, DdNode **vars, int num_vars, int method);
void DD_PrintVector(DdManager *ddman, DdNode *dd, DdNode **vars, int num_vars);
void DD_PrintVector(DdManager *ddman, DdNode *dd, DdNode **vars, int num_vars, int accuracy);
void DD_PrintMatrix(DdManager *ddman, DdNode *dd, DdNode **rvars, int num_rvars, DdNode **cvars, int num_cvars);
void DD_PrintMatrix(DdManager *ddman, DdNode *dd, DdNode **rvars, int num_rvars, DdNode **cvars, int num_cvars, int accuracy);
void DD_PrintVectorFiltered(DdManager *ddman, DdNode *dd, DdNode *filter, DdNode **vars, int num_vars);
void DD_PrintVectorFiltered(DdManager *ddman, DdNode *dd, DdNode *filter, DdNode **vars, int num_vars, int accuracy);

//------------------------------------------------------------------------------
