//==============================================================================
//	
//	This file is originally taken from PRISM. We take and modify it in accordance
//  with our needs.
//	
//==============================================================================
#ifndef JNIPOINTER_H
#define JNIPOINTER_H

#include <inttypes.h>
#include "jni.h"

/*
 * Currently does nothing, used to annotate jlong's that are pointers
 */

#define __jlongpointer

/*
 * C++ doesn't support implicit conversion from void*
 */

#define jlong_to_FILE(x)		(FILE *)jlong_to_ptr(x)

// for dd
#define jlong_to_DdManager(x)		(DdManager *)jlong_to_ptr(x)
#define jlong_to_DdNode(x)		(DdNode *)jlong_to_ptr(x)
#define jlong_to_DdNode_array(x)	(DdNode **)jlong_to_ptr(x)

// for odd
#define jlong_to_ODDNode(x)		(ODDNode *)jlong_to_ptr(x)
#define jlong_to_double(x)		(double *)jlong_to_ptr(x)

// for sparse matrices
#define jlong_to_NDSparseMatrix(x)	(NDSparseMatrix *)jlong_to_ptr(x)

// for simulator
#define jlong_to_CExpression(x)		(CExpression *)jlong_to_ptr(x)
#define jlong_to_CRealExpression(x)	(CRealExpression *)jlong_to_ptr(x)
#define jlong_to_CNormalExpression(x)	(CNormalExpression *)jlong_to_ptr(x)

#define jlong_to_CPathFormula(x)	(CPathFormula *)jlong_to_ptr(x)
#define jlong_to_CRewardFormula(x)	(CRewardFormula *)jlong_to_ptr(x)

#define jlong_to_CCommand(x)		(CCommand *)jlong_to_ptr(x)
#define jlong_to_CUpdate(x)		(CUpdate *)jlong_to_ptr(x)

#define jlong_to_CStateReward(x)	(CStateReward *)jlong_to_ptr(x)
#define jlong_to_CTransitionReward(x)	(CTransitionReward *)jlong_to_ptr(x)

// void* <-> jlong conversions functions

static inline jlong __jlongpointer ptr_to_jlong(void *ptr)
{
	return (jlong)((intptr_t)ptr);
}

static inline void *jlong_to_ptr(jlong __jlongpointer ptr)
{
	return (void*)((intptr_t)ptr);
}

#endif // JNIPOINTER_H
