//==============================================================================
//	
//	This file is originally taken from PRISM. We take and modify it in accordance
//  with our needs.
//	
//==============================================================================
#include <util.h>
#include <cudd.h>
#include "dd_abstr.h"

//------------------------------------------------------------------------------

DdNode *DD_ThereExists
(
DdManager *ddman,
DdNode *dd,
DdNode **vars,
int num_vars
)
{
	DdNode *cube, *res;
	
	cube = Cudd_addComputeCube(ddman, vars, NULL, num_vars);
	Cudd_Ref(cube);
	res = Cudd_addOrAbstract(ddman, dd, cube);
	Cudd_Ref(res);
	Cudd_RecursiveDeref(ddman, dd);
	Cudd_RecursiveDeref(ddman,cube);

	return res;	
}

//------------------------------------------------------------------------------

DdNode *DD_ForAll
(
DdManager *ddman,
DdNode *dd,
DdNode **vars,
int num_vars
)
{
	DdNode *cube, *res;
	
	cube = Cudd_addComputeCube(ddman, vars, NULL, num_vars);
	Cudd_Ref(cube);
	res = Cudd_addUnivAbstract(ddman, dd, cube);	
	Cudd_Ref(res);
	Cudd_RecursiveDeref(ddman, dd);
	Cudd_RecursiveDeref(ddman, cube);

	return res;	
}

//------------------------------------------------------------------------------

DdNode *DD_SumAbstract
(
DdManager *ddman,
DdNode *dd,
DdNode **vars,
int num_vars
)
{
	DdNode *cube, *res;
	
	cube = Cudd_addComputeCube(ddman, vars, NULL, num_vars);
	Cudd_Ref(cube);
	res = Cudd_addExistAbstract(ddman, dd, cube);	
	Cudd_Ref(res);
	Cudd_RecursiveDeref(ddman, dd);
	Cudd_RecursiveDeref(ddman, cube);

	return res;	
}

//------------------------------------------------------------------------------

DdNode *DD_ProductAbstract
(
DdManager *ddman,
DdNode *dd,
DdNode **vars,
int num_vars
)
{
	DdNode *cube, *res;
	
	cube = Cudd_addComputeCube(ddman, vars, NULL, num_vars);
	Cudd_Ref(cube);
	res = Cudd_addUnivAbstract(ddman, dd, cube);	
	Cudd_Ref(res);
	Cudd_RecursiveDeref(ddman, dd);
	Cudd_RecursiveDeref(ddman, cube);

	return res;	
}

//------------------------------------------------------------------------------

DdNode *DD_MinAbstract
(
DdManager *ddman,
DdNode *dd,
DdNode **vars,
int num_vars
)
{
	DdNode *cube, *res;
	
	cube = Cudd_addComputeCube(ddman, vars, NULL, num_vars);
	Cudd_Ref(cube);
	res = Cudd_addMinAbstract(ddman, dd, cube);	
	Cudd_Ref(res);
	Cudd_RecursiveDeref(ddman, dd);
	Cudd_RecursiveDeref(ddman, cube);

	return res;	
}

//------------------------------------------------------------------------------

DdNode *DD_MaxAbstract
(
DdManager *ddman,
DdNode *dd,
DdNode **vars,
int num_vars
)
{
	DdNode *cube, *res;
	
	cube = Cudd_addComputeCube(ddman, vars, NULL, num_vars);
	Cudd_Ref(cube);
	res = Cudd_addMaxAbstract(ddman, dd, cube);	
	Cudd_Ref(res);
	Cudd_RecursiveDeref(ddman, dd);
	Cudd_RecursiveDeref(ddman, cube);

	return res;	
}

//------------------------------------------------------------------------------
