/*
 * AliasMethod.cpp
 *
 *  Created on: Sep 16, 2015
 *      Author: qixia.yuan
 */

#include "AliasMethod.h"

AliasMethod::AliasMethod() {
	// TODO Auto-generated constructor stub

}
AliasMethod::AliasMethod(std::vector<double> probability) {
	rnd.setSeed();
	probability_=probability;
	// Allocate space for the alias table.
	alias_.resize(probability_.size());

	// Compute the average probability and cache it for later use.
	const double average = 1.0 / probability_.size();

	// two stacks to act as worklists as we populate the tables
	std::vector<int> small, large;

	// Populate the stacks with the input probabilities.
	for (size_t i = 0; i < probability_.size(); ++i) {
		// If the probability is below the average probability, then we add
		// it to the small list; otherwise we add it to the large list.
		if (probability_[i] >= average)
			large.push_back(i);
		else
			small.push_back(i);
	}

	// As a note: in the mathematical specification of the algorithm, we
	// will always exhaust the small list before the big list.  However,
	// due to floating point inaccuracies, this is not necessarily true.
	// Consequently, this inner loop (which tries to pair small and large
	// elements) will have to check that both lists aren't empty.
	while (!small.empty() && !large.empty()) {
		// Get the index of the small and the large probabilities.
		int less = small.back();
		small.pop_back();
		int more = large.back();
		large.pop_back();

		alias_[less] = more;

		// Decrease the probability of the larger one by the appropriate
		// amount.
		probability_[more] = (probability_[more] + probability_[less])
				- average;

		// If the new probability is less than the average, add it into the
		// small list; otherwise add it to the large list.
		if (probability_[more] >= average)
			large.push_back(more);
		else
			small.push_back(more);
	}

	// At this point, everything is in one list, which means that the
	// remaining probabilities should all be 1/n.  Based on this, set them
	// appropriately.  Due to numerical issues, we can't be sure which
	// stack will hold the entries, so we empty both.
	while (!small.empty()) {
		probability_[small.back()] = average;
		small.pop_back();
	}
	while (!large.empty()) {
		probability_[large.back()] = average;
		large.pop_back();
	}

	// These probabilities have not yet been scaled up to be such that
	// 1/n is given weight 1.0.  We do this here instead.
	int n = static_cast<int>(probability_.size());
	n = probability_.size();
	//std::transform(probability_.cbegin(), probability_.cend(), probability_.begin(),
	//	[n](double p){ return p * n; });
	for (int i = 0; i < n; i++) {
		probability_[i] = probability_[i] * n;
	}
}
void AliasMethod::setPro(std::vector<double> probability){
	rnd.setSeed();
	probability_=probability;
	// Allocate space for the alias table.
	alias_.resize(probability_.size());

	// Compute the average probability and cache it for later use.
	const double average = 1.0 / probability_.size();

	// two stacks to act as worklists as we populate the tables
	std::vector<int> small, large;

	// Populate the stacks with the input probabilities.
	for (size_t i = 0; i < probability_.size(); ++i) {
		// If the probability is below the average probability, then we add
		// it to the small list; otherwise we add it to the large list.
		if (probability_[i] >= average)
			large.push_back(i);
		else
			small.push_back(i);
	}

	// As a note: in the mathematical specification of the algorithm, we
	// will always exhaust the small list before the big list.  However,
	// due to floating point inaccuracies, this is not necessarily true.
	// Consequently, this inner loop (which tries to pair small and large
	// elements) will have to check that both lists aren't empty.
	while (!small.empty() && !large.empty()) {
		// Get the index of the small and the large probabilities.
		int less = small.back();
		small.pop_back();
		int more = large.back();
		large.pop_back();

		alias_[less] = more;

		// Decrease the probability of the larger one by the appropriate
		// amount.
		probability_[more] = (probability_[more] + probability_[less])
				- average;

		// If the new probability is less than the average, add it into the
		// small list; otherwise add it to the large list.
		if (probability_[more] >= average)
			large.push_back(more);
		else
			small.push_back(more);
	}

	// At this point, everything is in one list, which means that the
	// remaining probabilities should all be 1/n.  Based on this, set them
	// appropriately.  Due to numerical issues, we can't be sure which
	// stack will hold the entries, so we empty both.
	while (!small.empty()) {
		probability_[small.back()] = average;
		small.pop_back();
	}
	while (!large.empty()) {
		probability_[large.back()] = average;
		large.pop_back();
	}

	// These probabilities have not yet been scaled up to be such that
	// 1/n is given weight 1.0.  We do this here instead.
	int n = static_cast<int>(probability_.size());
	n = probability_.size();
	//std::transform(probability_.cbegin(), probability_.cend(), probability_.begin(),
	//	[n](double p){ return p * n; });
	for (int i = 0; i < n; i++) {
		probability_[i] = probability_[i] * n;
	}
}
int AliasMethod::next()
	{
		// Generate a fair die roll to determine which column to inspect.
		int column = rnd.nextInt() % probability_.size();

		// Generate a biased coin toss to determine which option to pick.
		bool coinToss = rnd.nextDouble() < probability_[column];

		// Based on the outcome, return either the column or its alias.
		return coinToss? column : alias_[column];
	}
std::vector<int> AliasMethod::getAlias(){
	return alias_;
}
std::vector<double> AliasMethod::getProbability(){
	return probability_;
}
AliasMethod::~AliasMethod() {
	// TODO Auto-generated destructor stub
}

