/*
 * Engine.cpp
 *
 *  Created on: Sep 15, 2015
 *      Author: qixia.yuan
 */

#include "Engine.h"
#include "PBNIO.h"
#include <list>
#include <unistd.h>
#include <stdio.h>
#include <stdlib.h>
#include <stdbool.h>
#include <random>
#include <iostream>

using namespace std;

Engine::Engine() {
	// TODO Auto-generated constructor stub

}
Engine::Engine(PBN pbn) {
	this->pbn=pbn;
	aliasGenerated=false;
	generateAlias();
}
Engine::~Engine() {
	// TODO Auto-generated destructor stub
}
void Engine::pbnNextState(std::vector<bool> &currentState) {
	int n = pbn.getN();
	//printf("n%d",n);
	//int start = 0;
	bool perturbation = false;
	vector<int> cumNf;
	int indexCij;
	std::vector<bool> copySt(currentState);
	if (currentState.size() != n) {
		throw "State size does not coincide with the PBN!";
	}
	//printf("npNode %d",pbn.getNpNode().size());
	/*for (list<int>::iterator i = pbn.getNpNode().begin();
			i != pbn.getNpNode().end(); ++i) {
		for (int j = start; j < *i; j++) {
			if (pbn.getP() > (rand() / ((double) RAND_MAX))) {
				currentState[j] = !currentState[j];
				perturbation = true;
			}
		}
		start=*i+1;
	}*/
	for(int j=0;j<n;j++){
		if (pbn.getP() > (rand() / ((double) RAND_MAX))) {
						currentState[j] = !currentState[j];
						perturbation = true;
					}
	}
	if (perturbation) {
		return;
	} else {
		cumNf = pbn.buildCumNf();
/*		for(int i=0;i<cumNf.size();i++){
			printf("%d ",cumNf[i]);
		}*/
		indexCij = 0; //index of the cij for the current node

		for (int i = 0; i < n; i++) { //each iteration handles a node

			indexCij = am[i].next();
			currentState[i]= pbn.getNextNodeValue(cumNf[i] + indexCij, copySt); //cannot use the current state to do this operation because st is updated each iteration
		}
	}

}

void Engine::generateAlias() {
	if (aliasGenerated) {
		return;
	}
	int non_zero; //number of cij elements for each node
	//Alias alias;

	//alias_method am;//(pbn.getN());
	this->am.resize(pbn.getN());
	//int aliasTableLengthTotal=0;
	for (int i = 0; i < pbn.getN(); i++) {			//each loop handle one node
		non_zero = (pbn).getCij()[i].size();
		//vector<int> y(non_zero);//store the column value
		vector<double> probabilities(non_zero);		// = new double[non_zero];
		for (int j = 0; j < non_zero; j++) {//initilize alias array(z[]), probabilities values(probabilities[])
			//y[j] = j;
			probabilities[j] = pbn.getCij()[i][j];
		}
		am[i].setPro(probabilities);
	}
	aliasGenerated = true;
}

