/*
 * PBN.cpp
 *
 *  Created on: Sep 14, 2015
 *      Author: qixia.yuan
 */

#include "PBN.h"
#include <iostream>
using namespace std;

PBN::PBN() {
	// TODO Auto-generated constructor stub

}

PBN::~PBN() {
	// TODO Auto-generated destructor stub
}

void PBN::setN(int n) {
	this->n = n;
	this->npNode.clear();
	this->npNode.push_back(n);
}

void PBN::setNv(vector<int> nv) {
	this->nv = nv;
}
void PBN::setNf(vector<int> nf) {
	this->nf = nf;
}
void PBN::setCij(vector<vector<float> > cij) {
	this->cij = cij;
}
void PBN::setF(vector<vector<bool> > F) {
	this->F = F;
}
void PBN::setVarF(vector<vector<int> > varF) {
	this->varF = varF;
}
void PBN::setP(float p) {
	this->p = p;
}
int PBN::getN() {
	return n;
}
vector<int> PBN::getNf() {
	return nf;
}
vector<int> PBN::getNv() {
	return nv;
}
vector<vector<bool> > PBN::getF() {
	return F;
}
vector<vector<float> > PBN::getCij() {
	return cij;
}
vector<vector<double> > PBN::getCij_double() {
	vector<vector<double> > cij_double(cij.size());
	for(int i=0;i<cij.size();i++){
		vector<double> element(cij[i].size());
		for(int j=0;j<cij[i].size();j++){
			element[j]=cij[i][j];
		}
		cij_double[i]=element;
	}
	return cij_double;
}
vector<vector<int> > PBN::getVarF() {
	return varF;
}
float PBN::getP() {
	return p;
}
list<int> PBN::getNpNode() {
	return npNode;
}
std::vector<int> PBN::buildCumNf() {
	if (nf.size()==0)
		throw "Cannot build cumNf before nf is initilised.";
	if (cumNf.size()!=0)
		return cumNf;
	cumNf.resize(n + 1);
	cumNf[0] = 0;
	for (int i = 0; i < nf.size(); i++) {
		cumNf[i + 1] = cumNf[i] + nf[i];
	}
	return cumNf;
}
bool PBN::getNextNodeValue(int indexVarF, std::vector<bool> currentState) {
	vector<int> elementVarF;

	vector<bool> elementF;

	elementVarF = varF[indexVarF];
	elementF = F[indexVarF];

	vector<bool> resultState(elementVarF.size());

	for(int i=0;i<resultState.size();i++){
		resultState[i]=currentState[elementVarF[i]];
	}

	return elementF[fromVector(resultState)];
}
int PBN::fromVector(vector<bool> myvector){
    int retval = 0;
    int i =0;
    for (vector<bool>::iterator it = myvector.begin() ; it != myvector.end(); it++,i++){
        if(*it){
            retval |= 1<<i;
        }
    }
    return retval;
}
