/*
 * PBNIO.cpp
 *
 *  Created on: Sep 15, 2015
 *      Author: qixia.yuan
 */

#include "PBNIO.h"
#include <math.h>
#include <list>
#include <iostream>
#include <fstream>
#include <stdexcept>
#include <algorithm>
#include <time.h>
#include "Engine.h"

using namespace std;

PBNIO::PBNIO() {
	// TODO Auto-generated constructor stub
	//generatePBN(3);
	//printPBN();
}

PBNIO::~PBNIO() {
	// TODO Auto-generated destructor stub
}

PBN PBNIO::generatePBN(int n) {

	srand(time(0));

	float p = 0.01;

	pbn.setN(n);

	vector<int> nf(n);
	vector<vector<float> > cij(n);
	float sum;
	int num_rand = 3;
	if (n < num_rand) {
		num_rand = n;
	}
	for (int i = 0; i < pbn.getN(); i++) {
		nf[i] = rand() % num_rand + 1;
		cij[i].resize(nf[i]);
		sum = 0;
		for (int j = 0; j < nf[i]; j++) {
			cij[i][j] = rand() / ((double) RAND_MAX);
			sum += cij[i][j];
		}

		for (int j = 0; j < nf[i]; j++) {
			cij[i][j] = cij[i][j] / sum;
		}
	}
	/*	cout<<"number of selection prob."<<endl;
	 for (int i = 0; i < cij.size(); i++) {
	 for(int j=0;j<cij[i].size();j++){
	 cout<< cij[i][j]<<" ";
	 }
	 cout <<  endl;
	 }
	 cout<<"-------------------"<<endl;*/

	pbn.setNf(nf);
	vector<int> newNf = pbn.getNf();
	int sizeF = 0;
	//cout<<"number of functions"<<endl;
	for (int i = 0; i < newNf.size(); i++) {
		sizeF += newNf[i];
		// cout << newNf[i] << endl;
	}
	// cout<<"-------------------"<<endl;

	vector<int> nv(sizeF);
	vector<vector<bool> > F(sizeF);
	vector<vector<int> > varF(sizeF);
	for (int i = 0; i < sizeF; i++) {
		nv[i] = rand() % num_rand + 1;
		F[i].resize(pow(2, nv[i]));
		varF[i].resize(nv[i]);
		//cout << "number variable " << nv[i] << endl;

		for (int j = 0; j < F[i].size(); j++) {
			if (rand() % 10 > 5) {
				F[i][j] = false;
			} else
				F[i][j] = true;
		}
		varF[i] = randomInt(nv[i], 0, pbn.getN() - 1);

	}

	/*		for (int i = 0; i < sizeF; i++) {
	 cout<< "varF "<<i<<": ";
	 for (int j = 0; j < varF[i].size(); j++)
	 cout << varF[i][j] << " ";
	 cout << endl;
	 }
	 for (int i = 0; i < sizeF; i++) {
	 cout<< "F "<<i<<": ";
	 for (int j = 0; j < F[i].size(); j++)
	 cout << F[i][j] << "   ";
	 cout << endl;
	 }*/
	pbn.setNv(nv);
	pbn.setF(F);
	pbn.setVarF(varF);
	pbn.setCij(cij);
	pbn.setP(p);
	return pbn;
} /* namespace IO */

PBN PBNIO::loadPBN(int n) {

	srand(time(0));

	float p = 0.1;

	pbn.setN(n);

	vector<int> nf(n);
	vector<vector<float> > cij(n);
	nf[0] = 1;
	nf[1] = 3;
	nf[2] = 2;
	cij[0].resize(nf[0]);
	cij[0][0] = 1;
	cij[1].resize(nf[1]);
	cij[1][0] = 0.330136;
	cij[1][1] = 0.2688;
	cij[1][2] = 0.401064;
	cij[2].resize(nf[2]);
	cij[2][0] = 0.647076;
	cij[2][1] = 0.352924;

	p = 0.001;

	pbn.setNf(nf);
	vector<int> newNf = pbn.getNf();
	int sizeF = 0;
	//cout<<"number of functions"<<endl;
	for (int i = 0; i < newNf.size(); i++) {
		sizeF += newNf[i];
		// cout << newNf[i] << endl;
	}
	// cout<<"-------------------"<<endl;

	vector<int> nv(sizeF);
	nv[0] = 2;
	nv[1] = 1;
	nv[2] = 2;
	nv[3] = 3;
	nv[4] = 1;
	nv[5] = 1;

	vector<vector<bool> > F(sizeF);
	vector<vector<int> > varF(sizeF);
	F[0]= {1, 1, 0, 0};
	F[1]= {1, 0};
	F[2]={0, 1, 1, 0};
	F[3]= {0, 0, 1, 1, 1, 0, 0, 1};
	F[4] = {1 ,0};
	F[5] = {1 ,1};

	varF[0]= {0 ,1};
	varF[1]= {0};
	varF[2]= {0 ,2};
	varF[3]= {0 ,1, 2};
	varF[4]= {2};
	varF[5]= {2};
	pbn.setNv(nv);
	pbn.setF(F);
	pbn.setVarF(varF);
	pbn.setCij(cij);
	pbn.setP(p);
	return pbn;
}
PBN PBNIO::loadPBN(std::string fileName) {
	//cout << fileName << '\n';
	std::string line;
	std::string substr = "//";
	ifstream myfile(fileName);
	vector<string> tokens;
	std::string::size_type sz;
	if (myfile.is_open()) {
		getline(myfile, line);
		while (line.find("//") == 0) {
			//cout << line << '\n';
			getline(myfile, line);
		}
		int n = stoi(line, &sz);
		// cout << std::to_string(n) << '\n';
		pbn.setN(n);

		vector<int> nf(n);
		vector<vector<float> > cij(n);

		getline(myfile, line);
		while (line.find("//") == 0) {
			getline(myfile, line);
		}
		Tokenize(line, tokens);
		//cout << line << " line\n";
		//cout << tokens[0]<<endl;
		for (int i = 0; i < n; i++) {
			nf[i] = stoi(tokens[i].c_str());
		}
		pbn.setNf(nf);
		int sizeF = 0;
		for (int i = 0; i < nf.size(); i++) {
			sizeF += nf[i];

		}

		vector<int> nv(sizeF);

		getline(myfile, line);
		while (line.find("//") == 0) {
			getline(myfile, line);
		}
		tokens.clear();
		Tokenize(line, tokens);
		for (int i = 0; i < sizeF; i++) {
			nv[i] = atoi(tokens[i].c_str());
		}
		//cout << to_string(nv[sizeF - 1]) << endl;

		vector<vector<bool> > F(sizeF);
		vector<vector<int> > varF(sizeF);
		for (int i = 0; i < sizeF; i++) {
			getline(myfile, line);
			while (line.find("//") == 0) {
				getline(myfile, line);
			}
			tokens.clear();
			Tokenize(line, tokens);
			vector<bool> elementF(tokens.size());
			//cout << line << endl;
			for (int j = 0; j < tokens.size(); j++) {
				elementF[j] = atoi(tokens[j].c_str());
				//n=stoi(tokens[j])
			}
			F[i] = elementF;
		}

		for (int i = 0; i < sizeF; i++) {
			getline(myfile, line);
			while (line.find("//") == 0) {
				getline(myfile, line);
			}
			tokens.clear();
			Tokenize(line, tokens);
			vector<int> elementVarF(tokens.size());
			for (int j = 0; j < tokens.size(); j++) {
				elementVarF[j] = atoi(tokens[j].c_str());
			}
			varF[i] = elementVarF;
		}

		for (int i = 0; i < n; i++) {
			getline(myfile, line);
			while (line.find("//") == 0) {
				getline(myfile, line);
			}
			tokens.clear();
			Tokenize(line, tokens);
			vector<float> elementCij(tokens.size());
			for (int j = 0; j < tokens.size(); j++) {
				elementCij[j] = atof(tokens[j].c_str());
			}
			cij[i] = elementCij;
		}
		getline(myfile, line);
		while (line.find("//") == 0) {
			getline(myfile, line);
		}
		float p = atof(line.c_str());
		pbn.setNv(nv);
		pbn.setF(F);
		pbn.setVarF(varF);
		pbn.setCij(cij);
		pbn.setP(p);
		myfile.close();
	}
	//printPBN();
	return pbn;
}
vector<int> PBNIO::randomInt(int n, int low, int high) {
	if (low > high) {
		throw invalid_argument("low value cannot be higher than high value");
	}
	if (n < 0 || n > (high - low + 1))
		throw invalid_argument("n must satisfy 0<=n<=high-low+1.");
	int total = high - low + 1;
	int tmp;
	vector<int> result(n);
	vector<int> elements(total);
	for (int i = low; i <= high; i++) {
		elements[i - low] = i;
	}

	vector<int>::iterator iter;
	for (int i = 0; i < n; i++) {
		tmp = rand() % (total - i);
		result[i] = elements[tmp];
		iter = elements.begin() + tmp;
		elements.erase(iter);
	}
	sort(result.begin(), result.end());
	return result;

}
void PBNIO::printPBN() {
	cout << "N: " << pbn.getN() << endl;
	vector<vector<float> > cij = pbn.getCij();
	vector<int> nf = pbn.getNf();
	vector<int> nv = pbn.getNv();
	vector<vector<bool> > F = pbn.getF();
	vector<vector<int> > varF = pbn.getVarF();

	cout << "number of functions" << endl;
	for (int i = 0; i < nf.size(); i++) {
		cout << nf[i] << " ";
		cout << endl;
	}
	cout << "-------------------" << endl;

	cout << "number of variables" << endl;
	for (int i = 0; i < nv.size(); i++) {
		cout << nv[i] << " ";
		cout << endl;
	}
	cout << "-------------------" << endl;

	cout << "var. functions" << endl;
	for (int i = 0; i < varF.size(); i++) {
		cout << "varF " << i << ": ";
		for (int j = 0; j < varF[i].size(); j++)
			cout << varF[i][j] << " ";
		cout << endl;
	}
	cout << "-------------------" << endl;
	cout << "boolean functions" << endl;
	for (int i = 0; i < F.size(); i++) {
		cout << "F " << i << ": ";
		for (int j = 0; j < F[i].size(); j++)
			cout << F[i][j] << "   ";
		cout << endl;
	}
	cout << "-------------------" << endl;

	cout << "number of selection prob." << endl;
	for (int i = 0; i < cij.size(); i++) {
		for (int j = 0; j < cij[i].size(); j++) {
			cout << cij[i][j] << " ";
		}
		cout << endl;
	}
	cout << "-------------------" << endl;

	float p = pbn.getP();
	cout << "p: " << p << endl;
}
void PBNIO::simulate(int length, std::vector<bool> initialState) {
	Engine engine(pbn);
	int n = pbn.getN();
	cout << "Start simulation:" << endl;
	for (int i = 0; i < length; i++) {
		engine.pbnNextState(initialState);
		for (int j = 0; j < n; j++) {
			cout << initialState[j] << " ";
		}
		cout << endl;
	}
	cout << "-------------------" << endl;
}

void PBNIO::Tokenize(const std::string& str, std::vector<std::string>& tokens,
		const std::string& delimiters) {
	// Skip delimiters at beginning.
	string::size_type lastPos = str.find_first_not_of(delimiters, 0);
	// Find first "non-delimiter".
	string::size_type pos = str.find_first_of(delimiters, lastPos);

	while (string::npos != pos || string::npos != lastPos) {
		// Found a token, add it to the vector.
		tokens.push_back(str.substr(lastPos, pos - lastPos));
		// Skip delimiters.  Note the "not_of"
		lastPos = str.find_first_not_of(delimiters, pos);
		// Find next "non-delimiter"
		pos = str.find_first_of(delimiters, lastPos);
	}
}
void PBNIO::loadProperty(std::string fileName, int* positiveIndex,
		int* negativeIndex, int stateSize) {
	std::string line;
	std::string substr = "//";
	ifstream myfile(fileName);
	vector<string> tokens;
	int index;
	int tmp;
	for (int j = 0; j < stateSize; j++) {
		positiveIndex[j] = 0;
		negativeIndex[j] = 0;
	}
	if (myfile.is_open()) {
		getline(myfile, line);
		while (line.find("//") == 0) {
			//cout << line << '\n';
			getline(myfile, line);
		}
		Tokenize(line, tokens);
		//cout << line << " line\n";
		//cout << tokens[0]<<endl;
		for (int i = 0; i < tokens.size(); i++) {
			index = stoi(tokens[i].c_str());
			if (index == -1) {
				break;
			} else {
				tmp = index / 32;
				positiveIndex[tmp] = positiveIndex[tmp] ^ (1 << (index % 32));
			}
		}
		getline(myfile, line);
		while (line.find("//") == 0) {
			//cout << line << '\n';
			getline(myfile, line);
		}
		tokens.clear();
		Tokenize(line, tokens);
		//cout << line << " line\n";
		//cout << tokens[0]<<endl;
		for (int i = 0; i < tokens.size(); i++) {
			index = stoi(tokens[i].c_str());
			if (index == -1) {
				break;
			} else {
				tmp = index / 32;
				negativeIndex[tmp] = negativeIndex[tmp] ^ (1 << (index % 32));
			}
		}
	}
}
void PBNIO::loadProperty(std::string fileName, int* positiveIndex,
		int* negativeIndex, int stateSize,int* order,int n) {
	std::string line;
	std::string substr = "//";
	ifstream myfile(fileName);
	vector<string> tokens;
	int index;
	int tmp;
	for (int j = 0; j < stateSize; j++) {
		positiveIndex[j] = 0;
		negativeIndex[j] = 0;
	}
	if (myfile.is_open()) {
		getline(myfile, line);
		while (line.find("//") == 0) {
			//cout << line << '\n';
			getline(myfile, line);
		}
		Tokenize(line, tokens);
		//cout << line << " line\n";
		//cout << tokens[0]<<endl;
		for (int i = 0; i < tokens.size(); i++) {
			index = stoi(tokens[i].c_str());
			if (index == -1) {
				break;
			} else {
				for(int j=0;j<n;j++){
					if(index==order[j]){
						//cout<<"replace "<<index<<" with "<<j<<endl;
						index=j;
						j=n;
					}
				}
				tmp = index / 32;
				positiveIndex[tmp] = positiveIndex[tmp] ^ (1 << (index % 32));
			}
		}
		getline(myfile, line);
		while (line.find("//") == 0) {
			//cout << line << '\n';
			getline(myfile, line);
		}
		tokens.clear();
		Tokenize(line, tokens);
		//cout << line << " line\n";
		//cout << tokens[0]<<endl;
		for (int i = 0; i < tokens.size(); i++) {
			index = stoi(tokens[i].c_str());
			if (index == -1) {
				break;
			} else {
				for(int j=0;j<n;j++){
									if(index==order[j]){
										//cout<<"replace "<<index<<" with "<<j<<endl;
										index=j;
										j=n;
									}
								}
				tmp = index / 32;
				negativeIndex[tmp] = negativeIndex[tmp] ^ (1 << (index % 32));
			}
		}
	}
}
