/*
 * Decompiled with CFR 0.152.
 */
package lu.uni.minus.preferences;

import java.io.File;
import java.util.Arrays;
import java.util.Comparator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DataSet
implements Comparator<Object> {
    private String name;
    private Type type;
    private File inputPath;
    private File outputPath;

    public DataSet(String name, String type, String inPath, String outPath) {
        this.setName(name);
        this.setType(Type.valueOf(type));
        this.setInputPath(new File(inPath));
        this.setOutputPath(new File(outPath));
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Type getType() {
        return this.type;
    }

    public void setType(Type type) {
        this.type = type;
    }

    public File getInputPath() {
        return this.inputPath;
    }

    public void setInputPath(File inputPath) {
        this.inputPath = inputPath;
    }

    public File getOutputPath() {
        return this.outputPath;
    }

    public void setOutputPath(File outputPath) {
        this.outputPath = outputPath;
    }

    public String toString() {
        return this.name;
    }

    @Override
    public boolean equals(Object ds) {
        return this.name.equalsIgnoreCase(((DataSet)ds).getName());
    }

    @Override
    public int compare(Object ds1, Object ds2) {
        return ((DataSet)ds1).getName().compareToIgnoreCase(((DataSet)ds2).getName());
    }

    public File createDistRoIDir(String paraSetting, String roiFile) {
        File result = this.getType().equals((Object)Type.GPS) ? new File(this.getOutputPath() + File.separator + "Dist" + File.separator + paraSetting + File.separator + roiFile) : new File(this.getOutputPath() + File.separator + "Dist" + File.separator + roiFile);
        if (!result.exists()) {
            result.mkdirs();
        }
        return result;
    }

    public File createDistDir(String paraSetting) {
        File result = this.getType().equals((Object)Type.GPS) ? new File(this.getOutputPath() + File.separator + "Dist" + File.separator + paraSetting) : new File(this.getOutputPath() + File.separator + "Dist");
        if (!result.exists()) {
            result.mkdirs();
        }
        return result;
    }

    public File createPatternDir() {
        File result = new File(this.getOutputPath() + File.separator + "PatternSets");
        if (!result.exists()) {
            result.mkdirs();
        }
        return result;
    }

    public String[] getSPList() {
        if (this.getType().equals((Object)Type.GPS)) {
            File spDir = new File(this.getOutputPath() + File.separator + "StayPoints");
            if (!spDir.exists()) {
                spDir.mkdirs();
            }
            Object[] result = spDir.list();
            Arrays.sort(result);
            return result;
        }
        return null;
    }

    public File[] getSPFiles() {
        if (this.getType().equals((Object)Type.GPS)) {
            File spDir = new File(this.getOutputPath() + File.separator + "StayPoints");
            if (!spDir.exists()) {
                spDir.mkdirs();
            }
            Object[] result = spDir.listFiles();
            Arrays.sort(result);
            return result;
        }
        return null;
    }

    public String[] getRoiList() {
        if (this.getType().equals((Object)Type.GPS)) {
            File spDir = new File(this.getOutputPath() + File.separator + "RoIs");
            if (!spDir.exists()) {
                spDir.mkdirs();
            }
            Object[] result = spDir.list();
            Arrays.sort(result);
            return result;
        }
        return null;
    }

    public File getFPSDir(int selected, String paraSetting, String roiFile, double threshold, double tolerance, double side) {
        String ending = "";
        if (selected == -1) {
            ending = String.valueOf(threshold) + "_" + tolerance + "_" + side + "_" + "_AllDays";
        } else if (selected == 1) {
            ending = String.valueOf(threshold) + "_" + tolerance + "_" + side + "_" + "_Weekdays";
        }
        if (selected == 0) {
            ending = String.valueOf(threshold) + "_" + tolerance + "_" + side + "_" + "_Weekends";
        }
        if (this.getType() == Type.GPS) {
            return new File(this.getOutputPath() + File.separator + "PatternSets" + File.separator + paraSetting + File.separator + roiFile + File.separator + ending);
        }
        return new File(this.getOutputPath() + File.separator + "PatternSets" + File.separator + roiFile + File.separator + ending);
    }

    public boolean isRoiDir(String selectedPara) {
        File result = this.getType() == Type.GPS ? new File(this.getOutputPath() + File.separator + "RoIs" + File.separator + selectedPara) : new File(this.getOutputPath() + File.separator + "RoIs");
        return result.exists();
    }

    public File createRoIDir(String selectedPara) {
        File result = this.getType() == Type.GPS ? new File(this.getOutputPath() + File.separator + "RoIs" + File.separator + selectedPara) : new File(this.getOutputPath() + File.separator + "RoIs");
        if (!result.exists()) {
            result.mkdirs();
        }
        return result;
    }

    public File createStatRoIDir(String selectedPara) {
        File result = this.getType() == Type.GPS ? new File(this.getOutputPath() + File.separator + "Stats" + File.separator + "RoIs" + File.separator + selectedPara) : new File(this.getOutputPath() + File.separator + "Stats" + File.separator + "RoIs");
        if (!result.exists()) {
            result.mkdirs();
        }
        return result;
    }

    public File getSPFile(String selectedPara, String user) {
        if (this.getType().equals((Object)Type.SP)) {
            return new File(this.getInputPath() + File.separator + user + ".txt");
        }
        if (selectedPara == null) {
            return null;
        }
        return new File(this.getOutputPath() + File.separator + "StayPoints" + File.separator + selectedPara + File.separator + user + ".txt");
    }

    public String[] getSPUsers(String sp) {
        if (this.getType().equals((Object)Type.GPS)) {
            File spDir = new File(this.getOutputPath() + File.separator + "StayPoints" + File.separator + sp);
            Object[] result = spDir.list();
            this.strip((String[])result);
            Arrays.sort(result);
            return result;
        }
        return null;
    }

    public String[] getUserList() {
        Object[] result = this.getInputPath().list();
        if (this.getType().equals((Object)Type.SP)) {
            this.strip((String[])result);
        }
        Arrays.sort(result);
        return result;
    }

    public File getUserInDir(String user) {
        if (this.getType().equals((Object)Type.GPS)) {
            File result = new File(this.getInputPath() + File.separator + user + File.separator + "Trajectory");
            return result;
        }
        return null;
    }

    public File createOutputSPDir() {
        File result = new File(this.getOutputPath() + File.separator + "Stats" + File.separator + "SourceDataAndStayPoints");
        if (!result.exists()) {
            result.mkdirs();
        }
        return result;
    }

    public File createSPDir(String distance, String time, String threshold) {
        File result = this.getSPDir(distance, time, threshold);
        if (!result.exists()) {
            result.mkdirs();
        }
        return result;
    }

    private void strip(String[] list) {
        int i = 0;
        while (i < list.length) {
            list[i] = list[i].substring(0, 3);
            ++i;
        }
    }

    public File getSPDir(String distance, String time, String threshold) {
        File result = new File(this.getOutputPath() + File.separator + "StayPoints" + File.separator + distance + "_" + time + "_" + threshold);
        return result;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Type {
        SP,
        GPS;

    }
}

