/*
 * Decompiled with CFR 0.152.
 */
package lu.uni.minus.ui;

import java.awt.Color;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.net.URL;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.KeyStroke;
import javax.swing.border.Border;
import lu.uni.minus.Main;

public class AboutDialog
extends JDialog {
    private static final long serialVersionUID = -6414657787197465221L;

    public AboutDialog(JFrame parent) {
        super(parent);
        this.initCloseListener();
        this.initUI();
    }

    public final void initUI() {
        JPanel mainPane = new JPanel();
        Border paneEdge = BorderFactory.createEmptyBorder(20, 20, 20, 20);
        mainPane.setBorder(paneEdge);
        mainPane.setBackground(Color.white);
        mainPane.setOpaque(true);
        mainPane.setLayout(new BoxLayout(mainPane, 1));
        String version = AboutDialog.getVersionInfo();
        JLabel name = new JLabel("MinUS Tool " + version);
        name.setFont(new Font("Serif", 1, 14));
        name.setAlignmentX(0.5f);
        mainPane.add(name);
        mainPane.add(Box.createRigidArea(new Dimension(0, 10)));
        ImageIcon icon = this.createImageIcon("/icons/uniLogo.png", "University of Luxembourg");
        JLabel label = new JLabel(icon);
        label.setAlignmentX(0.5f);
        mainPane.add(label);
        mainPane.add(Box.createRigidArea(new Dimension(0, 10)));
        name = new JLabel("<html>This program is directed by Dr. Jun Pang and Xihui Chen.<br/>The code is contributed by Xihui Chen, Piotr Kordy, Ruipeng Lu, and Ran Xue.<br/>This program uses the T-pattern mining tool coded by<br/>Mirco Nanni and Fabio Pinelli of the University of Pisa, Italy.<br/><br/>This program belongs to the SaToSS group of the University of Luxembourg.<br/></html>");
        name.setFont(new Font("Serif", 0, 13));
        name.setAlignmentX(0.5f);
        mainPane.add(name);
        mainPane.add(Box.createRigidArea(new Dimension(0, 10)));
        JButton close = new JButton("Close");
        close.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                AboutDialog.this.dispose();
            }
        });
        close.setAlignmentX(0.5f);
        mainPane.add(close);
        this.add(mainPane);
        this.setModalityType(Dialog.ModalityType.APPLICATION_MODAL);
        this.setTitle("About the MinUS Tool " + version);
        this.setDefaultCloseOperation(2);
        this.setLocationRelativeTo(null);
        this.pack();
    }

    private void initCloseListener() {
        this.getRootPane().getInputMap(2).put(KeyStroke.getKeyStroke(27, 0), "close");
        this.getRootPane().getInputMap(2).put(KeyStroke.getKeyStroke(10, 0), "close");
        this.getRootPane().getActionMap().put("close", new AbstractAction(){
            private static final long serialVersionUID = 2143956335533214473L;

            public void actionPerformed(ActionEvent e) {
                AboutDialog.this.dispose();
            }
        });
    }

    public static String getVersionInfo() {
        String classPath;
        String result;
        block3: {
            result = "";
            Class<Main> clazz = Main.class;
            String className = String.valueOf(clazz.getSimpleName()) + ".class";
            classPath = clazz.getResource(className).toString();
            if (classPath.startsWith("jar")) break block3;
            return "No version info";
        }
        try {
            String manifestPath = String.valueOf(classPath.substring(0, classPath.lastIndexOf("!") + 1)) + "/META-INF/MANIFEST.MF";
            Manifest manifest = new Manifest(new URL(manifestPath).openStream());
            Attributes mainAttribs = manifest.getMainAttributes();
            result = String.valueOf(result) + mainAttribs.getValue("Implementation-Version") + " (";
            result = String.valueOf(result) + mainAttribs.getValue("Date-Build") + ")";
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return result;
    }

    private ImageIcon createImageIcon(String path, String description) {
        URL imgURL = this.getClass().getResource(path);
        if (imgURL != null) {
            return new ImageIcon(imgURL, description);
        }
        System.err.println("Couldn't find file: " + path);
        return null;
    }
}

