/*
 * Decompiled with CFR 0.152.
 */
package lu.uni.minus.ui;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.IOException;
import java.util.concurrent.ExecutionException;
import javax.swing.BoxLayout;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.SwingWorker;
import javax.swing.border.TitledBorder;
import lu.uni.minus.preferences.DataSet;
import lu.uni.minus.ui.DSPanel;
import lu.uni.minus.ui.MainWindow;
import lu.uni.minus.ui.ProgressDialog;
import lu.uni.minus.utils.ValidityWorker;

public class AddDSPane
extends DSPanel {
    private static final long serialVersionUID = 2198569380922887957L;
    private JTextField textInputPath;
    private JTextField textOutputPath;
    private JTextField textName;
    private JButton btnAdd = new JButton("Add");
    private ProgressDialog pd = null;
    private DataSet ds;
    private ValidityWorker worker;

    public AddDSPane(MainWindow aParent) {
        super(aParent);
        JPanel contentPanel = new JPanel();
        contentPanel.setBorder(new TitledBorder(null, "Add a new dataset", 4, 2, null, null));
        this.add((Component)contentPanel, "North");
        contentPanel.setLayout(new BoxLayout(contentPanel, 1));
        JPanel namePanel = new JPanel();
        contentPanel.add(namePanel);
        GridBagLayout gbl_namePanel = new GridBagLayout();
        int[] nArray = new int[6];
        nArray[0] = 31;
        nArray[1] = 150;
        gbl_namePanel.columnWidths = nArray;
        int[] nArray2 = new int[2];
        nArray2[0] = 23;
        gbl_namePanel.rowHeights = nArray2;
        gbl_namePanel.columnWeights = new double[]{0.0, 0.0, 0.0, 0.0, 0.0, Double.MIN_VALUE};
        gbl_namePanel.rowWeights = new double[]{0.0, Double.MIN_VALUE};
        namePanel.setLayout(gbl_namePanel);
        JLabel lblName = new JLabel("Name:");
        GridBagConstraints gbc_lblName = new GridBagConstraints();
        gbc_lblName.anchor = 13;
        gbc_lblName.insets = new Insets(0, 53, 0, 5);
        gbc_lblName.gridx = 0;
        gbc_lblName.gridy = 0;
        namePanel.add((Component)lblName, gbc_lblName);
        this.textName = new JTextField();
        GridBagConstraints gbc_textName = new GridBagConstraints();
        gbc_textName.insets = new Insets(0, 0, 0, 5);
        gbc_textName.fill = 2;
        gbc_textName.gridx = 1;
        gbc_textName.gridy = 0;
        namePanel.add((Component)this.textName, gbc_textName);
        this.textName.setColumns(10);
        JLabel lblType = new JLabel("Type:");
        GridBagConstraints gbc_lblType = new GridBagConstraints();
        gbc_lblType.insets = new Insets(0, 0, 0, 5);
        gbc_lblType.anchor = 13;
        gbc_lblType.gridx = 3;
        gbc_lblType.gridy = 0;
        namePanel.add((Component)lblType, gbc_lblType);
        final JComboBox<String> comboBox = new JComboBox<String>();
        comboBox.setModel(new DefaultComboBoxModel<String>(new String[]{"GPS point", "Stay point"}));
        GridBagConstraints gbc_comboBox = new GridBagConstraints();
        gbc_comboBox.fill = 2;
        gbc_comboBox.gridx = 4;
        gbc_comboBox.gridy = 0;
        namePanel.add(comboBox, gbc_comboBox);
        JPanel inputPathPanel = new JPanel();
        contentPanel.add(inputPathPanel);
        GridBagLayout gbl_panel_1 = new GridBagLayout();
        int[] nArray3 = new int[4];
        nArray3[0] = 55;
        nArray3[1] = 200;
        nArray3[2] = 61;
        gbl_panel_1.columnWidths = nArray3;
        int[] nArray4 = new int[2];
        nArray4[0] = 23;
        gbl_panel_1.rowHeights = nArray4;
        gbl_panel_1.columnWeights = new double[]{0.0, 0.0, 0.0, Double.MIN_VALUE};
        gbl_panel_1.rowWeights = new double[]{0.0, Double.MIN_VALUE};
        inputPathPanel.setLayout(gbl_panel_1);
        JLabel lblInputDirectory = new JLabel("Input directory:");
        GridBagConstraints gbc_lblInputDirectory = new GridBagConstraints();
        gbc_lblInputDirectory.anchor = 13;
        gbc_lblInputDirectory.insets = new Insets(0, 8, 0, 5);
        gbc_lblInputDirectory.gridx = 0;
        gbc_lblInputDirectory.gridy = 0;
        inputPathPanel.add((Component)lblInputDirectory, gbc_lblInputDirectory);
        this.textInputPath = new JTextField();
        try {
            this.textInputPath.setText(new File(".").getCanonicalPath());
        }
        catch (IOException e1) {
            e1.printStackTrace();
        }
        this.textInputPath.setEditable(true);
        GridBagConstraints gbc_textInputPath = new GridBagConstraints();
        gbc_textInputPath.weightx = 1.0;
        gbc_textInputPath.fill = 2;
        gbc_textInputPath.insets = new Insets(0, 0, 0, 5);
        gbc_textInputPath.gridx = 1;
        gbc_textInputPath.gridy = 0;
        inputPathPanel.add((Component)this.textInputPath, gbc_textInputPath);
        this.textInputPath.setColumns(10);
        JButton btnInputPath = new JButton("Select");
        btnInputPath.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                AddDSPane.this.textInputPath.setText(AddDSPane.this.openADirectoryDialog(AddDSPane.this.textInputPath.getText()));
            }
        });
        GridBagConstraints gbc_btnInputPath = new GridBagConstraints();
        gbc_btnInputPath.anchor = 12;
        gbc_btnInputPath.gridx = 2;
        gbc_btnInputPath.gridy = 0;
        inputPathPanel.add((Component)btnInputPath, gbc_btnInputPath);
        JPanel panel_2 = new JPanel();
        contentPanel.add(panel_2);
        GridBagLayout gbl_panel_2 = new GridBagLayout();
        int[] nArray5 = new int[4];
        nArray5[0] = 84;
        nArray5[1] = 86;
        nArray5[2] = 61;
        gbl_panel_2.columnWidths = nArray5;
        int[] nArray6 = new int[2];
        nArray6[0] = 23;
        gbl_panel_2.rowHeights = nArray6;
        gbl_panel_2.columnWeights = new double[]{0.0, 0.0, 0.0, Double.MIN_VALUE};
        gbl_panel_2.rowWeights = new double[]{0.0, Double.MIN_VALUE};
        panel_2.setLayout(gbl_panel_2);
        JLabel lblOutputDirectory = new JLabel("Output directory:");
        GridBagConstraints gbc_lblOutputDirectory = new GridBagConstraints();
        gbc_lblOutputDirectory.anchor = 13;
        gbc_lblOutputDirectory.insets = new Insets(0, 0, 0, 5);
        gbc_lblOutputDirectory.gridx = 0;
        gbc_lblOutputDirectory.gridy = 0;
        panel_2.add((Component)lblOutputDirectory, gbc_lblOutputDirectory);
        this.textOutputPath = new JTextField();
        try {
            this.textOutputPath.setText(new File(".").getCanonicalPath());
        }
        catch (IOException e1) {
            e1.printStackTrace();
        }
        this.textOutputPath.setEditable(true);
        GridBagConstraints gbc_textField_1 = new GridBagConstraints();
        gbc_textField_1.fill = 2;
        gbc_textField_1.weightx = 1.0;
        gbc_textField_1.insets = new Insets(0, 0, 0, 5);
        gbc_textField_1.gridx = 1;
        gbc_textField_1.gridy = 0;
        panel_2.add((Component)this.textOutputPath, gbc_textField_1);
        this.textOutputPath.setColumns(10);
        JButton btnSelect_1 = new JButton("Select");
        btnSelect_1.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                File inputDir;
                String selectedDir = AddDSPane.this.openADirectoryDialog(AddDSPane.this.textOutputPath.getText());
                if (!selectedDir.isEmpty() && (inputDir = new File(selectedDir)).exists()) {
                    if (inputDir.list().length != 0) {
                        JOptionPane.showMessageDialog(AddDSPane.this, "The output directory is not empty.", "Invalid output directory", 0);
                        return;
                    }
                    AddDSPane.this.textOutputPath.setText(inputDir.getAbsolutePath());
                }
            }
        });
        GridBagConstraints gbc_btnSelect_1 = new GridBagConstraints();
        gbc_btnSelect_1.anchor = 12;
        gbc_btnSelect_1.gridx = 2;
        gbc_btnSelect_1.gridy = 0;
        panel_2.add((Component)btnSelect_1, gbc_btnSelect_1);
        JPanel btnPanel = new JPanel();
        contentPanel.add(btnPanel);
        final AddDSPane me = this;
        this.btnAdd.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                String type = (String)comboBox.getSelectedItem();
                if (type == null) {
                    JOptionPane.showMessageDialog(null, "You haven't chosen a dataset type.", "Choose a type", 1);
                    return;
                }
                String name = AddDSPane.this.textName.getText().trim();
                String inputPath = AddDSPane.this.textInputPath.getText().trim();
                String outputPath = AddDSPane.this.textOutputPath.getText().trim();
                if (name.isEmpty()) {
                    JOptionPane.showMessageDialog(null, "You haven't filled in the dataset's name.", "Fill in a name", 1);
                    return;
                }
                if (inputPath.isEmpty()) {
                    JOptionPane.showMessageDialog(null, "You haven't chosen an input directory.", "Choose an input directory", 1);
                    return;
                }
                if (outputPath.isEmpty()) {
                    JOptionPane.showMessageDialog(null, "You haven't chosen an output directory.", "Choose an output directory", 1);
                    return;
                }
                if (type.equals("GPS point")) {
                    AddDSPane.this.ds = new DataSet(name, "GPS", inputPath, outputPath);
                } else {
                    AddDSPane.this.ds = new DataSet(name, "SP", inputPath, outputPath);
                }
                AddDSPane.this.worker = new ValidityWorker(AddDSPane.this.ds, me);
                AddDSPane.this.btnAdd.setEnabled(false);
                AddDSPane.this.pd = new ProgressDialog(AddDSPane.this.mw, AddDSPane.this.worker);
                AddDSPane.this.worker.setAnnouncer(AddDSPane.this.pd);
                AddDSPane.this.worker.addPropertyChangeListener(new PropertyChangeListener(){

                    public void propertyChange(PropertyChangeEvent event) {
                        if (event.getPropertyName().equals("progress")) {
                            AddDSPane.this.pd.setIndeterminate(false);
                            AddDSPane.this.pd.setProgress((Integer)event.getNewValue());
                        } else if (event.getPropertyName().equals("state")) {
                            switch ((SwingWorker.StateValue)((Object)event.getNewValue())) {
                                case DONE: {
                                    AddDSPane.this.workDone();
                                    break;
                                }
                                case PENDING: 
                                case STARTED: {
                                    AddDSPane.this.pd.setButtonText("Cancel");
                                    AddDSPane.this.pd.setIndeterminate(true);
                                }
                            }
                        }
                    }
                });
                AddDSPane.this.worker.execute();
            }
        });
        btnPanel.add(this.btnAdd);
        JButton btnClear = new JButton("Clear");
        btnClear.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                AddDSPane.this.textInputPath.setText("");
                AddDSPane.this.textOutputPath.setText("");
                AddDSPane.this.textName.setText("");
            }
        });
        btnPanel.add(btnClear);
        JButton btnCancel = new JButton("Cancel");
        btnCancel.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                AddDSPane.this.mw.goHome();
            }
        });
        btnPanel.add(btnCancel);
        JLabel lblNewLabel = new JLabel("<html>\r\nThe dataset to be added should conform to one of the following two types of formats:\r\n<br>\r\n<br><b>GPS point type: (for example look at Geolife dataset)</b><br><p>The input directory contains subfolders each of which is for one user and whose names are the users' three-digit numbered IDs, like 003. In each user's subfolder there is one folder named \"Trajectory\", in which each file is his GPS point trajectory in one day, or part of it. The first eight characters of each filename are the date of the day, like 20090909.</p><br><b>Stay point type: (for example look at Yonsei dataset)</b><br><p>The input directory contains files each of which is one user's stay point trajectories. Each filename is the user's three-digit numbered ID, like 003.</p></html>");
        lblNewLabel.setVerticalAlignment(1);
        this.add((Component)lblNewLabel, "Center");
    }

    public JButton getBtnAdd() {
        return this.btnAdd;
    }

    public void setBtnAdd(JButton btnAdd) {
        this.btnAdd = btnAdd;
    }

    private void workDone() {
        this.pd.setButtonText("Close");
        int result = -2;
        try {
            result = (Integer)this.worker.get();
        }
        catch (InterruptedException e1) {
            result = -1;
            this.worker.addErrorMessage(e1.getMessage());
        }
        catch (ExecutionException e1) {
            result = -1;
            this.worker.addErrorMessage(e1.getMessage());
        }
        if (result == 0) {
            this.mw.getDataSetPane().addDataSet(this.ds);
            this.mw.goHome();
        }
        this.btnAdd.setEnabled(true);
    }
}

