/*
 * Decompiled with CFR 0.152.
 */
package lu.uni.minus.ui;

import java.awt.BorderLayout;
import java.awt.HeadlessException;
import java.awt.event.ActionEvent;
import java.io.IOException;
import java.util.Enumeration;
import javax.swing.AbstractAction;
import javax.swing.JFileChooser;
import javax.swing.JPanel;
import javax.swing.KeyStroke;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import lu.uni.minus.preferences.DataSet;
import lu.uni.minus.ui.MainWindow;

public class DSPanel
extends JPanel {
    private static final long serialVersionUID = 5499601819450914301L;
    protected MainWindow mw;

    public DSPanel(MainWindow aParent) {
        this.mw = aParent;
        this.initCloseListener();
        this.setLayout(new BorderLayout(0, 0));
    }

    protected String openADirectoryDialog(String path) {
        JFileChooser parseDir = new JFileChooser(path);
        parseDir.setFileSelectionMode(1);
        try {
            int returnValue = parseDir.showOpenDialog(this);
            if (returnValue == 0) {
                return parseDir.getSelectedFile().getAbsolutePath();
            }
            return path;
        }
        catch (HeadlessException e) {
            e.printStackTrace();
            return "";
        }
    }

    public String isIncluded(DataSet ds) {
        DefaultTreeModel treeModel = (DefaultTreeModel)this.mw.getDataSetPane().getTree().getModel();
        DefaultMutableTreeNode root = (DefaultMutableTreeNode)treeModel.getRoot();
        Enumeration<TreeNode> currentDatasets = root.children();
        while (currentDatasets.hasMoreElements()) {
            DataSet aCurrentDataset = (DataSet)((DefaultMutableTreeNode)currentDatasets.nextElement()).getUserObject();
            if (ds.equals(aCurrentDataset)) {
                return "A dataset with the name \"" + ds.getName() + "\" already exists";
            }
            try {
                if (ds.getInputPath().getCanonicalPath().equals(aCurrentDataset.getInputPath().getCanonicalPath())) {
                    return "A dataset with the input directory \"" + ds.getInputPath().toString() + "\" already exists";
                }
                if (!ds.getOutputPath().getCanonicalPath().equals(aCurrentDataset.getOutputPath().getCanonicalPath())) continue;
                return "A dataset with the output directory \"" + ds.getOutputPath().toString() + "\" already exists";
            }
            catch (IOException e) {
                return e.getMessage();
            }
        }
        return null;
    }

    private void initCloseListener() {
        this.getInputMap(2).put(KeyStroke.getKeyStroke(27, 0), "Cancel");
        this.getActionMap().put("Cancel", new AbstractAction(){
            private static final long serialVersionUID = 2143956335533214473L;

            public void actionPerformed(ActionEvent e) {
                DSPanel.this.mw.goHome();
            }
        });
    }
}

