/*
 * Decompiled with CFR 0.152.
 */
package lu.uni.minus.ui;

import java.awt.Dimension;
import java.util.ArrayList;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import lu.uni.minus.preferences.DataSet;
import lu.uni.minus.preferences.Settings;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DataSetsPanel
extends JScrollPane {
    private static final long serialVersionUID = 3843103137661347215L;
    private JTree tree;
    private Settings settings;

    public DataSetsPanel(Settings s) {
        this.settings = s;
        this.fillTree(this.settings.getDatasets());
        this.setPreferredSize(new Dimension(100, 300));
        this.setMinimumSize(new Dimension(100, 300));
    }

    public void fillTree(ArrayList<DataSet> ar) {
        DefaultMutableTreeNode root = new DefaultMutableTreeNode("All datasets");
        for (DataSet a : ar) {
            DefaultMutableTreeNode aNode = new DefaultMutableTreeNode(a, false);
            root.add(aNode);
        }
        this.tree = new JTree(root, true);
        this.tree.getSelectionModel().setSelectionMode(1);
        this.setViewportView(this.tree);
    }

    public void addDataSet(DataSet ds) {
        this.settings.addDataSet(ds);
        DefaultMutableTreeNode newNode = new DefaultMutableTreeNode(ds, false);
        DefaultTreeModel treeModel = (DefaultTreeModel)this.tree.getModel();
        DefaultMutableTreeNode root = (DefaultMutableTreeNode)treeModel.getRoot();
        treeModel.insertNodeInto(newNode, root, root.getChildCount());
    }

    public JTree getTree() {
        return this.tree;
    }

    public DefaultMutableTreeNode getSelected() {
        DefaultMutableTreeNode selectedNode = (DefaultMutableTreeNode)this.tree.getLastSelectedPathComponent();
        if (selectedNode == null || selectedNode.isRoot()) {
            return null;
        }
        return selectedNode;
    }

    public void setTree(JTree tree) {
        this.tree = tree;
    }
}

