/*
 * Decompiled with CFR 0.152.
 */
package lu.uni.minus.ui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTextField;
import javax.swing.JTextPane;
import javax.swing.SwingWorker;
import javax.swing.border.TitledBorder;
import javax.swing.text.BadLocationException;
import javax.swing.text.html.HTMLDocument;
import javax.swing.text.html.HTMLEditorKit;
import lu.uni.minus.preferences.DataSet;
import lu.uni.minus.ui.Announcer;
import lu.uni.minus.ui.MainWindow;
import lu.uni.minus.utils.TextPaneWorker;
import lu.uni.minus.utils.sp.SPDetectWorker;

public class DetectSPPanel
extends JPanel
implements Announcer {
    private static final long serialVersionUID = -6186413526615829959L;
    private final MainWindow mw;
    private final Dimension space = new Dimension(6, 6);
    private JTextField tfDistance;
    private JTextField tfTime;
    private JTextField tfThreshold;
    private JButton btnStart;
    private JButton btnCancel;
    private Action cancelAction;
    private JTextPane messageArea;
    private JProgressBar progressBar;
    private TextPaneWorker worker;
    private HTMLEditorKit kit;
    private HTMLDocument doc;
    private DataSet dataset;

    public DetectSPPanel(MainWindow aMw, DataSet aDataset) {
        this.mw = aMw;
        this.dataset = aDataset;
        this.createGui();
    }

    private void createGui() {
        JSplitPane splitPane = new JSplitPane();
        this.setLayout(new BorderLayout(0, 0));
        this.add((Component)splitPane, "Center");
        JPanel mainPanel = new JPanel();
        mainPanel.setLayout(new BoxLayout(mainPanel, 1));
        JPanel titlePanel = new JPanel();
        titlePanel.setLayout(new BoxLayout(titlePanel, 0));
        titlePanel.setBorder(new TitledBorder(null, "Parameters for detecting stay points of Geolife", 4, 2, null, null));
        JPanel leftPanel = new JPanel();
        leftPanel.setLayout(new BoxLayout(leftPanel, 1));
        leftPanel.setMaximumSize(new Dimension(250, 100));
        leftPanel.add(this.createLabelPanel("Distance threshold :"));
        leftPanel.add(Box.createRigidArea(this.space));
        leftPanel.add(this.createLabelPanel("Time threshold :"));
        leftPanel.add(Box.createRigidArea(this.space));
        leftPanel.add(this.createLabelPanel("Stay point merging threshold :"));
        leftPanel.add(Box.createRigidArea(this.space));
        titlePanel.add(leftPanel);
        JPanel rightPanel = new JPanel();
        rightPanel.setLayout(new BoxLayout(rightPanel, 1));
        Dimension fieldSize = new Dimension(100, 20);
        this.tfDistance = new JTextField("30");
        this.tfDistance.setPreferredSize(fieldSize);
        this.tfDistance.setMaximumSize(fieldSize);
        this.tfDistance.setToolTipText("<html>\r\nIt is the minimum time length that a continuous set of GPS points lasts to be a stay\r\n<br/>\r\n point. A typical value is 30.\r\n<html/>");
        this.tfTime = new JTextField("100");
        this.tfTime.setPreferredSize(fieldSize);
        this.tfTime.setMaximumSize(fieldSize);
        this.tfTime.setToolTipText("<html>\r\nIt is the maximum distance between the first point and the last point of a \r\n<br/>\r\ncontinuous set of GPS points for them to be a stay point. Typical values are \r\n<br/>\r\nintegers like 100, 150 and 200.\r\n</html>");
        this.tfThreshold = new JTextField("30");
        this.tfThreshold.setPreferredSize(fieldSize);
        this.tfThreshold.setMaximumSize(fieldSize);
        this.tfThreshold.setToolTipText("<html>\r\nIt is the maximum distance for two preliminary stay points to be merged into one.\r\n<br/>\r\nA common practice is to make it take the same value as the distance threshold.\r\n<html/>");
        rightPanel.add(this.createComponentPanel(this.tfDistance, " m"));
        rightPanel.add(this.createComponentPanel(this.tfTime, " s"));
        rightPanel.add(this.createComponentPanel(this.tfThreshold, " m"));
        titlePanel.add(rightPanel);
        titlePanel.add(Box.createHorizontalGlue());
        mainPanel.add(titlePanel);
        JScrollPane scrollMessage = new JScrollPane();
        this.messageArea = new JTextPane();
        this.messageArea.setPreferredSize(new Dimension(300, 200));
        this.messageArea.setContentType("text/html");
        this.messageArea.setEditable(false);
        this.kit = new HTMLEditorKit();
        this.messageArea.setEditorKit(this.kit);
        this.doc = new HTMLDocument();
        this.messageArea.setDocument(this.doc);
        scrollMessage.setViewportView(this.messageArea);
        mainPanel.add(scrollMessage);
        splitPane.setRightComponent(mainPanel);
        JPanel usersPanel = new JPanel();
        usersPanel.setBorder(null);
        usersPanel.setLayout(new BorderLayout(0, 0));
        JScrollPane scrollPane = new JScrollPane();
        usersPanel.add((Component)new JLabel("User list:"), "North");
        usersPanel.add((Component)scrollPane, "Center");
        final JList<String> usersList = new JList<String>();
        usersList.setListData(this.dataset.getUserList());
        scrollPane.setViewportView(usersList);
        usersPanel.setPreferredSize(new Dimension(100, 500));
        splitPane.setLeftComponent(usersPanel);
        JPanel buttonPanel = new JPanel();
        buttonPanel.setLayout(new BoxLayout(buttonPanel, 0));
        buttonPanel.add(Box.createRigidArea(this.space));
        this.progressBar = new JProgressBar(0, 100);
        this.progressBar.setStringPainted(true);
        this.progressBar.setVisible(false);
        this.progressBar.setPreferredSize(new Dimension(800, 20));
        buttonPanel.add(Box.createHorizontalGlue());
        buttonPanel.add(this.progressBar);
        buttonPanel.add(Box.createHorizontalGlue());
        this.btnStart = new JButton("Start");
        final DetectSPPanel me = this;
        this.btnStart.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ArrayList<String> filteredList;
                DetectSPPanel.this.messageArea.setText("");
                List selectedList = usersList.getSelectedValuesList();
                if (selectedList.size() == 0) {
                    JOptionPane.showMessageDialog(null, "Please first choose some users.", "Choose users", 1);
                    return;
                }
                double distanceThreshold = Double.parseDouble(DetectSPPanel.this.tfDistance.getText().trim());
                double timeThreshold = Double.parseDouble(DetectSPPanel.this.tfTime.getText().trim());
                double mergingThreshold = Double.parseDouble(DetectSPPanel.this.tfThreshold.getText().trim());
                if (distanceThreshold <= 0.0 || timeThreshold <= 0.0 || mergingThreshold <= 0.0) {
                    JOptionPane.showMessageDialog(null, "The thresholds must be positive numbers.", "Number format error", 0);
                    return;
                }
                File spDir = DetectSPPanel.this.dataset.getSPDir(DetectSPPanel.this.tfDistance.getText(), DetectSPPanel.this.tfTime.getText(), DetectSPPanel.this.tfThreshold.getText());
                if (spDir.exists()) {
                    filteredList = new ArrayList<String>();
                    HashSet<String> doneUsers = new HashSet<String>(Arrays.asList(spDir.list()));
                    if (doneUsers.size() > 0) {
                        for (String user : selectedList) {
                            if (doneUsers.contains(String.valueOf(user) + ".txt")) continue;
                            filteredList.add(user);
                        }
                    }
                } else {
                    filteredList = new ArrayList(selectedList);
                }
                if (filteredList.size() > 0) {
                    DetectSPPanel.this.btnStart.setEnabled(false);
                    DetectSPPanel.this.btnCancel.setEnabled(true);
                    DetectSPPanel.this.progressBar.setVisible(true);
                    DetectSPPanel.this.worker = new SPDetectWorker(DetectSPPanel.this.dataset, filteredList, DetectSPPanel.this.tfDistance.getText().trim(), DetectSPPanel.this.tfTime.getText().trim(), DetectSPPanel.this.tfThreshold.getText().trim());
                    DetectSPPanel.this.worker.setAnnouncer(me);
                    DetectSPPanel.this.worker.addPropertyChangeListener(new PropertyChangeListener(){

                        public void propertyChange(PropertyChangeEvent event) {
                            if (event.getPropertyName().equals("progress")) {
                                DetectSPPanel.this.progressBar.setIndeterminate(false);
                                DetectSPPanel.this.progressBar.setValue((Integer)event.getNewValue());
                            } else if (event.getPropertyName().equals("state")) {
                                switch ((SwingWorker.StateValue)((Object)event.getNewValue())) {
                                    case DONE: {
                                        DetectSPPanel.this.btnStart.setEnabled(true);
                                        DetectSPPanel.this.btnCancel.setEnabled(false);
                                        break;
                                    }
                                    case PENDING: 
                                    case STARTED: {
                                        DetectSPPanel.this.progressBar.setIndeterminate(true);
                                    }
                                }
                            }
                        }
                    });
                    DetectSPPanel.this.worker.execute();
                } else {
                    DetectSPPanel.this.addMessage("All selected users have staypoints generated - nothing to be done");
                    DetectSPPanel.this.progressBar.setVisible(false);
                }
            }
        });
        buttonPanel.add(this.btnStart);
        buttonPanel.add(Box.createRigidArea(this.space));
        this.cancelAction = new AbstractAction("Cancel"){
            private static final long serialVersionUID = 7666652133260327969L;

            public void actionPerformed(ActionEvent e) {
                DetectSPPanel.this.worker.cancel(true);
            }
        };
        this.btnCancel = new JButton(this.cancelAction);
        this.btnCancel.setEnabled(false);
        buttonPanel.add(this.btnCancel);
        buttonPanel.add(Box.createRigidArea(this.space));
        JButton btnClose = new JButton("Close");
        btnClose.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                DetectSPPanel.this.mw.goHome();
            }
        });
        buttonPanel.add(btnClose);
        mainPanel.add(buttonPanel);
    }

    private JPanel createLabelPanel(String text) {
        JPanel result = new JPanel();
        result.setLayout(new BoxLayout(result, 0));
        result.add(Box.createHorizontalGlue());
        result.add(Box.createRigidArea(this.space));
        result.add(new JLabel(text));
        result.add(Box.createRigidArea(this.space));
        return result;
    }

    private JPanel createComponentPanel(JComponent component, String text) {
        JPanel result = new JPanel();
        result.setLayout(new BoxLayout(result, 0));
        result.add(Box.createRigidArea(this.space));
        result.add(component);
        result.add(new JLabel(text));
        result.add(Box.createHorizontalGlue());
        return result;
    }

    public void addMessage(String html) {
        try {
            this.kit.insertHTML(this.doc, this.doc.getLength(), html, 0, 0, null);
        }
        catch (BadLocationException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

