/*
 * Decompiled with CFR 0.152.
 */
package lu.uni.minus.ui;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import lu.uni.minus.preferences.DataSet;
import lu.uni.minus.ui.DSPanel;
import lu.uni.minus.ui.MainWindow;
import org.apache.commons.io.FileUtils;

public class EditDSPanel
extends DSPanel {
    private static final long serialVersionUID = 4434281789357219313L;
    private JTextField textName;
    private JTextField textNewOut;
    private DataSet dataset;
    private DefaultMutableTreeNode node;

    public EditDSPanel(MainWindow aParent, DefaultMutableTreeNode aNode) {
        super(aParent);
        this.node = aNode;
        this.dataset = (DataSet)aNode.getUserObject();
        JPanel mainPanel = new JPanel();
        mainPanel.setBorder(new TitledBorder(null, "Edit the dataset " + this.dataset.getName(), 4, 2, null, null));
        this.add((Component)mainPanel, "North");
        mainPanel.setLayout(new BoxLayout(mainPanel, 1));
        JPanel panelTemp = new JPanel();
        panelTemp.setLayout(new BoxLayout(panelTemp, 0));
        panelTemp.add(new JLabel("Type of the database:"));
        panelTemp.add(Box.createRigidArea(new Dimension(5, 5)));
        panelTemp.add(new JLabel(this.dataset.getType().toString()));
        panelTemp.add(Box.createHorizontalGlue());
        mainPanel.add(panelTemp);
        mainPanel.add(Box.createRigidArea(new Dimension(5, 5)));
        panelTemp = new JPanel();
        panelTemp.setLayout(new BoxLayout(panelTemp, 0));
        panelTemp.add(new JLabel("Current dataset source directory:"));
        panelTemp.add(Box.createRigidArea(new Dimension(5, 5)));
        panelTemp.add(new JLabel(this.dataset.getInputPath().toString()));
        panelTemp.add(Box.createHorizontalGlue());
        mainPanel.add(panelTemp);
        JPanel panelCurrOutDir = new JPanel();
        GridBagLayout gbl_panelCurrOutDir = new GridBagLayout();
        int[] nArray = new int[3];
        nArray[0] = 46;
        gbl_panelCurrOutDir.columnWidths = nArray;
        int[] nArray2 = new int[2];
        nArray2[0] = 25;
        gbl_panelCurrOutDir.rowHeights = nArray2;
        gbl_panelCurrOutDir.columnWeights = new double[]{0.0, 0.0, Double.MIN_VALUE};
        gbl_panelCurrOutDir.rowWeights = new double[]{0.0, Double.MIN_VALUE};
        panelCurrOutDir.setLayout(gbl_panelCurrOutDir);
        JLabel lblCurrOutDir = new JLabel("Current output directory:");
        GridBagConstraints gbc_lblCurrOutDir = new GridBagConstraints();
        gbc_lblCurrOutDir.insets = new Insets(0, 0, 0, 5);
        gbc_lblCurrOutDir.anchor = 13;
        gbc_lblCurrOutDir.gridx = 0;
        gbc_lblCurrOutDir.gridy = 0;
        panelCurrOutDir.add((Component)lblCurrOutDir, gbc_lblCurrOutDir);
        JLabel lblCurrOutValue = new JLabel(this.dataset.getOutputPath().toString());
        GridBagConstraints gbc_lblCurrOutVal = new GridBagConstraints();
        gbc_lblCurrOutVal.gridx = 1;
        gbc_lblCurrOutVal.gridy = 0;
        panelCurrOutDir.add((Component)lblCurrOutValue, gbc_lblCurrOutVal);
        mainPanel.add(panelCurrOutDir);
        JPanel panelName = new JPanel();
        GridBagLayout gbl_panelName = new GridBagLayout();
        gbl_panelName.columnWidths = new int[3];
        int[] nArray3 = new int[2];
        nArray3[0] = 25;
        gbl_panelName.rowHeights = nArray3;
        gbl_panelName.columnWeights = new double[]{0.0, 0.0, Double.MIN_VALUE};
        gbl_panelName.rowWeights = new double[]{0.0, Double.MIN_VALUE};
        panelName.setLayout(gbl_panelName);
        JLabel lblName = new JLabel("New name:");
        GridBagConstraints gbc_lblName = new GridBagConstraints();
        gbc_lblName.insets = new Insets(0, 68, 0, 5);
        gbc_lblName.anchor = 13;
        gbc_lblName.gridx = 0;
        gbc_lblName.gridy = 0;
        panelName.add((Component)lblName, gbc_lblName);
        mainPanel.add(panelName);
        this.textName = new JTextField(this.dataset.getName());
        GridBagConstraints gbc_textName = new GridBagConstraints();
        gbc_textName.fill = 2;
        gbc_textName.gridx = 1;
        gbc_textName.gridy = 0;
        this.textName.setColumns(10);
        panelName.add((Component)this.textName, gbc_textName);
        JPanel panelNewOut = new JPanel();
        GridBagLayout gbl_panel_3 = new GridBagLayout();
        gbl_panel_3.columnWidths = new int[4];
        int[] nArray4 = new int[2];
        nArray4[0] = 25;
        gbl_panel_3.rowHeights = nArray4;
        gbl_panel_3.columnWeights = new double[]{0.0, 1.0, 0.0, Double.MIN_VALUE};
        gbl_panel_3.rowWeights = new double[]{0.0, Double.MIN_VALUE};
        panelNewOut.setLayout(gbl_panel_3);
        JLabel lblOutputDirectory = new JLabel("New output directory:");
        GridBagConstraints gbc_lblOutputDirectory = new GridBagConstraints();
        gbc_lblOutputDirectory.insets = new Insets(0, 15, 0, 5);
        gbc_lblOutputDirectory.anchor = 13;
        gbc_lblOutputDirectory.gridx = 0;
        gbc_lblOutputDirectory.gridy = 0;
        panelNewOut.add((Component)lblOutputDirectory, gbc_lblOutputDirectory);
        this.textNewOut = new JTextField(this.dataset.getOutputPath().toString());
        this.textNewOut.setEditable(true);
        GridBagConstraints gbc_textNewOut = new GridBagConstraints();
        gbc_textNewOut.insets = new Insets(0, 0, 0, 5);
        gbc_textNewOut.fill = 2;
        gbc_textNewOut.gridx = 1;
        gbc_textNewOut.gridy = 0;
        this.textNewOut.setColumns(10);
        panelNewOut.add((Component)this.textNewOut, gbc_textNewOut);
        JButton btnNewOut = new JButton("Select");
        GridBagConstraints gbc_btnNewOut = new GridBagConstraints();
        gbc_btnNewOut.gridx = 2;
        gbc_btnNewOut.gridy = 0;
        panelNewOut.add((Component)btnNewOut, gbc_btnNewOut);
        mainPanel.add(panelNewOut);
        JPanel panelBtn = new JPanel();
        JButton btnConfirm = new JButton("Confirm");
        btnConfirm.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                String newName = EditDSPanel.this.textName.getText().trim();
                String oldName = EditDSPanel.this.dataset.getName();
                File newOutPath = new File(EditDSPanel.this.textNewOut.getText().trim());
                boolean samePath = true;
                try {
                    samePath = newOutPath.getCanonicalPath().equals(EditDSPanel.this.dataset.getOutputPath().getCanonicalPath());
                }
                catch (IOException e1) {
                    e1.printStackTrace();
                }
                if (newName.equalsIgnoreCase(oldName) && samePath) {
                    EditDSPanel.this.mw.goHome();
                    return;
                }
                if (!samePath) {
                    int ans;
                    if (newOutPath.list().length != 0 && (ans = JOptionPane.showConfirmDialog(EditDSPanel.this.mw, "The new output directory is not empty. \nUsing it will delete its contents.\nDo you want to continue?", "Confirm", 0)) == 1) {
                        return;
                    }
                    try {
                        FileUtils.deleteDirectory(newOutPath);
                        FileUtils.moveDirectory(EditDSPanel.this.dataset.getOutputPath(), newOutPath);
                    }
                    catch (IOException exc) {
                        System.err.println("Error while moving directory:" + exc.getMessage());
                        return;
                    }
                }
                EditDSPanel.this.dataset.setName(newName);
                EditDSPanel.this.dataset.setOutputPath(newOutPath);
                DefaultTreeModel treeModel = (DefaultTreeModel)EditDSPanel.this.mw.getDataSetPane().getTree().getModel();
                treeModel.nodeChanged(EditDSPanel.this.node);
                EditDSPanel.this.mw.getSettings().replaceDataset(oldName, EditDSPanel.this.dataset);
                EditDSPanel.this.mw.goHome();
            }
        });
        panelBtn.add(btnConfirm);
        JButton btnClear = new JButton("Clear");
        panelBtn.add(btnClear);
        btnClear.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                EditDSPanel.this.textName.setText("");
                EditDSPanel.this.textNewOut.setText("");
            }
        });
        JButton btnCancel = new JButton("Cancel");
        btnCancel.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                EditDSPanel.this.mw.goHome();
            }
        });
        panelBtn.add(btnCancel);
        mainPanel.add(panelBtn);
    }
}

