/*
 * Decompiled with CFR 0.152.
 */
package lu.uni.minus.ui;

import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import lu.uni.minus.preferences.Settings;
import lu.uni.minus.ui.DataSetsPanel;
import lu.uni.minus.ui.MainMenu;

public class MainWindow
extends JFrame {
    private static final long serialVersionUID = 5166621465142322036L;
    private Settings settings = new Settings();
    private JSplitPane mainSplitPane;
    private DataSetsPanel dataSetPane;
    private MainMenu mainMenu;

    public MainWindow() {
        super("MinUS Tool");
        this.createRootWindow();
        this.showFrame();
    }

    private void createRootWindow() {
        this.mainSplitPane = new JSplitPane(1);
        this.mainSplitPane.setOneTouchExpandable(true);
        this.mainSplitPane.setContinuousLayout(true);
        this.mainSplitPane.setResizeWeight(0.0);
        this.mainMenu = new MainMenu(this);
        this.setJMenuBar(this.mainMenu);
        this.dataSetPane = new DataSetsPanel(this.settings);
        this.mainSplitPane.setLeftComponent(this.dataSetPane);
        this.add(this.mainSplitPane);
    }

    private void showFrame() {
        this.setDefaultCloseOperation(0);
        final JCheckBox checkbox = new JCheckBox("Do not show this message again.");
        String message = "Are you sure you want to exit?";
        final JPanel messagePanel = new JPanel();
        messagePanel.setLayout(new GridLayout(2, 0));
        messagePanel.add(new JLabel(message));
        checkbox.setFont(new Font("Serif", 0, 10));
        messagePanel.add(checkbox);
        final MainWindow parent = this;
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                if (MainWindow.this.settings.getShowExit()) {
                    int ans = JOptionPane.showConfirmDialog(parent, messagePanel, "Confirm exit", 0);
                    MainWindow.this.settings.setShowExit(!checkbox.isSelected());
                    if (ans == 0) {
                        System.exit(0);
                    }
                } else {
                    System.exit(0);
                }
            }
        });
        this.setVisible(true);
        this.setMinimumSize(new Dimension(100, 100));
        this.setPreferredSize(new Dimension(800, 500));
    }

    public void goHome() {
        MainMenu.getHelpStartPage().actionPerformed(new ActionEvent(this, 1001, null));
    }

    public void setContent(JComponent pane) {
        this.mainSplitPane.setRightComponent(pane);
    }

    public Settings getSettings() {
        return this.settings;
    }

    public void setSettings(Settings settings) {
        this.settings = settings;
    }

    public DataSetsPanel getDataSetPane() {
        return this.dataSetPane;
    }
}

