/*
 * Decompiled with CFR 0.152.
 */
package lu.uni.minus.ui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.io.IOException;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JTextPane;
import javax.swing.KeyStroke;
import javax.swing.border.Border;
import javax.swing.text.BadLocationException;
import javax.swing.text.html.HTMLDocument;
import javax.swing.text.html.HTMLEditorKit;
import lu.uni.minus.ui.Announcer;
import lu.uni.minus.ui.MainWindow;
import lu.uni.minus.utils.TextPaneWorker;

public class ProgressDialog
extends JDialog
implements Announcer {
    private static final long serialVersionUID = 3420837293089827169L;
    private Action cancelAction;
    private JTextPane messageArea;
    private JProgressBar progressBar;
    private TextPaneWorker worker;
    private HTMLEditorKit kit;
    private HTMLDocument doc;

    public ProgressDialog(MainWindow parent, TextPaneWorker aWorker) {
        super(parent);
        this.worker = aWorker;
        this.initCloseListener();
        this.initActions();
        this.initUI();
    }

    public final void initUI() {
        this.setVisible(false);
        JPanel mainPane = new JPanel();
        Border paneEdge = BorderFactory.createEmptyBorder(20, 20, 20, 20);
        mainPane.setBorder(paneEdge);
        mainPane.setBackground(Color.white);
        mainPane.setOpaque(true);
        mainPane.setLayout(new BorderLayout(0, 0));
        this.messageArea = new JTextPane();
        this.messageArea.setPreferredSize(new Dimension(300, 200));
        this.messageArea.setContentType("text/html");
        this.messageArea.setEditable(false);
        this.kit = new HTMLEditorKit();
        this.messageArea.setEditorKit(this.kit);
        this.doc = new HTMLDocument();
        this.messageArea.setDocument(this.doc);
        this.add((Component)this.messageArea, "Center");
        JPanel lowerPane = new JPanel();
        this.progressBar = new JProgressBar(0, 100);
        this.progressBar.setValue(0);
        this.progressBar.setStringPainted(true);
        this.progressBar.setVisible(true);
        this.progressBar.setIndeterminate(true);
        this.progressBar.setPreferredSize(new Dimension(260, 20));
        lowerPane.setLayout(new BoxLayout(lowerPane, 0));
        lowerPane.add(this.progressBar);
        lowerPane.add(new JButton(this.cancelAction));
        this.add((Component)lowerPane, "South");
        this.setTitle("Progress Monitor");
        this.setDefaultCloseOperation(2);
        this.setLocationRelativeTo(null);
        this.pack();
        this.setVisible(true);
    }

    public void addMessage(String html) {
        try {
            this.kit.insertHTML(this.doc, this.doc.getLength(), html, 0, 0, null);
        }
        catch (BadLocationException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void initActions() {
        this.cancelAction = new AbstractAction("Cancel"){
            private static final long serialVersionUID = -774586177783237294L;

            public void actionPerformed(ActionEvent e) {
                ProgressDialog.this.cancel();
            }
        };
    }

    private void initCloseListener() {
        this.getRootPane().getInputMap(2).put(KeyStroke.getKeyStroke(27, 0), "close");
        this.getRootPane().getInputMap(2).put(KeyStroke.getKeyStroke(10, 0), "close");
        this.getRootPane().getActionMap().put("close", new AbstractAction(){
            private static final long serialVersionUID = 2143956335533214473L;

            public void actionPerformed(ActionEvent e) {
                ProgressDialog.this.cancel();
            }
        });
    }

    private void cancel() {
        this.worker.cancel(true);
        this.dispose();
    }

    public void setButtonText(String text) {
        this.cancelAction.putValue("Name", text);
    }

    public void setProgress(Integer i) {
        this.progressBar.setValue(i);
    }

    public void setIndeterminate(boolean is) {
        this.progressBar.setIndeterminate(is);
    }
}

