/*
 * Decompiled with CFR 0.152.
 */
package lu.uni.minus.ui;

import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.TitledBorder;
import lu.uni.minus.preferences.DataSet;
import lu.uni.minus.ui.MainWindow;

public class StatDSPanel
extends JPanel {
    private static final long serialVersionUID = -8263112875159039261L;
    private final MainWindow mw;
    private final Dimension space = new Dimension(6, 6);

    public StatDSPanel(MainWindow aMw, DataSet dataset) {
        this.mw = aMw;
        this.setLayout(new BoxLayout(this, 1));
        JPanel mainPanel = new JPanel();
        mainPanel.setLayout(new BoxLayout(mainPanel, 0));
        mainPanel.setBorder(new TitledBorder(null, "Dataset \"" + dataset.getName() + "\" information", 4, 2, null, null));
        JPanel leftPanel = new JPanel();
        leftPanel.setLayout(new BoxLayout(leftPanel, 1));
        JPanel rightPanel = new JPanel();
        rightPanel.setLayout(new BoxLayout(rightPanel, 1));
        leftPanel.setMaximumSize(new Dimension(250, 100));
        leftPanel.add(this.createLabelPanel(true, "Name :"));
        leftPanel.add(Box.createRigidArea(this.space));
        leftPanel.add(this.createLabelPanel(true, "Type :"));
        leftPanel.add(Box.createRigidArea(this.space));
        leftPanel.add(this.createLabelPanel(true, "Number of users :"));
        leftPanel.add(Box.createRigidArea(this.space));
        leftPanel.add(this.createLabelPanel(true, "Input directory :"));
        leftPanel.add(Box.createRigidArea(this.space));
        leftPanel.add(this.createLabelPanel(true, "Output directory :"));
        leftPanel.add(Box.createRigidArea(this.space));
        rightPanel.add(this.createLabelPanel(false, dataset.getName()));
        rightPanel.add(Box.createRigidArea(this.space));
        rightPanel.add(this.createLabelPanel(false, dataset.getType().toString()));
        rightPanel.add(Box.createRigidArea(this.space));
        rightPanel.add(this.createLabelPanel(false, new Integer(dataset.getInputPath().list().length).toString()));
        rightPanel.add(Box.createRigidArea(this.space));
        rightPanel.add(this.createLabelPanel(false, dataset.getInputPath().toString()));
        rightPanel.add(Box.createRigidArea(this.space));
        rightPanel.add(this.createLabelPanel(false, dataset.getOutputPath().toString()));
        rightPanel.add(Box.createRigidArea(this.space));
        mainPanel.add(leftPanel);
        mainPanel.add(rightPanel);
        mainPanel.add(Box.createHorizontalGlue());
        JPanel buttonPanel = new JPanel();
        buttonPanel.setLayout(new BoxLayout(buttonPanel, 0));
        JButton btnClose = new JButton("Close");
        btnClose.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                StatDSPanel.this.mw.goHome();
            }
        });
        buttonPanel.add(btnClose);
        this.add(mainPanel);
        this.add(buttonPanel);
        this.add(Box.createVerticalGlue());
    }

    private JPanel createLabelPanel(boolean leftAligned, String text) {
        JPanel result = new JPanel();
        result.setLayout(new BoxLayout(result, 0));
        if (leftAligned) {
            result.add(Box.createHorizontalGlue());
        }
        result.add(Box.createRigidArea(this.space));
        result.add(new JLabel(text));
        result.add(Box.createRigidArea(this.space));
        if (!leftAligned) {
            result.add(Box.createHorizontalGlue());
        }
        return result;
    }
}

