/*
 * Decompiled with CFR 0.152.
 */
package lu.uni.minus.ui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.List;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.border.LineBorder;
import javax.swing.border.MatteBorder;
import javax.swing.table.DefaultTableModel;
import lu.uni.minus.preferences.DataSet;
import lu.uni.minus.ui.MainWindow;
import lu.uni.minus.utils.StatTableModel;

public class ViewUserPanel
extends JPanel {
    private static final long serialVersionUID = 4211267197541491642L;
    private final MainWindow mw;
    private DataSet dataset;
    private JTable table;
    private JTable table_1;

    public ViewUserPanel(MainWindow aMw, DataSet aDataset) {
        this.mw = aMw;
        this.dataset = aDataset;
        this.setLayout(new BorderLayout(0, 0));
        JSplitPane splitPane = new JSplitPane();
        this.add((Component)splitPane, "Center");
        JPanel panel_1 = new JPanel();
        panel_1.setLayout(new BorderLayout(0, 0));
        JPanel panel_2 = new JPanel();
        panel_1.add((Component)panel_2, "North");
        JButton btnViewStats = new JButton("View stats");
        panel_2.add(btnViewStats);
        JButton btnClear = new JButton("Clear");
        panel_2.add(btnClear);
        JButton btnClose = new JButton("Close");
        panel_2.add(btnClose);
        JPanel panel_3 = new JPanel();
        panel_1.add((Component)panel_3, "Center");
        JPanel panel_4 = new JPanel();
        panel_3.setLayout(new GridLayout(0, 1, 0, 0));
        panel_4.setLayout(new BorderLayout(0, 0));
        JScrollPane scrollPane_1 = new JScrollPane();
        panel_4.add(scrollPane_1);
        this.table = new JTable();
        scrollPane_1.setViewportView(this.table);
        JLabel lblGpsPointStats = new JLabel("GPS point stats");
        lblGpsPointStats.setBorder(new MatteBorder(1, 0, 0, 0, new Color(0, 0, 0)));
        lblGpsPointStats.setHorizontalAlignment(0);
        panel_4.add((Component)lblGpsPointStats, "North");
        JPanel panel_5 = new JPanel();
        panel_5.setLayout(new BorderLayout(0, 0));
        panel_3.add(panel_5);
        panel_3.add(panel_4);
        JScrollPane scrollPane_2 = new JScrollPane();
        panel_5.add((Component)scrollPane_2, "Center");
        this.table_1 = new JTable();
        scrollPane_2.setViewportView(this.table_1);
        JPanel panel_6 = new JPanel();
        panel_5.add((Component)panel_6, "North");
        panel_6.setLayout(new BoxLayout(panel_6, 1));
        JPanel panel_7 = new JPanel();
        panel_7.setBorder(new MatteBorder(1, 0, 0, 0, new Color(0, 0, 0)));
        FlowLayout flowLayout = (FlowLayout)panel_7.getLayout();
        flowLayout.setVgap(0);
        flowLayout.setHgap(0);
        panel_6.add(panel_7);
        JLabel lblStayPointStats = new JLabel("Stay point stats");
        panel_7.add(lblStayPointStats);
        lblStayPointStats.setBorder(null);
        lblStayPointStats.setHorizontalAlignment(0);
        JPanel panel_8 = new JPanel();
        FlowLayout flowLayout_1 = (FlowLayout)panel_8.getLayout();
        flowLayout_1.setVgap(0);
        flowLayout_1.setHgap(0);
        panel_6.add(panel_8);
        JLabel lblStayPointPara = new JLabel("Stay point para setting: ");
        panel_8.add(lblStayPointPara);
        final JComboBox<String> comboBox = new JComboBox<String>();
        panel_8.add(comboBox);
        JPanel panel = new JPanel();
        panel.setBorder(new LineBorder(new Color(0, 0, 0)));
        panel.setLayout(new BorderLayout(0, 0));
        JLabel lblUserList = new JLabel(" User list:");
        lblUserList.setHorizontalAlignment(0);
        panel.add((Component)lblUserList, "North");
        JScrollPane scrollPane = new JScrollPane();
        panel.add((Component)scrollPane, "Center");
        final JList<String> usersList = new JList<String>();
        scrollPane.setViewportView(usersList);
        splitPane.setLeftComponent(panel);
        splitPane.setRightComponent(panel_1);
        splitPane.setDividerLocation(70);
        usersList.setListData(this.dataset.getUserList());
        if (this.dataset.getType().equals((Object)DataSet.Type.GPS)) {
            File statFolder = new File(String.valueOf(this.dataset.getOutputPath().toString()) + "/Stats/SourceDataAndStayPoints");
            String[] statFiles = statFolder.list();
            if (statFiles != null && statFiles.length > 1) {
                String[] stringArray = statFiles;
                int n = statFiles.length;
                int n2 = 0;
                while (n2 < n) {
                    String aStatFile = stringArray[n2];
                    if (aStatFile.contains("StayPoints")) {
                        comboBox.addItem(aStatFile);
                    }
                    ++n2;
                }
            }
        } else {
            panel_3.remove(panel_4);
            panel_8.setVisible(false);
        }
        btnViewStats.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent arg0) {
                List<String> selectedList = usersList.getSelectedValuesList();
                if (selectedList.size() == 0) {
                    JOptionPane.showMessageDialog(null, "Please first choose some users.", "Choose users", 1);
                    return;
                }
                StatTableModel GPStm = null;
                StatTableModel SPtm = null;
                String cbChoice = (String)comboBox.getSelectedItem();
                if (ViewUserPanel.this.dataset.getType().equals((Object)DataSet.Type.GPS)) {
                    GPStm = new StatTableModel(selectedList, ViewUserPanel.this.dataset, true, null);
                    if (cbChoice != null) {
                        SPtm = new StatTableModel(selectedList, ViewUserPanel.this.dataset, false, cbChoice);
                    }
                } else {
                    SPtm = new StatTableModel(selectedList, ViewUserPanel.this.dataset, false, cbChoice);
                }
                if (GPStm != null) {
                    ViewUserPanel.this.table.setModel(GPStm);
                }
                if (SPtm != null && SPtm.getRowCount() != 0) {
                    ViewUserPanel.this.table_1.setModel(SPtm);
                } else {
                    ViewUserPanel.this.table_1.setModel(new DefaultTableModel());
                }
            }
        });
        btnClear.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ViewUserPanel.this.table_1.setModel(new DefaultTableModel());
                ViewUserPanel.this.table.setModel(new DefaultTableModel());
            }
        });
        btnClose.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ViewUserPanel.this.mw.goHome();
            }
        });
    }
}

