/*
 * Decompiled with CFR 0.152.
 */
package lu.uni.minus.ui;

import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import javax.swing.JComboBox;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WideJComboBox<E>
extends JComboBox<E> {
    private static final long serialVersionUID = -6749113338777155622L;
    private boolean layingOut = false;
    private int widestLengh = 0;
    private boolean wide = false;

    public WideJComboBox() {
    }

    public WideJComboBox(E[] objs) {
        super(objs);
    }

    public boolean isWide() {
        return this.wide;
    }

    public void setWide(boolean wide) {
        this.wide = wide;
        this.widestLengh = this.getWidestItemWidth();
    }

    @Override
    public Dimension getSize() {
        Dimension dim = super.getSize();
        if (!this.layingOut && this.isWide()) {
            dim.width = Math.max(this.widestLengh, dim.width);
        }
        return dim;
    }

    public int getWidestItemWidth() {
        int numOfItems = this.getItemCount();
        Font font = this.getFont();
        FontMetrics metrics = this.getFontMetrics(font);
        int widest = 0;
        int i = 0;
        while (i < numOfItems) {
            Object item = this.getItemAt(i);
            int lineWidth = metrics.stringWidth(item.toString());
            widest = Math.max(widest, lineWidth);
            ++i;
        }
        return widest + 5;
    }

    @Override
    public void doLayout() {
        try {
            this.layingOut = true;
            super.doLayout();
        }
        finally {
            this.layingOut = false;
        }
    }
}

