/*
 * Decompiled with CFR 0.152.
 */
package lu.uni.minus.ui.epub;

import java.awt.Color;
import java.awt.GridLayout;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.net.URLDecoder;
import javax.swing.JEditorPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.html.HTML;
import javax.swing.text.html.HTMLDocument;
import javax.swing.text.html.HTMLEditorKit;
import lu.uni.minus.ui.epub.DesktopUtil;
import lu.uni.minus.ui.epub.HTMLDocumentFactory;
import nl.siegmann.epublib.browsersupport.NavigationEvent;
import nl.siegmann.epublib.browsersupport.NavigationEventListener;
import nl.siegmann.epublib.browsersupport.Navigator;
import nl.siegmann.epublib.domain.Book;
import nl.siegmann.epublib.domain.Resource;
import org.apache.commons.lang.StringUtils;

public class ContentPane
extends JPanel
implements NavigationEventListener,
HyperlinkListener {
    private static final long serialVersionUID = -5322988066178102320L;
    private Navigator navigator;
    private Resource currentResource;
    private JEditorPane editorPane;
    private JScrollPane scrollPane = (JScrollPane)this.add(new JScrollPane());
    private HTMLDocumentFactory htmlDocumentFactory;

    public ContentPane(Navigator navigator) {
        super(new GridLayout(1, 0));
        this.scrollPane.addKeyListener(new KeyListener(){

            public void keyTyped(KeyEvent e) {
            }

            public void keyReleased(KeyEvent e) {
            }

            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 40) {
                    Point viewPosition = ContentPane.this.scrollPane.getViewport().getViewPosition();
                    int newY = (int)(viewPosition.getY() + 10.0);
                    ContentPane.this.scrollPane.getViewport().setViewPosition(new Point((int)viewPosition.getX(), newY));
                }
            }
        });
        this.scrollPane.addMouseWheelListener(new MouseWheelListener(){
            private boolean gotoNextPage = false;
            private boolean gotoPreviousPage = false;

            public void mouseWheelMoved(MouseWheelEvent e) {
                int notches = e.getWheelRotation();
                int increment = ContentPane.this.scrollPane.getVerticalScrollBar().getUnitIncrement(1);
                if (notches < 0) {
                    Point viewPosition = ContentPane.this.scrollPane.getViewport().getViewPosition();
                    if (viewPosition.getY() - (double)increment < 0.0) {
                        if (this.gotoPreviousPage) {
                            this.gotoPreviousPage = false;
                            ContentPane.this.navigator.gotoPreviousSpineSection(-1, ContentPane.this);
                        } else {
                            this.gotoPreviousPage = true;
                            ContentPane.this.scrollPane.getViewport().setViewPosition(new Point((int)viewPosition.getX(), 0));
                        }
                    }
                } else {
                    Point viewPosition = ContentPane.this.scrollPane.getViewport().getViewPosition();
                    int viewportHeight = ContentPane.this.scrollPane.getViewport().getHeight();
                    int scrollMax = ContentPane.this.scrollPane.getVerticalScrollBar().getMaximum();
                    if (viewPosition.getY() + (double)viewportHeight + (double)increment > (double)scrollMax) {
                        if (this.gotoNextPage) {
                            this.gotoNextPage = false;
                            ContentPane.this.navigator.gotoNextSpineSection(ContentPane.this);
                        } else {
                            this.gotoNextPage = true;
                            int newY = scrollMax - viewportHeight;
                            ContentPane.this.scrollPane.getViewport().setViewPosition(new Point((int)viewPosition.getX(), newY));
                        }
                    }
                }
            }
        });
        this.navigator = navigator;
        navigator.addNavigationEventListener(this);
        this.editorPane = this.createJEditorPane();
        this.scrollPane.getViewport().add(this.editorPane);
        this.htmlDocumentFactory = new HTMLDocumentFactory(navigator, this.editorPane.getEditorKit());
        this.initBook(navigator.getBook());
    }

    private void initBook(Book book) {
        if (book == null) {
            return;
        }
        this.htmlDocumentFactory.init(book);
        this.displayPage(book.getCoverPage());
    }

    private static boolean matchesAny(String searchString, String ... possibleValues) {
        int i = 0;
        while (i < possibleValues.length) {
            String attributeValue = possibleValues[i];
            if (StringUtils.isNotBlank(attributeValue) && attributeValue.equals(searchString)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private static void scrollToElement(JEditorPane editorPane, HTMLDocument.Iterator elementIterator) {
        try {
            Rectangle rectangle = editorPane.modelToView(elementIterator.getStartOffset());
            if (rectangle == null) {
                return;
            }
            Rectangle visibleRectangle = editorPane.getVisibleRect();
            rectangle.height = visibleRectangle.height;
            editorPane.scrollRectToVisible(rectangle);
        }
        catch (BadLocationException e) {
            System.err.println(e.getMessage());
        }
    }

    private void scrollToNamedAnchor(String fragmentId) {
        HTMLDocument doc = (HTMLDocument)this.editorPane.getDocument();
        HTMLDocument.Iterator iter = doc.getIterator(HTML.Tag.A);
        while (iter.isValid()) {
            AttributeSet attributes = iter.getAttributes();
            if (ContentPane.matchesAny(fragmentId, (String)attributes.getAttribute(HTML.Attribute.NAME), (String)attributes.getAttribute(HTML.Attribute.ID))) {
                ContentPane.scrollToElement(this.editorPane, iter);
                break;
            }
            iter.next();
        }
    }

    private JEditorPane createJEditorPane() {
        JEditorPane editorPane = new JEditorPane();
        editorPane.setBackground(Color.white);
        editorPane.setEditable(false);
        HTMLEditorKit htmlKit = new HTMLEditorKit();
        editorPane.setEditorKit(htmlKit);
        editorPane.addHyperlinkListener(this);
        editorPane.addKeyListener(new KeyListener(){

            public void keyTyped(KeyEvent keyEvent) {
            }

            public void keyReleased(KeyEvent e) {
            }

            public void keyPressed(KeyEvent keyEvent) {
                if (keyEvent.getKeyCode() == 39) {
                    ContentPane.this.navigator.gotoNextSpineSection(ContentPane.this);
                } else if (keyEvent.getKeyCode() == 37) {
                    ContentPane.this.navigator.gotoPreviousSpineSection(ContentPane.this);
                } else if (keyEvent.getKeyCode() == 32) {
                    ContentPane.this.gotoNextPage();
                }
            }
        });
        return editorPane;
    }

    public void displayPage(Resource resource) {
        this.displayPage(resource, 0);
    }

    public void displayPage(Resource resource, int sectionPos) {
        if (resource == null) {
            return;
        }
        try {
            HTMLDocument document = this.htmlDocumentFactory.getDocument(resource);
            if (document == null) {
                return;
            }
            this.currentResource = resource;
            this.editorPane.setDocument(document);
            this.scrollToCurrentPosition(sectionPos);
        }
        catch (Exception e) {
            System.err.println("When reading resource " + resource.getId() + "(" + resource.getHref() + ") :" + e.getMessage());
        }
    }

    private void scrollToCurrentPosition(int sectionPos) {
        if (sectionPos < 0) {
            this.editorPane.setCaretPosition(this.editorPane.getDocument().getLength());
        } else {
            this.editorPane.setCaretPosition(sectionPos);
        }
        if (sectionPos == 0) {
            this.scrollPane.getViewport().setViewPosition(new Point(0, 0));
        } else if (sectionPos < 0) {
            int viewportHeight = this.scrollPane.getViewport().getHeight();
            int scrollMax = this.scrollPane.getVerticalScrollBar().getMaximum();
            this.scrollPane.getViewport().setViewPosition(new Point(0, scrollMax - viewportHeight));
        }
    }

    public void hyperlinkUpdate(HyperlinkEvent event) {
        String resourceHref;
        if (event.getEventType() != HyperlinkEvent.EventType.ACTIVATED) {
            return;
        }
        URL url = event.getURL();
        if (url.getProtocol().toLowerCase().startsWith("http") && !"".equals(url.getHost())) {
            try {
                DesktopUtil.launchBrowser(event.getURL());
                return;
            }
            catch (DesktopUtil.BrowserLaunchException ex) {
                System.err.println("Couldn't launch system web browser.");
            }
        }
        if ((resourceHref = this.calculateTargetHref(event.getURL())).startsWith("#")) {
            this.scrollToNamedAnchor(resourceHref.substring(1));
            return;
        }
        Resource resource = this.navigator.getBook().getResources().getByHref(resourceHref);
        if (resource == null) {
            System.err.println("Resource with url " + resourceHref + " not found");
        } else {
            this.navigator.gotoResource(resource, (Object)this);
        }
    }

    public void gotoPreviousPage() {
        Point viewPosition = this.scrollPane.getViewport().getViewPosition();
        if (viewPosition.getY() <= 0.0) {
            this.navigator.gotoPreviousSpineSection(this);
            return;
        }
        int viewportHeight = this.scrollPane.getViewport().getHeight();
        int newY = (int)viewPosition.getY();
        newY -= viewportHeight;
        newY = Math.max(0, newY - viewportHeight);
        this.scrollPane.getViewport().setViewPosition(new Point((int)viewPosition.getX(), newY));
    }

    public void gotoNextPage() {
        Point viewPosition = this.scrollPane.getViewport().getViewPosition();
        int viewportHeight = this.scrollPane.getViewport().getHeight();
        int scrollMax = this.scrollPane.getVerticalScrollBar().getMaximum();
        if (viewPosition.getY() + (double)viewportHeight >= (double)scrollMax) {
            this.navigator.gotoNextSpineSection(this);
            return;
        }
        int newY = (int)viewPosition.getY() + viewportHeight;
        this.scrollPane.getViewport().setViewPosition(new Point((int)viewPosition.getX(), newY));
    }

    private String calculateTargetHref(URL clickUrl) {
        int lastSlashPos;
        String resourceHref = clickUrl.toString();
        try {
            resourceHref = URLDecoder.decode(resourceHref, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            System.err.println(e.getMessage());
        }
        resourceHref = resourceHref.substring("http:/".length());
        if (resourceHref.startsWith("#")) {
            return resourceHref;
        }
        if (this.currentResource != null && StringUtils.isNotBlank(this.currentResource.getHref()) && (lastSlashPos = this.currentResource.getHref().lastIndexOf(47)) >= 0) {
            resourceHref = String.valueOf(this.currentResource.getHref().substring(0, lastSlashPos + 1)) + resourceHref;
        }
        return resourceHref;
    }

    public void navigationPerformed(NavigationEvent navigationEvent) {
        if (navigationEvent.isBookChanged()) {
            this.initBook(navigationEvent.getCurrentBook());
        } else {
            if (navigationEvent.isResourceChanged()) {
                this.displayPage(navigationEvent.getCurrentResource(), navigationEvent.getCurrentSectionPos());
            } else if (navigationEvent.isSectionPosChanged()) {
                this.editorPane.setCaretPosition(navigationEvent.getCurrentSectionPos());
            }
            if (StringUtils.isNotBlank(navigationEvent.getCurrentFragmentId())) {
                this.scrollToNamedAnchor(navigationEvent.getCurrentFragmentId());
            }
        }
    }
}

