/*
 * Decompiled with CFR 0.152.
 */
package lu.uni.minus.ui.epub;

import java.io.StringReader;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import javax.swing.text.EditorKit;
import javax.swing.text.html.HTMLDocument;
import javax.swing.text.html.HTMLEditorKit;
import lu.uni.minus.ui.epub.ImageLoaderCache;
import lu.uni.minus.ui.epub.MyHtmlEditorKit;
import lu.uni.minus.ui.epub.MyParserCallback;
import nl.siegmann.epublib.browsersupport.NavigationEvent;
import nl.siegmann.epublib.browsersupport.NavigationEventListener;
import nl.siegmann.epublib.browsersupport.Navigator;
import nl.siegmann.epublib.domain.Book;
import nl.siegmann.epublib.domain.Resource;
import nl.siegmann.epublib.service.MediatypeService;
import org.apache.commons.io.IOUtils;

public class HTMLDocumentFactory
implements NavigationEventListener {
    public static final int DOCUMENT_CACHE_INDEXER_WAIT_TIME = 500;
    private ImageLoaderCache imageLoaderCache;
    private ReentrantReadWriteLock cacheLock = new ReentrantReadWriteLock();
    private Lock cacheReadLock = this.cacheLock.readLock();
    private Lock cacheWriteLock = this.cacheLock.writeLock();
    private Map<String, HTMLDocument> documentCache = new HashMap<String, HTMLDocument>();
    private MyHtmlEditorKit editorKit;

    public HTMLDocumentFactory(Navigator navigator, EditorKit editorKit) {
        this.editorKit = new MyHtmlEditorKit((HTMLEditorKit)editorKit);
        this.imageLoaderCache = new ImageLoaderCache(navigator);
        this.init(navigator.getBook());
        navigator.addNavigationEventListener(this);
    }

    public void init(Book book) {
        if (book == null) {
            return;
        }
        this.imageLoaderCache.initBook(book);
        this.initDocumentCache(book);
    }

    private void putDocument(Resource resource, HTMLDocument document) {
        if (document == null) {
            return;
        }
        this.cacheWriteLock.lock();
        try {
            this.documentCache.put(resource.getHref(), document);
        }
        finally {
            this.cacheWriteLock.unlock();
        }
    }

    public HTMLDocument getDocument(Resource resource) {
        HTMLDocument document = null;
        this.cacheReadLock.lock();
        try {
            document = this.documentCache.get(resource.getHref());
        }
        finally {
            this.cacheReadLock.unlock();
        }
        if (document == null) {
            document = this.createDocument(resource);
            this.putDocument(resource, document);
        }
        if (document != null) {
            this.imageLoaderCache.initImageLoader(document);
        }
        return document;
    }

    private String stripHtml(String input) {
        String result = HTMLDocumentFactory.removeControlTags(input);
        return result;
    }

    private static String removeControlTags(String input) {
        StringBuilder result = new StringBuilder();
        boolean inControlTag = false;
        int i = 0;
        while (i < input.length()) {
            char c = input.charAt(i);
            if (inControlTag) {
                if (c == '>') {
                    inControlTag = false;
                }
            } else if (c == '<' && i < input.length() - 1 && (input.charAt(i + 1) == '!' || input.charAt(i + 1) == '?')) {
                inControlTag = true;
            } else {
                result.append(c);
            }
            ++i;
        }
        return result.toString();
    }

    private HTMLDocument createDocument(Resource resource) {
        HTMLDocument result = null;
        if (resource.getMediaType() != MediatypeService.XHTML) {
            return result;
        }
        try {
            HTMLDocument document = (HTMLDocument)this.editorKit.createDefaultDocument();
            MyParserCallback parserCallback = new MyParserCallback(document.getReader(0));
            HTMLEditorKit.Parser parser = this.editorKit.getParser();
            String pageContent = IOUtils.toString(resource.getReader());
            pageContent = this.stripHtml(pageContent);
            document.remove(0, document.getLength());
            StringReader contentReader = new StringReader(pageContent);
            parser.parse(contentReader, parserCallback, true);
            parserCallback.flush();
            result = document;
        }
        catch (Exception e) {
            System.err.println(e.getMessage());
        }
        return result;
    }

    private void initDocumentCache(Book book) {
        if (book == null) {
            return;
        }
        this.documentCache.clear();
        Thread documentIndexerThread = new Thread((Runnable)new DocumentIndexer(book), "DocumentIndexer");
        documentIndexerThread.setPriority(1);
        documentIndexerThread.start();
    }

    public void navigationPerformed(NavigationEvent navigationEvent) {
        if (navigationEvent.isBookChanged() || navigationEvent.isResourceChanged()) {
            this.imageLoaderCache.clear();
        }
    }

    private class DocumentIndexer
    implements Runnable {
        private Book book;

        public DocumentIndexer(Book book) {
            this.book = book;
        }

        public void run() {
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException e) {
                System.err.println(e.getMessage());
            }
            this.addAllDocumentsToCache(this.book);
        }

        private void addAllDocumentsToCache(Book book) {
            for (Resource resource : book.getResources().getAll()) {
                HTMLDocumentFactory.this.getDocument(resource);
            }
        }
    }
}

