/*
 * Decompiled with CFR 0.152.
 */
package lu.uni.minus.ui.epub;

import javax.swing.JSlider;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import nl.siegmann.epublib.browsersupport.NavigationEvent;
import nl.siegmann.epublib.browsersupport.NavigationEventListener;
import nl.siegmann.epublib.browsersupport.Navigator;
import nl.siegmann.epublib.domain.Book;

class SpineSlider
extends JSlider
implements NavigationEventListener {
    private static final long serialVersionUID = 8436441824668551056L;
    private final Navigator navigator;

    public SpineSlider(Navigator navigator) {
        super(0);
        this.navigator = navigator;
        navigator.addNavigationEventListener(this);
        this.setPaintLabels(false);
        this.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent evt) {
                JSlider slider = (JSlider)evt.getSource();
                int value = slider.getValue();
                SpineSlider.this.navigator.gotoSpineSection(value, SpineSlider.this);
            }
        });
        this.initBook(navigator.getBook());
    }

    private void initBook(Book book) {
        if (book == null) {
            return;
        }
        super.setMinimum(0);
        super.setMaximum(book.getSpine().size() - 1);
        super.setValue(0);
        this.updateToolTip();
    }

    private void updateToolTip() {
        String tooltip = "";
        if (this.navigator.getCurrentSpinePos() >= 0 && this.navigator.getBook() != null) {
            tooltip = String.valueOf(String.valueOf(this.navigator.getCurrentSpinePos() + 1)) + " / " + this.navigator.getBook().getSpine().size();
        }
        this.setToolTipText(tooltip);
    }

    public void navigationPerformed(NavigationEvent navigationEvent) {
        this.updateToolTip();
        if (this == navigationEvent.getSource()) {
            return;
        }
        if (navigationEvent.isBookChanged()) {
            this.initBook(navigationEvent.getCurrentBook());
        } else if (navigationEvent.isResourceChanged()) {
            this.setValue(navigationEvent.getCurrentSpinePos());
        }
    }
}

