/*
 * Decompiled with CFR 0.152.
 */
package lu.uni.minus.ui.epub;

import java.awt.GridLayout;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreePath;
import nl.siegmann.epublib.browsersupport.NavigationEvent;
import nl.siegmann.epublib.browsersupport.NavigationEventListener;
import nl.siegmann.epublib.browsersupport.Navigator;
import nl.siegmann.epublib.domain.Book;
import nl.siegmann.epublib.domain.Resource;
import nl.siegmann.epublib.domain.TOCReference;
import org.apache.commons.lang.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TableOfContentsPane
extends JPanel
implements NavigationEventListener {
    private static final long serialVersionUID = 2277717264176049700L;
    private Map<String, Collection<DefaultMutableTreeNode>> href2treeNode = new HashMap<String, Collection<DefaultMutableTreeNode>>();
    private JScrollPane scrollPane;
    private Navigator navigator;
    private JTree tree;

    public TableOfContentsPane(Navigator navigator) {
        super(new GridLayout(1, 0));
        this.navigator = navigator;
        navigator.addNavigationEventListener(this);
        this.scrollPane = new JScrollPane();
        this.add(this.scrollPane);
        this.initBook(navigator.getBook());
    }

    private void addToHref2TreeNode(Resource resource, DefaultMutableTreeNode treeNode) {
        if (resource == null || StringUtils.isBlank(resource.getHref())) {
            return;
        }
        Collection<DefaultMutableTreeNode> treeNodes = this.href2treeNode.get(resource.getHref());
        if (treeNodes == null) {
            treeNodes = new ArrayList<DefaultMutableTreeNode>();
            this.href2treeNode.put(resource.getHref(), treeNodes);
        }
        treeNodes.add(treeNode);
    }

    private DefaultMutableTreeNode createTree(Book book) {
        TOCItem rootTOCItem = new TOCItem(new TOCReference(book.getTitle(), book.getCoverPage()));
        DefaultMutableTreeNode top = new DefaultMutableTreeNode(rootTOCItem);
        this.addToHref2TreeNode(book.getCoverPage(), top);
        this.createNodes(top, book);
        return top;
    }

    private void createNodes(DefaultMutableTreeNode top, Book book) {
        this.addNodesToParent(top, book.getTableOfContents().getTocReferences());
    }

    private void addNodesToParent(DefaultMutableTreeNode parent, List<TOCReference> tocReferences) {
        if (tocReferences == null) {
            return;
        }
        for (TOCReference tocReference : tocReferences) {
            TOCItem tocItem = new TOCItem(tocReference);
            DefaultMutableTreeNode treeNode = new DefaultMutableTreeNode(tocItem);
            this.addToHref2TreeNode(tocReference.getResource(), treeNode);
            this.addNodesToParent(treeNode, tocReference.getChildren());
            parent.add(treeNode);
        }
    }

    @Override
    public void navigationPerformed(NavigationEvent navigationEvent) {
        if (this == navigationEvent.getSource()) {
            return;
        }
        if (navigationEvent.isBookChanged()) {
            this.initBook(navigationEvent.getCurrentBook());
            return;
        }
        if (this.tree == null) {
            return;
        }
        if (navigationEvent.getCurrentResource() == null) {
            return;
        }
        Collection<DefaultMutableTreeNode> treeNodes = this.href2treeNode.get(navigationEvent.getCurrentResource().getHref());
        if (treeNodes == null || treeNodes.isEmpty()) {
            if (navigationEvent.getCurrentSpinePos() == navigationEvent.getOldSpinePos() + 1) {
                return;
            }
            this.tree.setSelectionPath(null);
            return;
        }
        for (DefaultMutableTreeNode treeNode : treeNodes) {
            Object[] path = treeNode.getPath();
            TreePath treePath = new TreePath(path);
            this.tree.setSelectionPath(treePath);
        }
    }

    private void initBook(Book book) {
        if (book == null) {
            return;
        }
        this.tree = new JTree(this.createTree(book));
        this.tree.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent me) {
                DefaultMutableTreeNode node = (DefaultMutableTreeNode)TableOfContentsPane.this.tree.getLastSelectedPathComponent();
                TOCItem tocItem = (TOCItem)node.getUserObject();
                TableOfContentsPane.this.navigator.gotoResource(tocItem.getTOCReference().getResource(), tocItem.getTOCReference().getFragmentId(), (Object)TableOfContentsPane.this);
            }
        });
        this.tree.getSelectionModel().setSelectionMode(1);
        this.tree.setSelectionRow(0);
        this.scrollPane.getViewport().removeAll();
        this.scrollPane.getViewport().add(this.tree);
    }

    private static class TOCItem {
        private TOCReference tocReference;

        public TOCItem(TOCReference tocReference) {
            this.tocReference = tocReference;
        }

        public TOCReference getTOCReference() {
            return this.tocReference;
        }

        public String toString() {
            return this.tocReference.getTitle();
        }
    }
}

