/*
 * Decompiled with CFR 0.152.
 */
package lu.uni.minus.utils;

import java.awt.EventQueue;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.InputStreamReader;
import java.util.List;
import javax.swing.JOptionPane;
import lu.uni.minus.preferences.DataSet;
import lu.uni.minus.ui.ExtractFPSPanel;
import lu.uni.minus.utils.ProcessRunner;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PSExtractor
implements Runnable {
    private DataSet dataset;
    private ExtractFPSPanel ePanel;
    private List<String> list;
    private double threshold;
    private double tolerance;
    private double side;
    private String roiFile;
    private byte typeDay;
    private String selectedSP;
    private File fpsDir;

    public PSExtractor(DataSet aDataset, ExtractFPSPanel pr, List<String> aList, double aThreshold, double aTolerance, double aSide, String aRoIFile, byte aTypeDay, String aSelectedSP, File aDir) {
        this.dataset = aDataset;
        this.ePanel = pr;
        this.list = aList;
        this.threshold = aThreshold;
        this.tolerance = aTolerance;
        this.side = aSide;
        this.roiFile = aRoIFile;
        this.typeDay = aTypeDay;
        this.selectedSP = aSelectedSP;
        this.fpsDir = aDir;
    }

    @Override
    public void run() {
        double minLatitude = 0.0;
        double maxLatitude = 0.0;
        double minLongitude = 0.0;
        double maxLongitude = 0.0;
        File statRoIFilePath = new File(this.dataset.createStatRoIDir(this.selectedSP) + File.separator + this.roiFile);
        try {
            String aLine;
            BufferedReader bf = new BufferedReader(new FileReader(statRoIFilePath));
            int i = 0;
            while ((aLine = bf.readLine()) != null && i < 4) {
                if (i == 0) {
                    minLatitude = Double.parseDouble(aLine.trim());
                } else if (i == 1) {
                    minLongitude = Double.parseDouble(aLine.trim());
                } else if (i == 2) {
                    maxLatitude = Double.parseDouble(aLine.trim());
                } else if (i == 3) {
                    maxLongitude = Double.parseDouble(aLine.trim());
                }
                ++i;
            }
            bf.close();
        }
        catch (Exception e) {
            e.printStackTrace();
            EventQueue.invokeLater(new Runnable(){

                public void run() {
                    JOptionPane.showMessageDialog(null, "An error occurred when reading coordinates of min and max points of the RoI file.", "Error", 0);
                    ((PSExtractor)PSExtractor.this).ePanel.btnStart.setEnabled(true);
                }
            });
        }
        if (!this.fpsDir.exists()) {
            this.fpsDir.mkdirs();
        }
        for (String aUser : this.list) {
            try {
                String line;
                Process p;
                String[] cmd;
                if (this.dataset.getType() == DataSet.Type.GPS) {
                    cmd = new String[]{"tmp-linux", this.dataset.getOutputPath() + File.separator + "StayPoints" + File.separator + this.selectedSP + File.separator + aUser + ".txt", "" + this.threshold, "" + this.tolerance, "-static", this.dataset.getOutputPath() + File.separator + "RoIs" + File.separator + this.selectedSP + File.separator + this.roiFile, "-no_interpolate", "-side", "" + this.side, "-minlatitude", "" + minLatitude, "-maxlatitude", "" + maxLatitude, "-minlongitude", "" + minLongitude, "-maxlongitude", "" + maxLongitude, "-outputpath", this.fpsDir.getAbsolutePath(), "-weekdays", "" + this.typeDay};
                    p = ProcessRunner.getTMPProcess(cmd, this);
                } else {
                    cmd = new String[]{"tmp-linux", this.dataset.getInputPath() + File.separator + aUser + ".txt", "" + this.threshold, "" + this.tolerance, "-static", this.dataset.getOutputPath() + File.separator + "RoIs" + File.separator + this.roiFile, "-no_interpolate", "-side", "" + this.side, "-minlatitude", "" + minLatitude, "-maxlatitude", "" + maxLatitude, "-minlongitude", "" + minLongitude, "-maxlongitude", "" + maxLongitude, "-outputpath", this.fpsDir.getAbsolutePath(), "-weekdays", "" + this.typeDay};
                    p = ProcessRunner.getTMPProcess(cmd, this);
                }
                BufferedReader bri = new BufferedReader(new InputStreamReader(p.getInputStream()));
                BufferedReader bre = new BufferedReader(new InputStreamReader(p.getErrorStream()));
                while ((line = bri.readLine()) != null) {
                    this.ePanel.addMessage(String.valueOf(line) + "\n");
                }
                bri.close();
                while ((line = bre.readLine()) != null) {
                    this.ePanel.addMessage(String.valueOf(line) + "\n");
                }
                bre.close();
                this.ePanel.addMessage("****************************************************************\n");
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        EventQueue.invokeLater(new Runnable(){

            public void run() {
                ((PSExtractor)PSExtractor.this).ePanel.btnStart.setEnabled(true);
            }
        });
    }
}

