/*
 * Decompiled with CFR 0.152.
 */
package lu.uni.minus.utils;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import javax.swing.JOptionPane;
import lu.uni.minus.ui.MainWindow;
import org.apache.commons.io.FileUtils;

public class ProcessRunner {
    private static String OS = System.getProperty("os.name").toLowerCase();

    public static boolean isWindows() {
        return OS.indexOf("win") >= 0;
    }

    public static boolean isMac() {
        return OS.indexOf("mac") >= 0;
    }

    public static boolean isUnix() {
        return OS.indexOf("nix") >= 0 || OS.indexOf("nux") >= 0 || OS.indexOf("aix") > 0;
    }

    public static boolean isSolaris() {
        return OS.indexOf("sunos") >= 0;
    }

    public static Process getMapProcess(String[] command, Object parent) {
        if (command.length == 0) {
            return null;
        }
        File tempFile = ProcessRunner.createTempFile("map", ".exe", parent);
        command[0] = tempFile.toString();
        File dllFile = new File(String.valueOf(tempFile.getAbsoluteFile().getParent()) + File.separator + "Microsoft.Maps.MapControl.WPF.dll");
        InputStream src = parent.getClass().getResourceAsStream("/commands/Microsoft.Maps.MapControl.WPF.dll");
        try {
            FileUtils.copyInputStreamToFile(src, dllFile);
            src.close();
            dllFile.deleteOnExit();
            ProcessBuilder pb = new ProcessBuilder(command);
            Process result = pb.start();
            return result;
        }
        catch (IOException e) {
            JOptionPane.showMessageDialog((MainWindow)parent, "An error occurred while starting the visualization tool:" + e.getMessage(), "The Error", 0);
            return null;
        }
    }

    public static Process getTMPProcess(String[] command, Object parent) {
        if (command.length == 0) {
            return null;
        }
        String fileName = "not supported";
        String extension = ".run";
        if (ProcessRunner.isWindows()) {
            fileName = "tpm-windows";
            extension = ".exe";
        } else if (ProcessRunner.isUnix()) {
            fileName = "tpm-linux";
            extension = ".run";
        }
        try {
            command[0] = ProcessRunner.createTempFile(fileName, extension, parent).toString();
            ProcessBuilder pb = new ProcessBuilder(command);
            Process result = pb.start();
            return result;
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    private static File createTempFile(String fileName, String extension, Object parent) {
        InputStream src = parent.getClass().getResourceAsStream("/commands/" + fileName + extension);
        try {
            File exeTempFile = File.createTempFile(fileName, extension, null);
            FileUtils.copyInputStreamToFile(src, exeTempFile);
            exeTempFile.setExecutable(true, false);
            src.close();
            exeTempFile.deleteOnExit();
            return exeTempFile;
        }
        catch (IOException e) {
            JOptionPane.showMessageDialog((MainWindow)parent, "An error occurred while starting the visualization tool:" + e.getMessage(), "An Error", 0);
            return null;
        }
    }
}

