/*
 * Decompiled with CFR 0.152.
 */
package lu.uni.minus.utils;

import java.io.PrintWriter;
import java.io.StringWriter;
import javax.swing.SwingWorker;
import lu.uni.minus.ui.Announcer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class TextPaneWorker
extends SwingWorker<Integer, String> {
    private Announcer announcer;

    public TextPaneWorker() {
        this.announcer = null;
    }

    public TextPaneWorker(Announcer an) {
        this.announcer = an;
    }

    public void setAnnouncer(Announcer an) {
        this.announcer = an;
    }

    public void addMessage(String html) {
        if (this.announcer != null) {
            this.announcer.addMessage(html);
        }
    }

    public void addErrorMessage(String html) {
        if (this.announcer != null) {
            this.announcer.addMessage(this.formatError(html));
        }
    }

    public void addException(Exception e) {
        if (this.announcer != null) {
            StringWriter writer = new StringWriter();
            PrintWriter printWriter = new PrintWriter(writer);
            e.printStackTrace(printWriter);
            this.announcer.addMessage(this.formatError(((Object)writer).toString()));
        }
    }

    public void setDone(int i) {
        this.setProgress(i);
    }

    public String formatError(String message) {
        String result = "<div><font size=3 color=RED>[ERROR]" + message + "</font></div>";
        return result;
    }

    public String formatMessage(String message) {
        String result = "<div><font size=3 color=BLACK>" + message + "</font></div>";
        return result;
    }

    public String formatOK(String message) {
        String result = "<div><font size=3 color=GREEN>[OK]" + message + "</font></div>";
        return result;
    }
}

