/*
 * Decompiled with CFR 0.152.
 */
package lu.uni.minus.utils;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import lu.uni.minus.preferences.DataSet;
import lu.uni.minus.ui.AddDSPane;
import lu.uni.minus.utils.TextPaneWorker;
import lu.uni.minus.utils.UserStatistics;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ValidityWorker
extends TextPaneWorker {
    private final DataSet dataset;
    private final AddDSPane myParent;

    public ValidityWorker(DataSet ds, AddDSPane aParent) {
        this.dataset = ds;
        this.myParent = aParent;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected Integer doInBackground() throws Exception {
        BufferedWriter bw;
        UserStatistics stat;
        int n;
        File[] fileArray;
        Object aFile;
        int n2;
        int estimate;
        File aFile2;
        int n3;
        this.publish(this.formatMessage("Checking for duplicate datasets"));
        String message = this.myParent.isIncluded(this.dataset);
        if (message != null) {
            this.publish(this.formatError(message));
            return 1;
        }
        this.setProgress(1);
        this.publish(this.formatOK("No duplicates found."));
        File[] filesInInputDir = this.dataset.getInputPath().listFiles();
        this.setProgress(2);
        if (this.isCancelled()) {
            return 1;
        }
        if (this.dataset.getType() == DataSet.Type.GPS) {
            this.publish(this.formatMessage("Checking subfolders of input directory."));
            if (filesInInputDir == null) {
                this.publish(this.formatError("Input directory \"" + this.dataset.getInputPath().toString() + "\"does not exists"));
                return 1;
            }
            File[] fileArray2 = filesInInputDir;
            n3 = filesInInputDir.length;
            int n4 = 0;
            while (n4 < n3) {
                aFile2 = fileArray2[n4];
                String dirName = aFile2.getName();
                if (!aFile2.isDirectory()) {
                    this.publish(this.formatError("Wrong format of input directory: it contains not a directory file: \"" + dirName + "\""));
                    return 1;
                }
                if (!dirName.matches("\\d{3}")) {
                    this.publish(this.formatError("Wrong format of input directory: subfolder \"" + dirName + "\" does not consist of three digits"));
                    return 1;
                }
                if (this.isCancelled()) {
                    return 1;
                }
                ++n4;
            }
            SimpleDateFormat df = new SimpleDateFormat("yyyyMMdd");
            df.setLenient(false);
            this.setProgress(15);
            estimate = filesInInputDir.length;
            int done = 0;
            File[] fileArray3 = filesInInputDir;
            n2 = filesInInputDir.length;
            int dirName = 0;
            while (dirName < n2) {
                File[] files;
                aFile = fileArray3[dirName];
                File[] fileArray4 = files = new File(aFile + File.separator + "Trajectory").listFiles();
                int n5 = files.length;
                int n6 = 0;
                while (n6 < n5) {
                    File aDayFile = fileArray4[n6];
                    if (!aDayFile.isFile()) {
                        this.publish(this.formatError("Wrong format of input directory:  There are folders in the subfolder of the user " + ((File)aFile).getName() + "."));
                        return 1;
                    }
                    String firstEight = aDayFile.getName().substring(0, 8);
                    try {
                        if (!Character.isDigit(firstEight.charAt(7))) {
                            throw new ParseException(null, 0);
                        }
                        df.parse(firstEight);
                    }
                    catch (ParseException ex) {
                        this.publish(this.formatError("Wrong format of input directory: The user " + ((File)aFile).getName() + " has a filename whose first eight characters are not a valid date."));
                        return 1;
                    }
                    if (this.isCancelled()) {
                        return 1;
                    }
                    ++n6;
                }
                this.setProgress(2 + 18 * ++done / estimate);
                ++dirName;
            }
            this.setProgress(20);
            this.publish(this.formatOK("Only correct subfolders found."));
        } else {
            this.publish(this.formatMessage("Checking files in the input directory."));
            aFile = filesInInputDir;
            n3 = filesInInputDir.length;
            estimate = 0;
            while (estimate < n3) {
                File aFile22 = aFile[estimate];
                if (!aFile22.isFile()) {
                    this.publish(this.formatError("Wrong format of input directory: file \"" + aFile22.toString() + "\" is not a regular file"));
                    return 1;
                }
                if (this.isCancelled()) {
                    return 1;
                }
                ++estimate;
            }
            this.setProgress(10);
            aFile = filesInInputDir;
            n3 = filesInInputDir.length;
            estimate = 0;
            while (estimate < n3) {
                aFile2 = aFile[estimate];
                String fileName = aFile2.getName().substring(0, 3);
                if (!fileName.matches("\\d{3}")) {
                    this.publish(this.formatError("Wrong format of input directory: file \"" + aFile2.getName() + "\" does not start with three digits"));
                    return 1;
                }
                if (this.isCancelled()) {
                    return 1;
                }
                ++estimate;
            }
            this.setProgress(20);
            this.publish(this.formatOK("Only correct files found."));
        }
        StringBuilder sb = new StringBuilder();
        double j = 1.0;
        if (this.dataset.getType() == DataSet.Type.GPS) {
            this.publish(this.formatMessage("Reading GPS dataset and generating statistics."));
            fileArray = filesInInputDir;
            n = filesInInputDir.length;
            n2 = 0;
            while (n2 < n) {
                void var13_27;
                File aUser = fileArray[n2];
                stat = new UserStatistics();
                stat.setUserID(aUser.getName());
                String[] files = new File(aUser + "/Trajectory").list();
                TreeMap map = new TreeMap();
                boolean bl = false;
                while (var13_27 < files.length) {
                    String date = files[var13_27].substring(0, 8);
                    if (map.containsKey(date)) {
                        ((LinkedList)map.get(date)).add(files[var13_27]);
                    } else {
                        LinkedList<String> filelist = new LinkedList<String>();
                        filelist.add(files[var13_27]);
                        map.put(date, filelist);
                    }
                    if (this.isCancelled()) {
                        return 1;
                    }
                    ++var13_27;
                }
                stat.setNumberOfDays(map.size());
                try {
                    for (Map.Entry entry : map.entrySet()) {
                        int numberPointsInTheDay = 0;
                        for (String aFile3 : (LinkedList)entry.getValue()) {
                            BufferedReader br = new BufferedReader(new FileReader(aUser + "/Trajectory/" + aFile3));
                            int k = 0;
                            while (k < 6) {
                                br.readLine();
                                ++k;
                            }
                            while (br.readLine() != null) {
                                ++numberPointsInTheDay;
                            }
                            br.close();
                            if (!this.isCancelled()) continue;
                            return 1;
                        }
                        stat.setNumberOfPoints(stat.getNumberOfPoints() + numberPointsInTheDay);
                        if (stat.getMaxNumberOfPointsInADay() < numberPointsInTheDay) {
                            stat.setMaxNumberOfPointsInADay(numberPointsInTheDay);
                        }
                        if (stat.getMinNumberOfPointsInADay() <= numberPointsInTheDay) continue;
                        stat.setMinNumberOfPointsInADay(numberPointsInTheDay);
                    }
                }
                catch (Exception exception) {
                    this.publish(this.formatError(exception.getMessage()));
                    return 1;
                }
                sb.append(stat.toString());
                this.setProgress((int)(j / (double)filesInInputDir.length * 80.0 + 20.0));
                j += 1.0;
                ++n2;
            }
        } else {
            this.publish(this.formatMessage("Reading SP dataset and generating statistics."));
            fileArray = filesInInputDir;
            n = filesInInputDir.length;
            n2 = 0;
            while (n2 < n) {
                File aUser = fileArray[n2];
                stat = new UserStatistics();
                stat.setUserID(aUser.getName().substring(0, 3));
                int numOfDays = 0;
                int numOfPoints = 0;
                int n4 = 0;
                int minNumOfPointsInADay = Integer.MAX_VALUE;
                try {
                    String aLine;
                    BufferedReader bf = new BufferedReader(new FileReader(aUser));
                    while ((aLine = bf.readLine()) != null) {
                        ++numOfDays;
                        String[] fields = aLine.split(" ");
                        int numberOfPointsInADay = fields.length / 3 - 1;
                        numOfPoints += numberOfPointsInADay;
                        if (n4 < numberOfPointsInADay) {
                            n4 = numberOfPointsInADay;
                        }
                        if (minNumOfPointsInADay <= numberOfPointsInADay) continue;
                        minNumOfPointsInADay = numberOfPointsInADay;
                    }
                    bf.close();
                    if (this.isCancelled()) {
                        return 1;
                    }
                }
                catch (Exception e) {
                    this.publish(this.formatError(e.getMessage()));
                    return 1;
                }
                stat.setNumberOfDays(numOfDays);
                stat.setNumberOfPoints(numOfPoints);
                stat.setMaxNumberOfPointsInADay(n4);
                stat.setMinNumberOfPointsInADay(minNumOfPointsInADay);
                sb.append(stat.toString());
                this.setProgress((int)(j / (double)filesInInputDir.length * 80.0 + 20.0));
                j += 1.0;
                ++n2;
            }
        }
        File dir = new File(String.valueOf(this.dataset.getOutputPath().toString()) + "/Stats");
        if (!dir.exists()) {
            dir.mkdirs();
        }
        if (this.dataset.getType() == DataSet.Type.GPS) {
            File dira = new File(String.valueOf(this.dataset.getOutputPath().toString()) + "/Stats/SourceDataAndStayPoints");
            if (!dira.exists()) {
                dira.mkdirs();
            }
            bw = new BufferedWriter(new FileWriter(dira + "/SourceData.txt"));
        } else {
            bw = new BufferedWriter(new FileWriter(dir + "/StayPoints.txt"));
        }
        bw.write(sb.toString());
        bw.close();
        this.publish(this.formatOK("Finished."));
        this.setProgress(100);
        return 0;
    }

    @Override
    protected void process(List<String> chunks) {
        for (String string : chunks) {
            this.addMessage(string);
        }
    }
}

