/*
 * Decompiled with CFR 0.152.
 */
package lu.uni.minus.utils.cps;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.CopyOnWriteArraySet;
import lu.uni.minus.utils.cps.Bijection;
import lu.uni.minus.utils.cps.DistributionFrequentPattern;
import lu.uni.minus.utils.cps.PatternPair;
import lu.uni.minus.utils.cps.SemanticTagPattern;
import lu.uni.minus.utils.cps.SemanticTagPatternSet;
import org.jgrapht.alg.BronKerboschCliqueFinder;
import org.jgrapht.graph.DefaultWeightedEdge;
import org.jgrapht.graph.SimpleWeightedGraph;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DistributionFrequentPatternSet {
    private LinkedList<DistributionFrequentPattern> frequentPatterns;

    public DistributionFrequentPatternSet() {
        this.frequentPatterns = new LinkedList();
    }

    public DistributionFrequentPatternSet(LinkedList<DistributionFrequentPattern> someFrequentPatterns) {
        this.frequentPatterns = someFrequentPatterns;
    }

    public LinkedList<DistributionFrequentPattern> getFrequentPatterns() {
        return this.frequentPatterns;
    }

    public SemanticTagPatternSet convertToSemanticTagPatternSet(boolean ifThresholdOnProb, double thresholdOnProbabilities, double threSup) {
        if (ifThresholdOnProb) {
            TreeMap map = new TreeMap();
            for (DistributionFrequentPattern aFrequentPattern : this.frequentPatterns) {
                int n = aFrequentPattern.getDistributions().size();
                if (map.containsKey(n)) {
                    ((CopyOnWriteArraySet)map.get(n)).add(aFrequentPattern);
                    continue;
                }
                CopyOnWriteArraySet<DistributionFrequentPattern> newSet = new CopyOnWriteArraySet<DistributionFrequentPattern>();
                newSet.add(aFrequentPattern);
                map.put(n, newSet);
            }
            ArrayList semanticTagPatternSetsByLength = new ArrayList();
            int i = 0;
            while (i < map.size()) {
                CopyOnWriteArraySet copyOnWriteArraySet = new CopyOnWriteArraySet();
                semanticTagPatternSetsByLength.add(copyOnWriteArraySet);
                ++i;
            }
            for (Map.Entry anEntry : map.entrySet()) {
                int key = (Integer)anEntry.getKey();
                CopyOnWriteArraySet value = (CopyOnWriteArraySet)anEntry.getValue();
                if (key == 1) {
                    for (DistributionFrequentPattern aFrequentPattern : value) {
                        int distributionCount = 0;
                        LinkedList<Integer> tags = new LinkedList<Integer>();
                        this.convertOnePatternToSemanticTagPatterns((CopyOnWriteArraySet)semanticTagPatternSetsByLength.get(0), aFrequentPattern, distributionCount, tags);
                    }
                    continue;
                }
                CopyOnWriteArraySet semanticTagPatternSetOfLengthShorterBy1 = (CopyOnWriteArraySet)semanticTagPatternSetsByLength.get(key - 2);
                for (SemanticTagPattern aSemanticPatternOfLengthShorterBy1 : semanticTagPatternSetOfLengthShorterBy1) {
                    for (DistributionFrequentPattern aPatternOfLengthKey : value) {
                        if (!aPatternOfLengthKey.canGeneratePrefixSemanticPattern(aSemanticPatternOfLengthShorterBy1)) continue;
                        double[] probabilitiesOfLastDistribution = aPatternOfLengthKey.getDistributions().getLast().getProbabilites();
                        int i2 = 0;
                        while (i2 < probabilitiesOfLastDistribution.length) {
                            if (probabilitiesOfLastDistribution[i2] != 0.0) {
                                int[] semanticTags = Arrays.copyOf(aSemanticPatternOfLengthShorterBy1.getSemanticTags(), key);
                                semanticTags[key - 1] = i2;
                                double product = 1.0;
                                int i22 = 0;
                                while (i22 < semanticTags.length) {
                                    product *= aPatternOfLengthKey.getDistributions().get(i22).getProbabilites()[semanticTags[i22]];
                                    ++i22;
                                }
                                SemanticTagPattern newSemanticTagPattern = new SemanticTagPattern(semanticTags, product * aPatternOfLengthKey.getRelativeSupport());
                                CopyOnWriteArraySet semanticTagPatternSetOfLengthKey = (CopyOnWriteArraySet)semanticTagPatternSetsByLength.get(key - 1);
                                if (!semanticTagPatternSetOfLengthKey.add(newSemanticTagPattern)) {
                                    for (SemanticTagPattern aSemanticTagPattern : semanticTagPatternSetOfLengthKey) {
                                        if (!aSemanticTagPattern.equals(newSemanticTagPattern)) continue;
                                        aSemanticTagPattern.setRelativeSupport(aSemanticTagPattern.getRelativeSupport() + newSemanticTagPattern.getRelativeSupport());
                                        break;
                                    }
                                }
                            }
                            ++i2;
                        }
                    }
                }
            }
            CopyOnWriteArraySet<SemanticTagPattern> tagPatterns = new CopyOnWriteArraySet<SemanticTagPattern>();
            for (CopyOnWriteArraySet copyOnWriteArraySet : semanticTagPatternSetsByLength) {
                tagPatterns.addAll(copyOnWriteArraySet);
            }
            return new SemanticTagPatternSet(tagPatterns);
        }
        TreeMap map = new TreeMap();
        for (DistributionFrequentPattern aFrequentPattern : this.frequentPatterns) {
            int n = aFrequentPattern.getDistributions().size();
            if (map.containsKey(n)) {
                ((CopyOnWriteArraySet)map.get(n)).add(aFrequentPattern);
                continue;
            }
            CopyOnWriteArraySet<DistributionFrequentPattern> newSet = new CopyOnWriteArraySet<DistributionFrequentPattern>();
            newSet.add(aFrequentPattern);
            map.put(n, newSet);
        }
        ArrayList semanticTagPatternSetsByLength = new ArrayList();
        int i = 0;
        while (i < map.size()) {
            CopyOnWriteArraySet copyOnWriteArraySet = new CopyOnWriteArraySet();
            semanticTagPatternSetsByLength.add(copyOnWriteArraySet);
            ++i;
        }
        CopyOnWriteArraySet<SemanticTagPattern> tagPatterns = new CopyOnWriteArraySet<SemanticTagPattern>();
        for (Map.Entry entry : map.entrySet()) {
            int key = (Integer)entry.getKey();
            CopyOnWriteArraySet value = (CopyOnWriteArraySet)entry.getValue();
            for (DistributionFrequentPattern aFrequentPattern : value) {
                int distributionCount = 0;
                LinkedList<Integer> tags = new LinkedList<Integer>();
                this.convertOnePatternToSemanticTagPatterns((CopyOnWriteArraySet)semanticTagPatternSetsByLength.get(key - 1), aFrequentPattern, distributionCount, tags);
            }
            double threshold = (double)value.size() * threSup * Math.pow(thresholdOnProbabilities, key);
            CopyOnWriteArraySet semanticTagPatternSetOfLengthKey = (CopyOnWriteArraySet)semanticTagPatternSetsByLength.get(key - 1);
            for (SemanticTagPattern aTagPatternOfLengthKey : semanticTagPatternSetOfLengthKey) {
                if (!(aTagPatternOfLengthKey.getRelativeSupport() >= threshold)) continue;
                tagPatterns.add(aTagPatternOfLengthKey);
            }
        }
        return new SemanticTagPatternSet(tagPatterns);
    }

    private void convertOnePatternToSemanticTagPatterns(CopyOnWriteArraySet<SemanticTagPattern> semanticTagPatterns, DistributionFrequentPattern aFrequentPattern, int distributionCount, LinkedList<Integer> tags) {
        if (distributionCount == aFrequentPattern.getDistributions().size()) {
            return;
        }
        double[] probabilites = aFrequentPattern.getDistributions().get(distributionCount).getProbabilites();
        int index = 0;
        while (index < probabilites.length) {
            if (probabilites[index] != 0.0) {
                tags.add(index);
                this.convertOnePatternToSemanticTagPatterns(semanticTagPatterns, aFrequentPattern, ++distributionCount, tags);
                if (--distributionCount == aFrequentPattern.getDistributions().size() - 1) {
                    Integer[] semanticTagsIntegers = tags.toArray(new Integer[]{1});
                    int[] semanticTags = new int[semanticTagsIntegers.length];
                    int i = 0;
                    while (i < semanticTagsIntegers.length) {
                        semanticTags[i] = semanticTagsIntegers[i];
                        ++i;
                    }
                    double product = 1.0;
                    int i2 = 0;
                    while (i2 < semanticTags.length) {
                        product *= aFrequentPattern.getDistributions().get(i2).getProbabilites()[semanticTags[i2]];
                        ++i2;
                    }
                    SemanticTagPattern newSemanticTagPattern = new SemanticTagPattern(semanticTags, product * aFrequentPattern.getRelativeSupport());
                    if (!semanticTagPatterns.add(newSemanticTagPattern)) {
                        for (SemanticTagPattern aSemanticTagPattern : semanticTagPatterns) {
                            if (!aSemanticTagPattern.equals(newSemanticTagPattern)) continue;
                            aSemanticTagPattern.setRelativeSupport(aSemanticTagPattern.getRelativeSupport() + newSemanticTagPattern.getRelativeSupport());
                            break;
                        }
                    }
                    tags.removeLast();
                }
            }
            ++index;
        }
        --distributionCount;
        if (tags.size() > 0) {
            tags.removeLast();
        }
    }

    public String toString() {
        String aString = "";
        for (DistributionFrequentPattern aFrequentPattern : this.frequentPatterns) {
            aString = String.valueOf(aString) + aFrequentPattern.toString();
        }
        return aString;
    }

    public double functionF() {
        double sumOfSupports = 0.0;
        for (DistributionFrequentPattern aFrequentPattern : this.frequentPatterns) {
            sumOfSupports += Math.pow(aFrequentPattern.getDistributions().size(), 2.0) * aFrequentPattern.getRelativeSupport();
        }
        return sumOfSupports;
    }

    public void mergeLSsimilarPatterns() {
        LinkedList<DistributionFrequentPattern> patternsAfterMerging = new LinkedList<DistributionFrequentPattern>();
        SimpleWeightedGraph<DistributionFrequentPattern, DefaultWeightedEdge> patternsGraph = new SimpleWeightedGraph<DistributionFrequentPattern, DefaultWeightedEdge>(DefaultWeightedEdge.class);
        for (DistributionFrequentPattern aVertex : this.frequentPatterns) {
            patternsGraph.addVertex(aVertex);
        }
        for (DistributionFrequentPattern aVertex : this.frequentPatterns) {
            for (DistributionFrequentPattern anotherVertex : this.frequentPatterns) {
                DefaultWeightedEdge anEdge;
                if (aVertex == anotherVertex || !aVertex.isLSsimilar(anotherVertex) || (anEdge = (DefaultWeightedEdge)patternsGraph.addEdge(aVertex, anotherVertex)) == null) continue;
                patternsGraph.setEdgeWeight(anEdge, aVertex.calculateDistance(anotherVertex));
            }
        }
        do {
            BronKerboschCliqueFinder aCliqueFinder = new BronKerboschCliqueFinder(patternsGraph);
            Collection allMaximumCliques = aCliqueFinder.getBiggestMaximalCliques();
            Set optimalMaximumClique = null;
            double minimumTwiceSumOfEdgeWeights = Double.MAX_VALUE;
            if (allMaximumCliques.size() > 1) {
                for (Set aMaximumClique : allMaximumCliques) {
                    double twiceSumOfEdgeWeights = 0.0;
                    for (DistributionFrequentPattern vertex1 : aMaximumClique) {
                        for (DistributionFrequentPattern vertex2 : aMaximumClique) {
                            if (vertex1 == vertex2) continue;
                            twiceSumOfEdgeWeights += patternsGraph.getEdgeWeight((DefaultWeightedEdge)patternsGraph.getEdge(vertex1, vertex2));
                        }
                    }
                    if (!(twiceSumOfEdgeWeights < minimumTwiceSumOfEdgeWeights)) continue;
                    optimalMaximumClique = aMaximumClique;
                    minimumTwiceSumOfEdgeWeights = twiceSumOfEdgeWeights;
                }
            } else {
                optimalMaximumClique = allMaximumCliques.iterator().next();
            }
            DistributionFrequentPattern newPattern = null;
            boolean firstTime = true;
            for (DistributionFrequentPattern aPattern : optimalMaximumClique) {
                if (firstTime) {
                    newPattern = aPattern;
                    firstTime = false;
                    continue;
                }
                newPattern = newPattern.merge(aPattern);
            }
            patternsAfterMerging.add(newPattern);
            patternsGraph.removeAllVertices(optimalMaximumClique);
        } while (patternsGraph.vertexSet().size() != 0);
        this.frequentPatterns = patternsAfterMerging;
    }

    public Bijection findOptimalBijection(DistributionFrequentPatternSet anotherFrequentPatternSet) {
        Bijection optimalBijection = new Bijection();
        LinkedList<PatternPair> allLSsimilarPatternPairs = new LinkedList<PatternPair>();
        for (DistributionFrequentPattern pattern1 : this.frequentPatterns) {
            for (DistributionFrequentPattern pattern2 : anotherFrequentPatternSet.getFrequentPatterns()) {
                if (!pattern1.isLSsimilar(pattern2)) continue;
                allLSsimilarPatternPairs.add(new PatternPair(pattern1, pattern2));
            }
        }
        Collections.sort(allLSsimilarPatternPairs);
        HashSet<DistributionFrequentPattern> allPatternsFound = new HashSet<DistributionFrequentPattern>();
        for (PatternPair aPatternPair : allLSsimilarPatternPairs) {
            if (allPatternsFound.contains(aPatternPair.getPattern1()) || allPatternsFound.contains(aPatternPair.getPattern2())) continue;
            optimalBijection.getCommonPatternSet().add(aPatternPair);
            allPatternsFound.add(aPatternPair.getPattern1());
            allPatternsFound.add(aPatternPair.getPattern2());
        }
        return optimalBijection;
    }
}

