/*
 * Decompiled with CFR 0.152.
 */
package lu.uni.minus.utils.cps;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.NoSuchElementException;
import lu.uni.minus.utils.cps.Distribution;
import lu.uni.minus.utils.cps.DistributionFrequentPattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PatternPair
implements Comparable<PatternPair> {
    private DistributionFrequentPattern pattern1;
    private DistributionFrequentPattern pattern2;

    public PatternPair() {
        this.pattern1 = new DistributionFrequentPattern();
        this.pattern2 = new DistributionFrequentPattern();
    }

    public PatternPair(DistributionFrequentPattern aPattern, DistributionFrequentPattern anotherPattern) {
        this.pattern1 = aPattern;
        this.pattern2 = anotherPattern;
    }

    public String toString() {
        String aString = "---------PatternPair beginning----------\n";
        aString = String.valueOf(aString) + this.pattern1.toString() + this.pattern2.toString();
        aString = String.valueOf(aString) + "---------PatternPair end----------\n";
        return aString;
    }

    public DistributionFrequentPattern getPattern1() {
        return this.pattern1;
    }

    public DistributionFrequentPattern getPattern2() {
        return this.pattern2;
    }

    public void setPattern1(DistributionFrequentPattern aPattern) {
        this.pattern1 = aPattern;
    }

    public void setPattern2(DistributionFrequentPattern aPattern) {
        this.pattern2 = aPattern;
    }

    public boolean equals(Object anObject) {
        if (this == anObject) {
            return true;
        }
        if (anObject == null) {
            return false;
        }
        if (!(anObject instanceof PatternPair)) {
            return false;
        }
        PatternPair anotherPatternPair = (PatternPair)anObject;
        return this.pattern1.equals(anotherPatternPair.getPattern1()) && this.pattern2.equals(anotherPatternPair.getPattern2());
    }

    @Override
    public int compareTo(PatternPair anotherPatternPair) {
        double distanceOfAnotherPatternPair;
        double distanceOfThisPatternPair = this.calculateDistance();
        if (distanceOfThisPatternPair < (distanceOfAnotherPatternPair = anotherPatternPair.calculateDistance())) {
            return -1;
        }
        if (distanceOfThisPatternPair == distanceOfAnotherPatternPair) {
            return 0;
        }
        return 1;
    }

    public double calculateDistance() {
        LinkedList<Distribution> distributionsOfPattern1 = this.pattern1.getDistributions();
        LinkedList<Distribution> distributionsOfPattern2 = this.pattern2.getDistributions();
        if (distributionsOfPattern1.size() != distributionsOfPattern2.size()) {
            System.out.println("The two patterns are not of the same length. Cannot calculate their distance.");
            System.exit(0);
        }
        double sum = 0.0;
        Iterator iterator1 = distributionsOfPattern1.iterator();
        Iterator iterator2 = distributionsOfPattern2.iterator();
        try {
            while (iterator1.hasNext()) {
                Distribution distribution1 = (Distribution)iterator1.next();
                Distribution distribution2 = (Distribution)iterator2.next();
                sum += distribution1.calculateDistance(distribution2);
            }
        }
        catch (NoSuchElementException e) {
            e.printStackTrace();
        }
        return sum / (double)distributionsOfPattern1.size();
    }
}

