/*
 * Decompiled with CFR 0.152.
 */
package lu.uni.minus.utils.cps;

import java.util.concurrent.CopyOnWriteArraySet;
import lu.uni.minus.utils.cps.CommonSemanticTagPattern;
import lu.uni.minus.utils.cps.SemanticTagPattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SemanticTagPatternSet {
    private CopyOnWriteArraySet<SemanticTagPattern> patterns;

    public SemanticTagPatternSet() {
        this.patterns = new CopyOnWriteArraySet();
    }

    public SemanticTagPatternSet(CopyOnWriteArraySet<SemanticTagPattern> somePatterns) {
        this.patterns = somePatterns;
    }

    public CopyOnWriteArraySet<SemanticTagPattern> getPatterns() {
        return this.patterns;
    }

    public String toString() {
        String aString = "";
        for (SemanticTagPattern aPattern : this.patterns) {
            aString = String.valueOf(aString) + aPattern + "\n";
        }
        return aString;
    }

    public double calculateSimilaritySumsOfCommonPatterns() {
        double sum = 0.0;
        for (SemanticTagPattern aPattern : this.patterns) {
            double relativeSupport2;
            CommonSemanticTagPattern aCommonPattern = (CommonSemanticTagPattern)aPattern;
            double relativeSupport = aCommonPattern.getRelativeSupport();
            if (relativeSupport < (relativeSupport2 = aCommonPattern.getRelativeSupport2())) {
                sum += relativeSupport / relativeSupport2;
                continue;
            }
            sum += relativeSupport2 / relativeSupport;
        }
        return sum;
    }

    public SemanticTagPatternSet intersect(SemanticTagPatternSet anotherSet) {
        CopyOnWriteArraySet<SemanticTagPattern> commonPatterns = new CopyOnWriteArraySet<SemanticTagPattern>();
        for (SemanticTagPattern aPattern : this.patterns) {
            for (SemanticTagPattern anotherPattern : anotherSet.getPatterns()) {
                if (!aPattern.equals(anotherPattern)) continue;
                commonPatterns.add(new CommonSemanticTagPattern(aPattern, anotherPattern));
            }
        }
        return new SemanticTagPatternSet(commonPatterns);
    }

    public double functionF() {
        double sum = 0.0;
        for (SemanticTagPattern aPattern : this.patterns) {
            sum += (double)aPattern.getSemanticTags().length * aPattern.getRelativeSupport();
        }
        return sum;
    }

    public double functionF(int user) {
        double sum = 0.0;
        if (user == 1) {
            for (SemanticTagPattern aPattern : this.patterns) {
                sum += (double)aPattern.getSemanticTags().length * aPattern.getRelativeSupport();
            }
        } else {
            for (SemanticTagPattern aPattern : this.patterns) {
                sum += (double)aPattern.getSemanticTags().length * ((CommonSemanticTagPattern)aPattern).getRelativeSupport2();
            }
        }
        return sum;
    }

    public double supSim() {
        double sumDif = 0.0;
        double sum = 0.0;
        for (SemanticTagPattern aCommonSemanticPattern : this.patterns) {
            sum += aCommonSemanticPattern.getRelativeSupport() + ((CommonSemanticTagPattern)aCommonSemanticPattern).getRelativeSupport2();
        }
        if (sum == 0.0) {
            return 1.0;
        }
        return 1.0 - sumDif / sum;
    }
}

