/*
 * Decompiled with CFR 0.152.
 */
package lu.uni.minus.utils.cps;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.CopyOnWriteArraySet;
import lu.uni.minus.utils.cps.Distribution;
import lu.uni.minus.utils.cps.DistributionFrequentPatternSet;
import lu.uni.minus.utils.cps.FileOperations;
import lu.uni.minus.utils.cps.RoIFrequentPatternSet;
import lu.uni.minus.utils.cps.SemanticTagPatternSet;
import lu.uni.minus.utils.cps.UserCombination;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UserComparisonCPS {
    private static int numberST;

    private double calculateSimilarityWithSemantics(File file1, File file2, HashMap<String, Distribution> mapFromRegionToDistribution, boolean ifThresholdOnProb, double thresholdOnProbabilities, double threSup) throws Exception {
        RoIFrequentPatternSet RoIuser1 = FileOperations.readFile(file1);
        RoIFrequentPatternSet RoIuser2 = FileOperations.readFile(file2);
        DistributionFrequentPatternSet distributionUser1 = RoIuser1.convertToDistributionPatternSet(mapFromRegionToDistribution);
        DistributionFrequentPatternSet distributionUser2 = RoIuser2.convertToDistributionPatternSet(mapFromRegionToDistribution);
        SemanticTagPatternSet user1ByTagPatterns = distributionUser1.convertToSemanticTagPatternSet(ifThresholdOnProb, thresholdOnProbabilities, threSup);
        SemanticTagPatternSet user2ByTagPatterns = distributionUser2.convertToSemanticTagPatternSet(ifThresholdOnProb, thresholdOnProbabilities, threSup);
        SemanticTagPatternSet intersection = user1ByTagPatterns.intersect(user2ByTagPatterns);
        double weightOfUser1 = user1ByTagPatterns.functionF();
        double weightOfUser2 = user2ByTagPatterns.functionF();
        double weight1OfIntersection = intersection.functionF(1);
        double weight2OfIntersection = intersection.functionF(2);
        double ap = Math.sqrt(weight1OfIntersection / weightOfUser1 * (weight2OfIntersection / weightOfUser2));
        double supSim = intersection.supSim();
        return ap * supSim;
    }

    private double calculateSimilarity(File file1, File file2) {
        RoIFrequentPatternSet RoIUser1 = FileOperations.readFile(file1);
        RoIFrequentPatternSet RoIUser2 = FileOperations.readFile(file2);
        RoIFrequentPatternSet intersection = RoIUser1.intersect(RoIUser2);
        double weight1OfIntersection = intersection.functionF(1);
        double weight2OfIntersection = intersection.functionF(2);
        double weightOfUser1 = RoIUser1.functionF();
        double weightOfUser2 = RoIUser2.functionF();
        return Math.sqrt(weight1OfIntersection / weightOfUser1 * (weight2OfIntersection / weightOfUser2)) * intersection.supSim();
    }

    public double[][] compareUsers(String outputPathnameOfDataset, String pathnameOfDistributionFile, List<String> selectedUsers, boolean semantics, String dirsPath, boolean ifThresholdOnProb, double thresholdOnProbabilities, double threSup) throws Exception {
        int n;
        int n2;
        long startTime = System.currentTimeMillis();
        CopyOnWriteArraySet<UserCombination> filesProcessed = new CopyOnWriteArraySet<UserCombination>();
        File[] allFiles = new File[selectedUsers.size()];
        int i = 0;
        while (i < selectedUsers.size()) {
            allFiles[i] = new File(String.valueOf(outputPathnameOfDataset) + "/PatternSets/" + dirsPath + "/" + selectedUsers.get(i) + "MiSTA.output");
            ++i;
        }
        if (semantics) {
            HashMap<String, Distribution> mapFromRegionToDistribution = UserComparisonCPS.readDistributionFile(pathnameOfDistributionFile, ifThresholdOnProb, thresholdOnProbabilities);
            File[] fileArray = allFiles;
            int n3 = allFiles.length;
            n2 = 0;
            while (n2 < n3) {
                File aFile = fileArray[n2];
                File[] fileArray2 = allFiles;
                int n4 = allFiles.length;
                n = 0;
                while (n < n4) {
                    File anotherFile = fileArray2[n];
                    UserCombination aUserCombination = new UserCombination(aFile, anotherFile);
                    if (!filesProcessed.contains(aUserCombination)) {
                        aUserCombination.Similarity = this.calculateSimilarityWithSemantics(aFile, anotherFile, mapFromRegionToDistribution, ifThresholdOnProb, thresholdOnProbabilities, threSup);
                        filesProcessed.add(aUserCombination);
                    }
                    ++n;
                }
                ++n2;
            }
        } else {
            File[] fileArray = allFiles;
            n2 = allFiles.length;
            int aFile = 0;
            while (aFile < n2) {
                File aFile2 = fileArray[aFile];
                File[] fileArray3 = allFiles;
                n = allFiles.length;
                int anotherFile = 0;
                while (anotherFile < n) {
                    File anotherFile2 = fileArray3[anotherFile];
                    UserCombination aUserCombination = new UserCombination(aFile2, anotherFile2);
                    if (!filesProcessed.contains(aUserCombination)) {
                        aUserCombination.Similarity = this.calculateSimilarity(aFile2, anotherFile2);
                        filesProcessed.add(aUserCombination);
                    }
                    ++anotherFile;
                }
                ++aFile;
            }
        }
        HashSet<String> allUsers = new HashSet<String>();
        for (UserCombination aUserCombination : filesProcessed) {
            allUsers.add(aUserCombination.User1);
            allUsers.add(aUserCombination.User2);
        }
        long endTime = System.currentTimeMillis();
        System.out.println(startTime - endTime);
        ArrayList allUsersForSorting = new ArrayList(allUsers);
        Collections.sort(allUsersForSorting);
        int numberOfUsers = allUsers.size();
        double[][] similarities = new double[numberOfUsers][numberOfUsers];
        for (UserCombination aUserCombination : filesProcessed) {
            int index1 = allUsersForSorting.indexOf(aUserCombination.User1);
            int index2 = allUsersForSorting.indexOf(aUserCombination.User2);
            similarities[index1][index2] = aUserCombination.Similarity;
            similarities[index2][index1] = aUserCombination.Similarity;
        }
        StringBuilder aStringBuilder = new StringBuilder(",");
        for (String aUser : allUsersForSorting) {
            aStringBuilder.append(aUser);
            aStringBuilder.append(",");
        }
        aStringBuilder.append("\n");
        int rowIndex = 0;
        while (rowIndex < numberOfUsers) {
            aStringBuilder.append((String)allUsersForSorting.get(rowIndex));
            aStringBuilder.append(",");
            int columnIndex = 0;
            while (columnIndex < numberOfUsers) {
                aStringBuilder.append(similarities[rowIndex][columnIndex]);
                aStringBuilder.append(",");
                ++columnIndex;
            }
            aStringBuilder.append("\n");
            ++rowIndex;
        }
        StringBuilder sb = new StringBuilder();
        int numberUsers = selectedUsers.size();
        int i2 = 0;
        while (i2 < numberUsers) {
            if (i2 != numberUsers - 1) {
                sb.append(String.valueOf(selectedUsers.get(i2)) + "_");
            } else {
                sb.append(selectedUsers.get(i2));
            }
            ++i2;
        }
        File outputDir = new File(String.valueOf(outputPathnameOfDataset) + "/ComparisonResults/" + dirsPath + "/" + sb.toString());
        if (!outputDir.exists()) {
            outputDir.mkdirs();
        }
        try {
            String outputPathname = semantics ? (ifThresholdOnProb ? outputDir + "/CPSWithSemanticsThresholdOnProbabilities_" + thresholdOnProbabilities + ".csv" : outputDir + "/CPSWithSemanticsThresholdOnSemanticPatterns_" + thresholdOnProbabilities + ".csv") : outputDir + "/CPSWithoutSemantics.csv";
            BufferedWriter bufferedWriter = new BufferedWriter(new FileWriter(outputPathname));
            bufferedWriter.write(aStringBuilder.toString());
            bufferedWriter.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return similarities;
    }

    private static HashMap<String, Distribution> readDistributionFile(String pathnameOfDistributionFile, boolean ifThresholdOnProb, double thresholdOnProbabilities) {
        HashMap<String, Distribution> mapFromRegionToDistribution = new HashMap<String, Distribution>();
        try {
            BufferedReader bufferedReader = new BufferedReader(new FileReader(pathnameOfDistributionFile));
            String aLine = null;
            boolean firstLine = true;
            numberST = 0;
            while ((aLine = bufferedReader.readLine()) != null) {
                String[] fields = aLine.split("\t");
                if (firstLine) {
                    numberST = fields.length - 1;
                    firstLine = false;
                }
                double[] probabilities = new double[numberST];
                int i = 0;
                while (i < numberST) {
                    probabilities[i] = Double.parseDouble(fields[i + 1]);
                    if (ifThresholdOnProb && probabilities[i] < thresholdOnProbabilities) {
                        probabilities[i] = 0.0;
                    }
                    ++i;
                }
                mapFromRegionToDistribution.put(fields[0].trim(), new Distribution(probabilities));
            }
            bufferedReader.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return mapFromRegionToDistribution;
    }
}

