/*
 * Decompiled with CFR 0.152.
 */
package lu.uni.minus.utils.hausdorff;

import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.CopyOnWriteArraySet;
import lu.uni.minus.utils.hausdorff.FrequentPattern;
import lu.uni.minus.utils.hausdorff.PatternPair;
import org.jgrapht.alg.BronKerboschCliqueFinder;
import org.jgrapht.graph.DefaultWeightedEdge;
import org.jgrapht.graph.SimpleWeightedGraph;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FrequentPatternSet {
    private LinkedList<FrequentPattern> frequentPatterns;

    public FrequentPatternSet() {
        this.frequentPatterns = new LinkedList();
    }

    public FrequentPatternSet(LinkedList<FrequentPattern> someFrequentPatterns) {
        this.frequentPatterns = someFrequentPatterns;
    }

    public LinkedList<FrequentPattern> getFrequentPatterns() {
        return this.frequentPatterns;
    }

    public double calculateSimilarity(FrequentPatternSet anotherSet, boolean adjustLen, boolean hellinger) {
        TreeMap<Integer, CopyOnWriteArraySet<FrequentPattern>> map1 = this.getMapByLength();
        TreeMap<Integer, CopyOnWriteArraySet<FrequentPattern>> map2 = anotherSet.getMapByLength();
        Iterator<Map.Entry<Integer, CopyOnWriteArraySet<FrequentPattern>>> iterator1 = map1.entrySet().iterator();
        Iterator<Map.Entry<Integer, CopyOnWriteArraySet<FrequentPattern>>> iterator2 = map2.entrySet().iterator();
        double[] distances = null;
        try {
            Map.Entry<Integer, CopyOnWriteArraySet<FrequentPattern>> entry2;
            if (map1.size() < map2.size()) {
                distances = new double[map2.size()];
                while (iterator1.hasNext()) {
                    Map.Entry<Integer, CopyOnWriteArraySet<FrequentPattern>> entry1 = iterator1.next();
                    entry2 = iterator2.next();
                    distances[entry1.getKey().intValue() - 1] = this.calculateHausdorffDistance(entry1.getValue(), entry2.getValue(), adjustLen, hellinger);
                }
                int i = map1.size();
                while (i < map2.size()) {
                    distances[i] = 1.0;
                    ++i;
                }
            } else {
                distances = new double[map1.size()];
                while (iterator2.hasNext()) {
                    Map.Entry<Integer, CopyOnWriteArraySet<FrequentPattern>> entry1 = iterator1.next();
                    entry2 = iterator2.next();
                    distances[entry1.getKey().intValue() - 1] = this.calculateHausdorffDistance(entry1.getValue(), entry2.getValue(), adjustLen, hellinger);
                }
                int i = map2.size();
                while (i < map1.size()) {
                    distances[i] = 1.0;
                    ++i;
                }
            }
        }
        catch (NoSuchElementException e) {
            e.printStackTrace();
        }
        double[] similarities = new double[distances.length];
        int i = 0;
        while (i < distances.length) {
            similarities[i] = 1.0 - distances[i];
            ++i;
        }
        double sumOfWeightedSimilarities = 0.0;
        int sumOfWeights = 0;
        int i2 = 0;
        while (i2 < similarities.length) {
            sumOfWeightedSimilarities += similarities[i2] * Math.pow(i2 + 1, 2.0);
            sumOfWeights = (int)((double)sumOfWeights + Math.pow(i2 + 1, 2.0));
            ++i2;
        }
        double similarity = sumOfWeightedSimilarities / (double)sumOfWeights;
        return similarity;
    }

    public double calculateHausdorffDistance(CopyOnWriteArraySet<FrequentPattern> set1, CopyOnWriteArraySet<FrequentPattern> set2, boolean adjustLen, boolean hellinger) {
        double distance;
        double minDistance;
        HashMap<PatternPair, Double> mapFromPatternPairToDistance = this.calculateDistancesBetweenAnyPairOfPatterns(set1, set2, adjustLen, hellinger);
        CopyOnWriteArraySet<Double> minDistancesOfSet1 = new CopyOnWriteArraySet<Double>();
        CopyOnWriteArraySet<Double> minDistancesOfSet2 = new CopyOnWriteArraySet<Double>();
        for (FrequentPattern pattern1 : set1) {
            minDistance = Double.MAX_VALUE;
            for (FrequentPattern pattern2 : set2) {
                distance = mapFromPatternPairToDistance.get(new PatternPair(pattern1, pattern2));
                if (!(distance < minDistance)) continue;
                minDistance = distance;
            }
            minDistancesOfSet1.add(minDistance);
        }
        for (FrequentPattern pattern2 : set2) {
            minDistance = Double.MAX_VALUE;
            for (FrequentPattern pattern1 : set1) {
                distance = mapFromPatternPairToDistance.get(new PatternPair(pattern1, pattern2));
                if (!(distance < minDistance)) continue;
                minDistance = distance;
            }
            minDistancesOfSet2.add(minDistance);
        }
        double maxDistanceSet1 = -1.0;
        double maxDistanceSet2 = -1.0;
        for (Double aDistance : minDistancesOfSet1) {
            if (!(aDistance > maxDistanceSet1)) continue;
            maxDistanceSet1 = aDistance;
        }
        for (Double aDistance : minDistancesOfSet2) {
            if (!(aDistance > maxDistanceSet2)) continue;
            maxDistanceSet2 = aDistance;
        }
        return (maxDistanceSet1 + maxDistanceSet2) / 2.0;
    }

    public HashMap<PatternPair, Double> calculateDistancesBetweenAnyPairOfPatterns(CopyOnWriteArraySet<FrequentPattern> set1, CopyOnWriteArraySet<FrequentPattern> set2, boolean adjustLen, boolean hellinger) {
        HashMap<PatternPair, Double> map = new HashMap<PatternPair, Double>();
        for (FrequentPattern pattern1 : set1) {
            for (FrequentPattern pattern2 : set2) {
                double distance = 0.0;
                if (adjustLen && hellinger) {
                    distance = pattern1.calculateHellingerDistance2(pattern2) * (1.0 - pattern1.getRelativeSupport() * pattern2.getRelativeSupport());
                }
                if (adjustLen && !hellinger) {
                    distance = pattern1.calculateTotalVariationDistance2(pattern2) * (1.0 - pattern1.getRelativeSupport() * pattern2.getRelativeSupport());
                }
                if (!adjustLen && hellinger) {
                    distance = pattern1.calculateHellingerDistance(pattern2) * (1.0 - pattern1.getRelativeSupport() * pattern2.getRelativeSupport());
                }
                if (!adjustLen && !hellinger) {
                    distance = pattern1.calculateTotalVariationDistance(pattern2) * (1.0 - pattern1.getRelativeSupport() * pattern2.getRelativeSupport());
                }
                map.put(new PatternPair(pattern1, pattern2), distance);
            }
        }
        return map;
    }

    public TreeMap<Integer, CopyOnWriteArraySet<FrequentPattern>> getMapByLength() {
        TreeMap<Integer, CopyOnWriteArraySet<FrequentPattern>> map = new TreeMap<Integer, CopyOnWriteArraySet<FrequentPattern>>();
        for (FrequentPattern aFrequentPattern : this.frequentPatterns) {
            int patternLength = aFrequentPattern.getDistributions().size();
            if (map.containsKey(patternLength)) {
                map.get(patternLength).add(aFrequentPattern);
                continue;
            }
            CopyOnWriteArraySet<FrequentPattern> newSet = new CopyOnWriteArraySet<FrequentPattern>();
            newSet.add(aFrequentPattern);
            map.put(patternLength, newSet);
        }
        return map;
    }

    public String toString() {
        String aString = "";
        for (FrequentPattern aFrequentPattern : this.frequentPatterns) {
            aString = String.valueOf(aString) + aFrequentPattern.toString();
        }
        return aString;
    }

    public double functionF() {
        double sumOfSupports = 0.0;
        for (FrequentPattern aFrequentPattern : this.frequentPatterns) {
            sumOfSupports += Math.pow(aFrequentPattern.getDistributions().size(), 2.0) * aFrequentPattern.getRelativeSupport();
        }
        return sumOfSupports;
    }

    public void mergeLSsimilarPatterns() {
        LinkedList<FrequentPattern> patternsAfterMerging = new LinkedList<FrequentPattern>();
        SimpleWeightedGraph<FrequentPattern, DefaultWeightedEdge> patternsGraph = new SimpleWeightedGraph<FrequentPattern, DefaultWeightedEdge>(DefaultWeightedEdge.class);
        for (FrequentPattern aVertex : this.frequentPatterns) {
            patternsGraph.addVertex(aVertex);
        }
        for (FrequentPattern aVertex : this.frequentPatterns) {
            for (FrequentPattern anotherVertex : this.frequentPatterns) {
                DefaultWeightedEdge anEdge;
                if (aVertex == anotherVertex || !aVertex.isLSsimilar(anotherVertex) || (anEdge = (DefaultWeightedEdge)patternsGraph.addEdge(aVertex, anotherVertex)) == null) continue;
                patternsGraph.setEdgeWeight(anEdge, aVertex.calculateDistance(anotherVertex));
            }
        }
        do {
            BronKerboschCliqueFinder aCliqueFinder = new BronKerboschCliqueFinder(patternsGraph);
            Collection allMaximumCliques = aCliqueFinder.getBiggestMaximalCliques();
            Set optimalMaximumClique = null;
            double minimumTwiceSumOfEdgeWeights = Double.MAX_VALUE;
            if (allMaximumCliques.size() > 1) {
                for (Set aMaximumClique : allMaximumCliques) {
                    double twiceSumOfEdgeWeights = 0.0;
                    for (FrequentPattern vertex1 : aMaximumClique) {
                        for (FrequentPattern vertex2 : aMaximumClique) {
                            if (vertex1 == vertex2) continue;
                            twiceSumOfEdgeWeights += patternsGraph.getEdgeWeight((DefaultWeightedEdge)patternsGraph.getEdge(vertex1, vertex2));
                        }
                    }
                    if (!(twiceSumOfEdgeWeights < minimumTwiceSumOfEdgeWeights)) continue;
                    optimalMaximumClique = aMaximumClique;
                    minimumTwiceSumOfEdgeWeights = twiceSumOfEdgeWeights;
                }
            } else {
                optimalMaximumClique = allMaximumCliques.iterator().next();
            }
            FrequentPattern newPattern = null;
            boolean firstTime = true;
            for (FrequentPattern aPattern : optimalMaximumClique) {
                if (firstTime) {
                    newPattern = aPattern;
                    firstTime = false;
                    continue;
                }
                newPattern = newPattern.merge(aPattern);
            }
            patternsAfterMerging.add(newPattern);
            patternsGraph.removeAllVertices(optimalMaximumClique);
        } while (patternsGraph.vertexSet().size() != 0);
        this.frequentPatterns = patternsAfterMerging;
    }
}

