/*
 * Decompiled with CFR 0.152.
 */
package lu.uni.minus.utils.hausdorff;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.CopyOnWriteArraySet;
import lu.uni.minus.utils.hausdorff.Distribution;
import lu.uni.minus.utils.hausdorff.FrequentPattern;
import lu.uni.minus.utils.hausdorff.FrequentPatternSet;
import lu.uni.minus.utils.hausdorff.UserCombination;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UserComparisonHausdorff {
    private static double calculateSimilarity(File file1, File file2, HashMap<String, Distribution> mapFromRegionToDistribution, boolean adjustLen, boolean hellinger) {
        FrequentPatternSet user1 = UserComparisonHausdorff.readPatternSetFile(file1, mapFromRegionToDistribution);
        FrequentPatternSet user2 = UserComparisonHausdorff.readPatternSetFile(file2, mapFromRegionToDistribution);
        CopyOnWriteArraySet<FrequentPattern> set1 = new CopyOnWriteArraySet<FrequentPattern>(user1.getFrequentPatterns());
        CopyOnWriteArraySet<FrequentPattern> set2 = new CopyOnWriteArraySet<FrequentPattern>(user2.getFrequentPatterns());
        if (adjustLen) {
            return 1.0 - user1.calculateHausdorffDistance(set1, set2, adjustLen, hellinger);
        }
        return user1.calculateSimilarity(user2, adjustLen, hellinger);
    }

    public static double[][] compareUsers(String outputPathnameOfDataset, String pathnameOfDistributionFile, List<String> selectedUsers, boolean adjustLen, boolean hellinger, String dirsPath) {
        HashMap<String, Distribution> mapFromRegionToDistribution = UserComparisonHausdorff.readDistributionFile(pathnameOfDistributionFile);
        CopyOnWriteArraySet<UserCombination> filesProcessed = new CopyOnWriteArraySet<UserCombination>();
        File[] allFiles = new File[selectedUsers.size()];
        int i = 0;
        while (i < selectedUsers.size()) {
            allFiles[i] = new File(String.valueOf(outputPathnameOfDataset) + "/PatternSets/" + dirsPath + "/" + selectedUsers.get(i) + "MiSTA.output");
            ++i;
        }
        File[] fileArray = allFiles;
        int n = allFiles.length;
        int n2 = 0;
        while (n2 < n) {
            File aFile = fileArray[n2];
            File[] fileArray2 = allFiles;
            int n3 = allFiles.length;
            int n4 = 0;
            while (n4 < n3) {
                File anotherFile = fileArray2[n4];
                UserCombination aUserCombination = new UserCombination(aFile, anotherFile);
                if (!filesProcessed.contains(aUserCombination)) {
                    aUserCombination.Similarity = UserComparisonHausdorff.calculateSimilarity(aFile, anotherFile, mapFromRegionToDistribution, adjustLen, hellinger);
                    filesProcessed.add(aUserCombination);
                }
                ++n4;
            }
            ++n2;
        }
        HashSet<String> allUsers = new HashSet<String>();
        for (UserCombination aUserCombination : filesProcessed) {
            allUsers.add(aUserCombination.User1);
            allUsers.add(aUserCombination.User2);
        }
        ArrayList allUsersForSorting = new ArrayList(allUsers);
        Collections.sort(allUsersForSorting);
        int numberOfUsers = allUsers.size();
        double[][] similarities = new double[numberOfUsers][numberOfUsers];
        for (UserCombination aUserCombination : filesProcessed) {
            int index1 = allUsersForSorting.indexOf(aUserCombination.User1);
            int index2 = allUsersForSorting.indexOf(aUserCombination.User2);
            similarities[index1][index2] = aUserCombination.Similarity;
            similarities[index2][index1] = aUserCombination.Similarity;
        }
        StringBuilder aStringBuilder = new StringBuilder(",");
        for (String aUser : allUsersForSorting) {
            aStringBuilder.append(aUser);
            aStringBuilder.append(",");
        }
        aStringBuilder.append("\n");
        int rowIndex = 0;
        while (rowIndex < numberOfUsers) {
            aStringBuilder.append((String)allUsersForSorting.get(rowIndex));
            aStringBuilder.append(",");
            int columnIndex = 0;
            while (columnIndex < numberOfUsers) {
                aStringBuilder.append(similarities[rowIndex][columnIndex]);
                aStringBuilder.append(",");
                ++columnIndex;
            }
            aStringBuilder.append("\n");
            ++rowIndex;
        }
        StringBuilder sb = new StringBuilder();
        int numberUsers = selectedUsers.size();
        int i2 = 0;
        while (i2 < numberUsers) {
            if (i2 != numberUsers - 1) {
                sb.append(String.valueOf(selectedUsers.get(i2)) + "_");
            } else {
                sb.append(selectedUsers.get(i2));
            }
            ++i2;
        }
        File outputDir = new File(String.valueOf(outputPathnameOfDataset) + "/ComparisonResults/" + dirsPath + "/" + sb.toString());
        if (!outputDir.exists()) {
            outputDir.mkdirs();
        }
        try {
            String filename = null;
            if (adjustLen && hellinger) {
                filename = outputDir + "/HausdorffAdjustLenHellinger.csv";
            }
            if (adjustLen && !hellinger) {
                filename = outputDir + "/HausdorffAdjustLenTV.csv";
            }
            if (!adjustLen && hellinger) {
                filename = outputDir + "/HausdorffClassifyByLenHellinger.csv";
            }
            if (!adjustLen && !hellinger) {
                filename = outputDir + "/HausdorffClassifyByLenTV.csv";
            }
            BufferedWriter bufferedWriter = new BufferedWriter(new FileWriter(filename));
            bufferedWriter.write(aStringBuilder.toString());
            bufferedWriter.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return similarities;
    }

    private static FrequentPatternSet readPatternSetFile(File aFile, HashMap<String, Distribution> mapFromRegionToDistribution) {
        LinkedList<FrequentPattern> frequentPatterns = new LinkedList<FrequentPattern>();
        try {
            BufferedReader bufferedReader = new BufferedReader(new FileReader(aFile));
            String aLine = null;
            while ((aLine = bufferedReader.readLine()) != null) {
                if (!aLine.contains(":")) continue;
                frequentPatterns.add(UserComparisonHausdorff.readRoISequence(aLine, mapFromRegionToDistribution));
            }
            bufferedReader.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return new FrequentPatternSet(frequentPatterns);
    }

    private static FrequentPattern readRoISequence(String aLine, HashMap<String, Distribution> mapFromRegionToDistribution) throws Exception {
        String[] twoParts = aLine.split(":");
        String[] RoIIDsWithParentheses = twoParts[0].split("\t");
        LinkedList<Distribution> distributions = new LinkedList<Distribution>();
        String[] stringArray = RoIIDsWithParentheses;
        int n = RoIIDsWithParentheses.length;
        int n2 = 0;
        while (n2 < n) {
            String anRoIID = stringArray[n2];
            if (!anRoIID.trim().isEmpty()) {
                Distribution distributionOfTheRoI = mapFromRegionToDistribution.get(anRoIID.substring(1, anRoIID.length() - 1));
                distributions.add(distributionOfTheRoI);
            }
            ++n2;
        }
        String[] supports = twoParts[1].split("\t");
        double relativeSupport = Double.parseDouble(supports[0].trim());
        int absoluteSupport = 0;
        return new FrequentPattern(distributions, relativeSupport, absoluteSupport);
    }

    private static HashMap<String, Distribution> readDistributionFile(String pathnameOfDistributionFile) {
        HashMap<String, Distribution> mapFromRegionToDistribution = new HashMap<String, Distribution>();
        try {
            BufferedReader bufferedReader = new BufferedReader(new FileReader(pathnameOfDistributionFile));
            String aLine = null;
            while ((aLine = bufferedReader.readLine()) != null) {
                String[] fields = aLine.split("\t");
                double[] probabilities = new double[10];
                int i = 0;
                while (i < 9) {
                    probabilities[i] = Double.parseDouble(fields[i + 1]);
                    ++i;
                }
                mapFromRegionToDistribution.put(fields[0].trim(), new Distribution(probabilities));
            }
            bufferedReader.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return mapFromRegionToDistribution;
    }
}

