/*
 * Decompiled with CFR 0.152.
 */
package lu.uni.minus.utils.lcs;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CommonFileOperations {
    public static void createFolderIfNotExisting(File folder) {
        if (!folder.exists()) {
            folder.mkdirs();
        }
    }

    public static void createFolderIfNotExisting(String foldername) {
        File folder = new File(foldername);
        if (!folder.exists()) {
            folder.mkdirs();
        }
    }

    public static List<String> getTextFileAsLines(File textFileHandle) {
        ArrayList<String> lines = new ArrayList<String>();
        try {
            BufferedReader br = new BufferedReader(new FileReader(textFileHandle));
            String strLine = "";
            while ((strLine = br.readLine()) != null) {
                lines.add(strLine);
            }
            br.close();
        }
        catch (Exception e) {
            System.err.println("Error: " + e.getMessage());
            return lines;
        }
        return lines;
    }

    public static boolean writeToFile(String outputFolderName, String outputFileName, String content) {
        BufferedWriter bw = null;
        try {
            CommonFileOperations.createFolderIfNotExisting(outputFolderName);
            String fullOutputPath = String.valueOf(outputFolderName) + File.separatorChar + outputFileName;
            bw = new BufferedWriter(new FileWriter(fullOutputPath));
            bw.write(content);
            bw.close();
        }
        catch (IOException e) {
            e.printStackTrace();
            return false;
        }
        return true;
    }
}

