/*
 * Decompiled with CFR 0.152.
 */
package lu.uni.minus.utils.lcs;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LongestCommonSubsequence {
    public static int[][] computeSequenceTable(int[] inputSequenceA, int[] inputSequenceB) {
        int m = inputSequenceA.length + 1;
        int n = inputSequenceB.length + 1;
        int[][] sequenceTable = new int[m][n];
        int i = 0;
        while (i < m) {
            sequenceTable[i][0] = 0;
            ++i;
        }
        int j = 0;
        while (j < n) {
            sequenceTable[0][j] = 0;
            ++j;
        }
        i = 1;
        while (i < m) {
            int j2 = 1;
            while (j2 < n) {
                sequenceTable[i][j2] = inputSequenceA[i - 1] == inputSequenceB[j2 - 1] ? sequenceTable[i - 1][j2 - 1] + 1 : Math.max(sequenceTable[i][j2 - 1], sequenceTable[i - 1][j2]);
                ++j2;
            }
            ++i;
        }
        return sequenceTable;
    }

    public static HashSet<String> backtrackAll(int[][] C, int[] inputA, int[] inputB, int i, int j) {
        if (i == 0 || j == 0) {
            return new HashSet<String>();
        }
        if (inputA[i - 1] == inputB[j - 1]) {
            HashSet<String> R = LongestCommonSubsequence.backtrackAll(C, inputA, inputB, i - 1, j - 1);
            HashSet<String> new_set = new HashSet<String>();
            for (String Z : R) {
                new_set.add(String.valueOf(Z) + inputA[i - 1]);
            }
            new_set.add("" + inputA[i - 1]);
            return new_set;
        }
        HashSet<String> R = new HashSet();
        if (C[i][j - 1] >= C[i - 1][j]) {
            R = LongestCommonSubsequence.backtrackAll(C, inputA, inputB, i, j - 1);
        }
        if (C[i - 1][j] >= C[i][j - 1]) {
            R.addAll(LongestCommonSubsequence.backtrackAll(C, inputA, inputB, i - 1, j));
        }
        return R;
    }

    public static List<Integer> backtrack(int[][] C, int[] inputA, int[] inputB, int i, int j) {
        if (i == 0 || j == 0) {
            return new ArrayList<Integer>();
        }
        if (inputA[i - 1] == inputB[j - 1]) {
            List<Integer> R = LongestCommonSubsequence.backtrack(C, inputA, inputB, i - 1, j - 1);
            R.add(inputA[i - 1]);
            return R;
        }
        if (C[i][j - 1] > C[i - 1][j]) {
            return LongestCommonSubsequence.backtrack(C, inputA, inputB, i, j - 1);
        }
        return LongestCommonSubsequence.backtrack(C, inputA, inputB, i - 1, j);
    }

    public void printoutSequenceMatrix(int[][] sequenceTable) {
        int i = 0;
        while (i < sequenceTable.length) {
            System.out.println(Arrays.toString(sequenceTable[i]));
            ++i;
        }
    }
}

