/*
 * Decompiled with CFR 0.152.
 */
package lu.uni.minus.utils.lcs;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.CopyOnWriteArraySet;
import lu.uni.minus.utils.lcs.CommonFileOperations;
import lu.uni.minus.utils.lcs.LongestCommonSubsequence;
import lu.uni.minus.utils.lcs.LongestCommonSubsequenceForCells;
import lu.uni.minus.utils.lcs.SequenceData;
import lu.uni.minus.utils.lcs.TimeRange;
import lu.uni.minus.utils.lcs.User;
import lu.uni.minus.utils.lcs.UserCombination;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UserComparisonLCS {
    /*
     * WARNING - void declaration
     */
    public double[][] compareUsers(String outputPathnameOfDataset, String pathnameOfDistributionFile, List<String> selectedUsers, boolean time, boolean semantics, double threshold, String dirsPath, boolean improved) throws Exception {
        void var20_61;
        HashMap<String, double[]> distributionOfRegions;
        Object aUserCombination;
        String outputFileName = null;
        CopyOnWriteArraySet<Object> filesProcessed = new CopyOnWriteArraySet<Object>();
        CopyOnWriteArraySet<Object> userCombinations = new CopyOnWriteArraySet<Object>();
        File[] files = new File[selectedUsers.size()];
        int i = 0;
        while (i < selectedUsers.size()) {
            files[i] = new File(String.valueOf(outputPathnameOfDataset) + "/PatternSets/" + dirsPath + "/" + selectedUsers.get(i) + "MiSTA.output");
            ++i;
        }
        ArrayList<User> users = new ArrayList<User>();
        File[] fileArray = files;
        int n = files.length;
        int n2 = 0;
        while (n2 < n) {
            File aFile = fileArray[n2];
            List<String> lines = CommonFileOperations.getTextFileAsLines(aFile);
            List<SequenceData> list2 = this.extractSequences(lines);
            list2 = this.purgeSequences(list2);
            users.add(this.fillUserDataFromSequenceDataList(list2, aFile.getName()));
            ++n2;
        }
        if (improved) {
            if (!time && !semantics) {
                for (User userU : users) {
                    for (User user : users) {
                        aUserCombination = new UserCombination(userU, user);
                        if (filesProcessed.contains(aUserCombination)) continue;
                        filesProcessed.add(aUserCombination);
                        userCombinations.add(aUserCombination);
                        ((UserCombination)aUserCombination).Similarity = LongestCommonSubsequenceForCells.calculateSimularityBetweenTwoUsersVersion5(userU, user);
                    }
                }
                outputFileName = "LCSImprovedWithoutSemanticsOrTime.csv";
            }
            if (time && !semantics) {
                for (User userU : users) {
                    for (User user : users) {
                        UserCombination aUserCombination2 = new UserCombination(userU, user);
                        if (filesProcessed.contains(aUserCombination2)) continue;
                        filesProcessed.add(aUserCombination2);
                        userCombinations.add(aUserCombination2);
                        aUserCombination2.Similarity = LongestCommonSubsequenceForCells.calculateSimularityBetweenTwoUsersVersion3(userU, user);
                    }
                }
                outputFileName = "LCSImprovedWithoutSemanticsWithTime.csv";
            }
            if (!time && semantics) {
                distributionOfRegions = this.readDistributionOfRegions(pathnameOfDistributionFile);
                for (User userU : users) {
                    for (User user : users) {
                        UserCombination userCombination = new UserCombination(userU, user);
                        if (filesProcessed.contains(userCombination)) continue;
                        filesProcessed.add(userCombination);
                        userCombinations.add(userCombination);
                        userCombination.Similarity = LongestCommonSubsequenceForCells.userSimilarityWithLocationSemantics(userU, user, threshold, distributionOfRegions);
                    }
                }
                String s = pathnameOfDistributionFile;
                outputFileName = "LCSImprovedWithSemanticsWithoutTime_" + threshold + "_" + s.substring(s.lastIndexOf("_"), s.lastIndexOf(".")) + ".csv";
            }
        } else {
            if (!time && !semantics) {
                for (User userU : users) {
                    for (User user : users) {
                        aUserCombination = new UserCombination(userU, user);
                        if (filesProcessed.contains(aUserCombination)) continue;
                        filesProcessed.add(aUserCombination);
                        userCombinations.add(aUserCombination);
                        ((UserCombination)aUserCombination).Similarity = LongestCommonSubsequenceForCells.calculateSimularityBetweenTwoUsersVersion2(userU, user);
                    }
                }
                outputFileName = "LCSWithoutSemanticsOrTime.csv";
            }
            if (time && !semantics) {
                for (User userU : users) {
                    for (User user : users) {
                        aUserCombination = new UserCombination(userU, user);
                        if (filesProcessed.contains(aUserCombination)) continue;
                        filesProcessed.add(aUserCombination);
                        userCombinations.add(aUserCombination);
                        ((UserCombination)aUserCombination).Similarity = LongestCommonSubsequenceForCells.calculateSimularityBetweenTwoUsersVersion1(userU, user);
                    }
                }
                outputFileName = "LCSWithoutSemanticsWithTime.csv";
            }
            if (!time && semantics) {
                distributionOfRegions = this.readDistributionOfRegions2(pathnameOfDistributionFile, threshold);
                for (User userU : users) {
                    for (User user : users) {
                        UserCombination userCombination = new UserCombination(userU, user);
                        if (filesProcessed.contains(userCombination)) continue;
                        filesProcessed.add(userCombination);
                        userCombinations.add(userCombination);
                        userCombination.Similarity = LongestCommonSubsequenceForCells.calculateSimularityBetweenTwoUsersVersion5Ying(userU, user, distributionOfRegions);
                    }
                }
                outputFileName = "LCSWithSemanticsWithoutTime_" + threshold + ".csv";
            }
        }
        StringBuilder sb = new StringBuilder(",");
        HashSet<String> printedUsers = new HashSet<String>();
        for (UserCombination userCombination : userCombinations) {
            printedUsers.add(userCombination.User1);
            printedUsers.add(userCombination.User2);
        }
        ArrayList arrayList = new ArrayList(printedUsers);
        Collections.sort(arrayList);
        for (String string : arrayList) {
            sb.append(string);
            sb.append(",");
        }
        int n3 = printedUsers.size();
        double[][] similarityMatrix = new double[n3][n3];
        boolean bl = false;
        while (var20_61 < n3) {
            int y = 0;
            while (y < n3) {
                similarityMatrix[var20_61][y] = 0.0;
                ++y;
            }
            ++var20_61;
        }
        for (UserCombination userCombination : userCombinations) {
            int xIndex = arrayList.indexOf(userCombination.User1);
            int yIndex = arrayList.indexOf(userCombination.User2);
            similarityMatrix[xIndex][yIndex] = userCombination.Similarity;
            similarityMatrix[yIndex][xIndex] = userCombination.Similarity;
        }
        boolean bl2 = false;
        int x2 = 0;
        while (x2 < n3) {
            void var20_64;
            sb.append("\n");
            sb.append((String)arrayList.get((int)(++var20_64)));
            sb.append(",");
            int y = 0;
            while (y < n3) {
                sb.append(similarityMatrix[x2][y]);
                sb.append(",");
                ++y;
            }
            ++x2;
        }
        StringBuilder sb2 = new StringBuilder();
        int numberUsers = selectedUsers.size();
        int i2 = 0;
        while (i2 < numberUsers) {
            if (i2 != numberUsers - 1) {
                sb2.append(String.valueOf(selectedUsers.get(i2)) + "_");
            } else {
                sb2.append(selectedUsers.get(i2));
            }
            ++i2;
        }
        CommonFileOperations.writeToFile(String.valueOf(outputPathnameOfDataset) + "/ComparisonResults/" + dirsPath + "/" + sb2.toString(), outputFileName, sb.toString());
        return similarityMatrix;
    }

    private HashMap<String, double[]> readDistributionOfRegions(String file) {
        HashMap<String, double[]> distributionOfRegions = new HashMap<String, double[]>();
        try {
            BufferedReader br = new BufferedReader(new FileReader(new File(file)));
            String strLine = null;
            while ((strLine = br.readLine()) != null) {
                String[] f = strLine.split("\t");
                double[] dis = new double[f.length - 1];
                int i = 1;
                while (i < f.length) {
                    dis[i - 1] = Double.parseDouble(f[i]);
                    ++i;
                }
                distributionOfRegions.put(f[0], dis);
            }
            br.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return distributionOfRegions;
    }

    private HashMap<String, double[]> readDistributionOfRegions2(String file, double threshold) {
        HashMap<String, double[]> distributionOfRegions = new HashMap<String, double[]>();
        try {
            BufferedReader br = new BufferedReader(new FileReader(new File(file)));
            String strLine = null;
            while ((strLine = br.readLine()) != null) {
                String[] f = strLine.split("\t");
                double[] dis = new double[f.length - 1];
                int i = 1;
                while (i < f.length) {
                    dis[i - 1] = Double.parseDouble(f[i]);
                    if (dis[i - 1] <= threshold) {
                        dis[i - 1] = 0.0;
                    }
                    ++i;
                }
                distributionOfRegions.put(f[0], dis);
            }
            br.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return distributionOfRegions;
    }

    private List<SequenceData> extractSequences(List<String> lines) {
        ArrayList<SequenceData> sequences = new ArrayList<SequenceData>();
        SequenceData sequence = null;
        for (String line : lines) {
            if (line.contains(":")) {
                sequence = this.parseSequenceData(line);
                sequences.add(sequence);
                continue;
            }
            if (line.trim().startsWith("[")) {
                if (sequence == null) continue;
                int indexOfOpeningBracket = line.indexOf("[");
                int timeRangeIndex = 0;
                while (indexOfOpeningBracket > -1) {
                    int indexOfClosingBracket = line.indexOf("]", indexOfOpeningBracket);
                    if (indexOfClosingBracket == -1) {
                        System.err.println(String.valueOf(line.substring(indexOfOpeningBracket)) + " no closing bracket was found");
                        return null;
                    }
                    String[] timeRangeElements = line.substring(indexOfOpeningBracket, indexOfClosingBracket).split(",");
                    int startTime = Integer.parseInt(timeRangeElements[0].substring(1).trim());
                    int endTime = Integer.parseInt(timeRangeElements[1].trim());
                    if (sequence.getTimeRange().size() <= timeRangeIndex) {
                        sequence.getTimeRange().add(new TimeRange(startTime, endTime));
                    }
                    if (sequence.getTimeRange().get(timeRangeIndex).getStartTime() > startTime) {
                        sequence.getTimeRange().get(timeRangeIndex).setStartTime(startTime);
                    }
                    if (sequence.getTimeRange().get(timeRangeIndex).getEndTime() < endTime) {
                        sequence.getTimeRange().get(timeRangeIndex).setEndTime(endTime);
                    }
                    indexOfOpeningBracket = line.indexOf("[", indexOfClosingBracket);
                    ++timeRangeIndex;
                }
                continue;
            }
            System.err.println(String.valueOf(line) + " is malformed");
            System.exit(1);
        }
        return sequences;
    }

    private SequenceData parseSequenceData(String lineWithSequenceData) {
        String[] sequenceElementStrings;
        int indexOfFirstColon = lineWithSequenceData.indexOf(":");
        String stringWithSequencElementsInParentheses = lineWithSequenceData.substring(0, indexOfFirstColon);
        ArrayList<Integer> sequenceElements = new ArrayList<Integer>();
        String[] stringArray = sequenceElementStrings = stringWithSequencElementsInParentheses.split("\t");
        int n = sequenceElementStrings.length;
        int n2 = 0;
        while (n2 < n) {
            String elementID = stringArray[n2];
            if (!elementID.trim().isEmpty()) {
                int id = Integer.parseInt(elementID.substring(1, elementID.length() - 1));
                sequenceElements.add(id);
            }
            ++n2;
        }
        String StringWithSupporValues = lineWithSequenceData.substring(indexOfFirstColon + 1);
        String[] supports = StringWithSupporValues.split("\t\t");
        double relativeSupport = Double.parseDouble(supports[0].trim());
        int absoluteSupport = Integer.parseInt(supports[1].substring(5, supports[1].length() - 1));
        int[] sequenceIDs = new int[sequenceElements.size()];
        int i = 0;
        for (Integer e : sequenceElements) {
            sequenceIDs[i++] = e;
        }
        SequenceData sequence = new SequenceData(sequenceIDs, relativeSupport, absoluteSupport);
        return sequence;
    }

    private List<SequenceData> purgeSequences(List<SequenceData> sequences) {
        Collections.sort(sequences, new Comparator<SequenceData>(){

            @Override
            public int compare(SequenceData o1, SequenceData o2) {
                return new Integer(o1.getSequence().length).compareTo(o2.getSequence().length);
            }
        });
        int maxSequenceLength = sequences.get(sequences.size() - 1).getSequence().length;
        ArrayList<SequenceData> toBeDeletedSequences = new ArrayList<SequenceData>();
        int index = 0;
        while (index < sequences.size()) {
            int innerIndex = index + 1;
            while (innerIndex < sequences.size()) {
                if (sequences.get(index).getSequence().length != sequences.get(innerIndex).getSequence().length) {
                    if (sequences.get(index).getSequence().length == maxSequenceLength) break;
                    int[][] lcsTable = LongestCommonSubsequence.computeSequenceTable(sequences.get(index).getSequence(), sequences.get(innerIndex).getSequence());
                    List<Integer> lcs = LongestCommonSubsequence.backtrack(lcsTable, sequences.get(index).getSequence(), sequences.get(innerIndex).getSequence(), sequences.get(index).getSequence().length, sequences.get(innerIndex).getSequence().length);
                    int[] arLCS = new int[lcs.size()];
                    int i = 0;
                    for (Integer e : lcs) {
                        arLCS[i++] = e;
                    }
                    if (Arrays.equals(arLCS, sequences.get(index).getSequence())) {
                        toBeDeletedSequences.add(sequences.get(index));
                        break;
                    }
                }
                ++innerIndex;
            }
            ++index;
        }
        sequences.removeAll(toBeDeletedSequences);
        return sequences;
    }

    private User fillUserDataFromSequenceDataList(List<SequenceData> sequences, String fileName) {
        User user = new User();
        user.ID = fileName.substring(0, 3);
        ArrayList<int[]> inputSequences = new ArrayList<int[]>();
        ArrayList<TimeRange[]> inputSequenceTransitionTimes = new ArrayList<TimeRange[]>();
        ArrayList<Double> supportValuesForInputSequences = new ArrayList<Double>();
        for (SequenceData data : sequences) {
            inputSequences.add(data.getSequence());
            TimeRange[] timeRanges = new TimeRange[data.getSequence().length];
            timeRanges = data.getTimeRange().toArray(timeRanges);
            inputSequenceTransitionTimes.add(timeRanges);
            supportValuesForInputSequences.add(data.getRelativeSupport());
        }
        user.inputSequences = inputSequences;
        user.inputSequenceTransitionTimes = inputSequenceTransitionTimes;
        user.supportValuesForInputSequences = supportValuesForInputSequences;
        return user;
    }
}

