/*
 * Decompiled with CFR 0.152.
 */
package lu.uni.minus.utils.roi;

import java.util.HashSet;
import java.util.Set;
import lu.uni.minus.utils.roi.DataPoint;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Cluster {
    public int id;
    public Set<DataPoint> clusterPoints = new HashSet<DataPoint>();
    private DataPoint centroid = null;

    public Cluster(int id) {
        this.id = id;
    }

    public Cluster(int id, DataPoint dataPoint) {
        this.id = id;
        this.clusterPoints.add(dataPoint);
        this.centroid = dataPoint;
    }

    public void addPoint(DataPoint point) {
        this.clusterPoints.add(point);
        this.centroid = Cluster.calcCentroidforCluster(this.clusterPoints);
    }

    public void addPoints(Cluster otherCluster) {
        this.clusterPoints.addAll(otherCluster.clusterPoints);
        this.centroid = Cluster.calcCentroidforCluster(this.clusterPoints);
    }

    public static DataPoint calcCentroidforCluster(Set<DataPoint> cluster) {
        double SummedLongs = 0.0;
        double SummedLats = 0.0;
        if (cluster.size() == 1) {
            return cluster.iterator().next();
        }
        for (DataPoint dataPoint : cluster) {
            SummedLats += dataPoint.getLatitude();
            SummedLongs += dataPoint.getLongitude();
        }
        double centroidLat = SummedLats / (double)cluster.size();
        double centroidLong = SummedLongs / (double)cluster.size();
        return new DataPoint(centroidLat, centroidLong);
    }

    public DataPoint getCentroid() {
        return this.centroid;
    }

    public DataPoint getMinPoint() {
        Double minLat = Double.MAX_VALUE;
        Double minLong = Double.MAX_VALUE;
        for (DataPoint pt : this.clusterPoints) {
            if (minLat >= pt.getLatitude()) {
                minLat = pt.getLatitude();
            }
            if (!(minLong >= pt.getLongitude())) continue;
            minLong = pt.getLongitude();
        }
        return new DataPoint(minLat, minLong);
    }

    public DataPoint getMaxPoint() {
        Double maxLat = Double.MIN_VALUE;
        Double maxLong = Double.MIN_VALUE;
        for (DataPoint pt : this.clusterPoints) {
            if (maxLat <= pt.getLatitude()) {
                maxLat = pt.getLatitude();
            }
            if (!(maxLong <= pt.getLongitude())) continue;
            maxLong = pt.getLongitude();
        }
        return new DataPoint(maxLat, maxLong);
    }

    public String toString() {
        return " #" + this.clusterPoints.size() + " points center:" + this.centroid;
    }
}

