/*
 * Decompiled with CFR 0.152.
 */
package lu.uni.minus.utils.roi;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Vector;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import lu.uni.minus.utils.TextPaneWorker;
import weka.classifiers.rules.DecisionTableHashKey;
import weka.core.AbstractInstance;
import weka.core.Attribute;
import weka.core.Capabilities;
import weka.core.DenseInstance;
import weka.core.Environment;
import weka.core.EnvironmentHandler;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.Option;
import weka.core.OptionHandler;
import weka.core.RevisionUtils;
import weka.core.SerializedObject;
import weka.core.SparseInstance;
import weka.core.TechnicalInformation;
import weka.core.TechnicalInformationHandler;
import weka.core.Utils;
import weka.core.WeightedInstancesHandler;
import weka.core.neighboursearch.LinearNNSearch;
import weka.core.neighboursearch.NearestNeighbourSearch;
import weka.filters.Filter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LOF
extends Filter
implements OptionHandler,
WeightedInstancesHandler,
TechnicalInformationHandler,
EnvironmentHandler {
    private static final long serialVersionUID = 3843951651734143371L;
    private final TextPaneWorker worker;
    protected String m_minPtsLB = "10";
    protected String m_minPtsUB = "40";
    protected NearestNeighbourSearch m_nnSearch;
    protected NearestNeighbourSearch m_nnTemplate = new LinearNNSearch();
    protected transient Environment m_env;
    protected int m_lbK = 10;
    protected int m_ubK = 40;
    protected boolean m_classSet = false;
    protected transient DecisionTableHashKey[] m_instKeys;
    protected Map<DecisionTableHashKey, Neighborhood> m_kDistanceContainer;
    protected transient ThreadPoolExecutor m_executorPool;
    protected String m_numSlots = "1";
    protected int m_numExecutionSlots = 1;
    protected int m_completed;
    protected int m_failed;

    public LOF(TextPaneWorker aWorker) {
        this.worker = aWorker;
    }

    public String globalInfo() {
        return "A filter that applies the LOF (Local Outlier Factor) algorithm to compute an \"outlier\" score for each instance in the data. Can use multiple cores/cpus to speed up the LOF computation for large datasets. Nearest neighbor search methods and distance functions are pluggable.\n\nFor more information, see:\n\n" + this.getTechnicalInformation().toString();
    }

    @Override
    public Capabilities getCapabilities() {
        Capabilities result = super.getCapabilities();
        result.disableAll();
        result.enable(Capabilities.Capability.NOMINAL_ATTRIBUTES);
        result.enable(Capabilities.Capability.NUMERIC_ATTRIBUTES);
        result.enable(Capabilities.Capability.DATE_ATTRIBUTES);
        result.enable(Capabilities.Capability.MISSING_VALUES);
        result.enable(Capabilities.Capability.NOMINAL_CLASS);
        result.enable(Capabilities.Capability.NUMERIC_CLASS);
        result.enable(Capabilities.Capability.DATE_CLASS);
        result.enable(Capabilities.Capability.MISSING_CLASS_VALUES);
        result.enable(Capabilities.Capability.NO_CLASS);
        result.setMinimumNumberInstances(0);
        return result;
    }

    @Override
    public TechnicalInformation getTechnicalInformation() {
        TechnicalInformation result = new TechnicalInformation(TechnicalInformation.Type.ARTICLE);
        result.setValue(TechnicalInformation.Field.AUTHOR, "Markus M. Breunig and Hans-Peter Kriegel and Raymond T. Ng and Jorg Sander");
        result.setValue(TechnicalInformation.Field.TITLE, "LOF: Identifying Density-Based Local Outliers");
        result.setValue(TechnicalInformation.Field.JOURNAL, "ACM SIGMOD Record");
        result.setValue(TechnicalInformation.Field.YEAR, "2000");
        result.setValue(TechnicalInformation.Field.VOLUME, "29");
        result.setValue(TechnicalInformation.Field.NUMBER, "2");
        result.setValue(TechnicalInformation.Field.PAGES, "93-104");
        result.setValue(TechnicalInformation.Field.PUBLISHER, "ACM New York");
        return result;
    }

    @Override
    public Enumeration<Option> listOptions() {
        Vector<Option> newVector = new Vector<Option>();
        newVector.add(new Option("\tLower bound on the k nearest neighbors for finding max LOF (minPtsLB)\n\t(default = 10)", "min", 1, "-min <num>"));
        newVector.add(new Option("\tUpper bound on the k nearest neighbors for finding max LOF (minPtsUB)\n\t(default = 40)", "max", 1, "-max <num>"));
        newVector.addElement(new Option("\tThe nearest neighbour search algorithm to use (default: weka.core.neighboursearch.LinearNNSearch).\n", "A", 0, "-A"));
        newVector.addElement(new Option("\tNumber of execution slots.\n\t(default 1 - i.e. no parallelism)", "num-slots", 1, "-num-slots <num>"));
        return newVector.elements();
    }

    @Override
    public void setOptions(String[] options) throws Exception {
        String nnSearchClass;
        String maxP;
        String minP = Utils.getOption("min", options);
        if (minP.length() > 0) {
            this.setMinPointsLowerBound(minP);
        }
        if ((maxP = Utils.getOption("max", options)).length() > 0) {
            this.setMinPointsUpperBound(maxP);
        }
        if ((nnSearchClass = Utils.getOption('A', options)).length() != 0) {
            String[] nnSearchClassSpec = Utils.splitOptions(nnSearchClass);
            if (nnSearchClassSpec.length == 0) {
                throw new Exception("Invalid NearestNeighbourSearch algorithm specification string.");
            }
            String className = nnSearchClassSpec[0];
            nnSearchClassSpec[0] = "";
            this.setNNSearch((NearestNeighbourSearch)Utils.forName(NearestNeighbourSearch.class, className, nnSearchClassSpec));
        } else {
            this.setNNSearch(new LinearNNSearch());
        }
        String slotsS = Utils.getOption("num-slots", options);
        if (slotsS.length() > 0) {
            this.setNumExecutionSlots(slotsS);
        }
        Utils.checkForRemainingOptions(options);
    }

    @Override
    public String[] getOptions() {
        String[] options = new String[8];
        int current = 0;
        options[current++] = "-min";
        options[current++] = this.getMinPointsLowerBound();
        options[current++] = "-max";
        options[current++] = this.getMinPointsUpperBound();
        options[current++] = "-A";
        options[current++] = String.valueOf(this.m_nnTemplate.getClass().getName()) + " " + Utils.joinOptions(this.m_nnTemplate.getOptions());
        options[current++] = "-num-slots";
        options[current++] = this.getNumExecutionSlots();
        return options;
    }

    public String minPointsLowerBoundTipText() {
        return "The lower bound (minPtsLB) to use on the range for k when determining the maximum LOF value";
    }

    public void setMinPointsLowerBound(String pts) {
        this.m_minPtsLB = pts;
    }

    public String getMinPointsLowerBound() {
        return this.m_minPtsLB;
    }

    public String minPointsUpperBoundTipText() {
        return "The upper bound (minPtsUB) to use on the range for k when determining the maximum LOF value";
    }

    public void setMinPointsUpperBound(String pts) {
        this.m_minPtsUB = pts;
    }

    public String getMinPointsUpperBound() {
        return this.m_minPtsUB;
    }

    public String NNSearchTipText() {
        return "The nearest neighbour search algorithm to use (Default: weka.core.neighboursearch.LinearNNSearch).";
    }

    public void setNNSearch(NearestNeighbourSearch s) {
        this.m_nnTemplate = s;
    }

    public NearestNeighbourSearch getNNSearch() {
        return this.m_nnTemplate;
    }

    public String numExecutionSlotsTipText() {
        return "The number of execution slots (threads) to use for finding LOF values.";
    }

    public void setNumExecutionSlots(String slots) {
        this.m_numSlots = slots;
    }

    public String getNumExecutionSlots() {
        return this.m_numSlots;
    }

    @Override
    public boolean setInputFormat(Instances instanceInfo) throws Exception {
        super.setInputFormat(instanceInfo);
        this.m_nnSearch = null;
        return false;
    }

    @Override
    public boolean input(Instance instance) {
        if (this.getInputFormat() == null) {
            throw new IllegalStateException("No input instance format defined");
        }
        if (this.m_NewBatch) {
            this.resetQueue();
            this.m_NewBatch = false;
        }
        if (this.m_nnSearch != null) {
            try {
                this.postFirstBatch(instance);
            }
            catch (Exception ex) {
                this.worker.addException(ex);
                throw new IllegalStateException(ex.getMessage());
            }
            return true;
        }
        this.bufferInput(instance);
        return false;
    }

    @Override
    public boolean batchFinished() {
        if (this.getInputFormat() == null) {
            throw new IllegalStateException("No input instance format defined");
        }
        if (this.m_env == null) {
            this.m_env = Environment.getSystemWide();
        }
        if (this.m_nnSearch == null) {
            this.setOutputFormat();
            if (this.m_numSlots != null && this.m_numSlots.length() > 0) {
                String nS = this.m_numSlots;
                try {
                    nS = this.m_env.substitute(nS);
                    this.m_numExecutionSlots = Integer.parseInt(nS);
                    if (this.m_numExecutionSlots < 1) {
                        this.m_numExecutionSlots = 1;
                    }
                }
                catch (Exception ex) {
                    this.worker.addException(ex);
                    throw new IllegalStateException(ex.getMessage());
                }
            }
            try {
                if (this.m_numExecutionSlots < 2) {
                    this.LOFFirstBatch();
                } else {
                    this.LOFFirstBatchParallel();
                }
            }
            catch (Exception ex) {
                this.worker.addException(ex);
                throw new IllegalStateException(ex.getMessage());
            }
        }
        this.flushInput();
        this.m_NewBatch = true;
        return this.numPendingOutput() != 0;
    }

    protected void setOutputFormat() {
        ArrayList<Attribute> atts = new ArrayList<Attribute>();
        int i = 0;
        while (i < this.getInputFormat().numAttributes()) {
            atts.add((Attribute)this.getInputFormat().attribute(i).copy());
            ++i;
        }
        atts.add(new Attribute("LOF"));
        Instances outputFormat = new Instances(this.getInputFormat().relationName(), atts, 0);
        outputFormat.setClassIndex(this.getInputFormat().classIndex());
        this.setOutputFormat(outputFormat);
    }

    protected void postFirstBatch(Instance inst) throws Exception {
        Instances nn = this.m_nnSearch.kNearestNeighbours(inst, this.m_ubK * 2);
        Neighborhood currentN = new Neighborhood();
        currentN.m_neighbors = nn;
        currentN.m_distances = this.m_nnSearch.getDistances();
        currentN.m_tempCardinality = new double[this.m_ubK - this.m_lbK];
        currentN.m_lof = new double[this.m_ubK - this.m_lbK];
        currentN.m_lrd = new double[this.m_ubK - this.m_lbK];
        this.trimZeroDistances(currentN);
        int k = this.m_lbK;
        while (k < this.m_ubK) {
            int indexOfKDistanceForK = k - 1;
            while (indexOfKDistanceForK < currentN.m_distances.length - 1 && currentN.m_distances[indexOfKDistanceForK] == currentN.m_distances[indexOfKDistanceForK + 1]) {
                ++indexOfKDistanceForK;
            }
            double cardinality = 0.0;
            double sumReachability = 0.0;
            int j = 0;
            while (j <= indexOfKDistanceForK) {
                Instance b = currentN.m_neighbors.instance(j);
                cardinality += b.weight();
                sumReachability += this.reachability(inst, b, currentN.m_distances[j], k);
                ++j;
            }
            currentN.m_lrd[k - this.m_lbK] = cardinality / sumReachability;
            currentN.m_tempCardinality[k - this.m_lbK] = cardinality;
            double lofK = this.lof(currentN, k);
            if (lofK > currentN.m_lof[k - this.m_lbK]) {
                currentN.m_lof[k - this.m_lbK] = lofK;
            }
            ++k;
        }
        double maxLOF = currentN.m_lof[Utils.maxIndex(currentN.m_lof)];
        Instance newInst = this.makeOutputInstance(inst, maxLOF);
        this.push(newInst);
    }

    protected void init(Instances training) throws Exception {
        boolean bl = this.m_classSet = training.classIndex() >= 0;
        if (this.m_env == null) {
            this.m_env = Environment.getSystemWide();
        }
        String lbKS = this.m_minPtsLB;
        String ubKS = this.m_minPtsUB;
        try {
            lbKS = this.m_env.substitute(lbKS);
            this.m_lbK = Integer.parseInt(lbKS);
        }
        catch (Exception ex) {
            this.worker.addException(ex);
            throw new IllegalStateException(ex.getMessage());
        }
        try {
            ubKS = this.m_env.substitute(ubKS);
            this.m_ubK = Integer.parseInt(ubKS);
        }
        catch (Exception ex) {
            this.worker.addException(ex);
            throw new IllegalStateException(ex.getMessage());
        }
        if (this.m_ubK >= training.numInstances()) {
            System.err.println("Can't have more neighbors than data points.");
            this.m_ubK = training.numInstances() - 1;
        }
        if (this.m_ubK <= this.m_lbK) {
            System.err.println("Upper bound on k can't be <= lower bound - setting equal to the lower bound + 1");
            this.m_ubK = this.m_lbK + 1;
        }
        SerializedObject o = new SerializedObject(this.m_nnTemplate);
        this.m_nnSearch = (NearestNeighbourSearch)o.getObject();
        this.m_nnSearch.setInstances(new Instances(training));
        this.m_kDistanceContainer = this.m_numExecutionSlots > 1 ? new ConcurrentHashMap<DecisionTableHashKey, Neighborhood>() : new HashMap<DecisionTableHashKey, Neighborhood>();
        this.m_instKeys = new DecisionTableHashKey[training.numInstances()];
    }

    protected void LOFFirstBatchParallel() throws Exception {
        Instances training = this.getInputFormat();
        this.init(training);
        this.m_completed = 0;
        this.m_failed = 0;
        this.startExecutorPool();
        int numPerThread = training.numInstances() / this.m_numExecutionSlots;
        if (numPerThread < 1) {
            this.m_numExecutionSlots = training.numInstances();
            numPerThread = 1;
        }
        int start = 0;
        int end = 0;
        int i = 0;
        while (i < this.m_numExecutionSlots) {
            end = i == this.m_numExecutionSlots - 1 ? training.numInstances() : start + numPerThread;
            SerializedObject oo = new SerializedObject(this.m_nnTemplate);
            NearestNeighbourSearch s = (NearestNeighbourSearch)oo.getObject();
            s.setInstances(new Instances(training));
            NNFinder finder = new NNFinder(new Instances(training), start, end, s);
            this.m_executorPool.execute(finder);
            start += numPerThread;
            ++i;
        }
        if (this.m_completed + this.m_failed < this.m_numExecutionSlots) {
            this.block(true, this.m_numExecutionSlots);
        }
        if (this.m_failed > 0) {
            throw new Exception("Can't continue - some tasks failed during the nearest neighbour phase");
        }
        this.m_completed = 0;
        this.m_failed = 0;
        int numLOFFinders = this.m_ubK - this.m_lbK;
        int k = this.m_lbK;
        while (k < this.m_ubK) {
            LOFFinder finder = new LOFFinder(training, k);
            this.m_executorPool.execute(finder);
            ++k;
        }
        if (this.m_completed + this.m_failed < numLOFFinders) {
            this.block(true, numLOFFinders);
        }
        if (this.m_failed > 0) {
            throw new Exception("Can't continue - some tasks failed during the LOF phase");
        }
        this.m_executorPool.shutdown();
        int i2 = 0;
        while (i2 < training.numInstances()) {
            Instance current = training.instance(i2);
            Neighborhood currentN = this.m_kDistanceContainer.get(this.m_instKeys[i2]);
            double maxLOF = currentN.m_lof[Utils.maxIndex(currentN.m_lof)];
            Instance inst = this.makeOutputInstance(current, maxLOF);
            this.push(inst);
            ++i2;
        }
    }

    protected synchronized boolean addToKDistanceContainer(DecisionTableHashKey key, Neighborhood n) {
        if (!this.m_kDistanceContainer.containsKey(key)) {
            this.m_kDistanceContainer.put(key, n);
            return true;
        }
        return false;
    }

    protected synchronized void completedTask(String taskType, boolean success, int totalTasks) {
        if (!success) {
            System.err.println("A " + taskType + " task failed!");
            ++this.m_failed;
        } else {
            ++this.m_completed;
        }
        if (this.m_completed + this.m_failed == totalTasks) {
            if (this.m_failed > 0) {
                System.err.println("Problem executing " + taskType + " tasks - some iterations failed.");
            }
            this.block(false, totalTasks);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private synchronized void block(boolean tf, int totalTasks) {
        if (tf) {
            try {
                if (this.m_completed + this.m_failed >= totalTasks) return;
                this.wait();
                return;
            }
            catch (InterruptedException ex) {
                this.worker.addException(ex);
                throw new IllegalStateException(ex.getMessage());
            }
        } else {
            this.notifyAll();
        }
    }

    protected void startExecutorPool() {
        if (this.m_executorPool != null) {
            this.m_executorPool.shutdownNow();
        }
        this.m_executorPool = new ThreadPoolExecutor(this.m_numExecutionSlots, this.m_numExecutionSlots, 120L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>());
    }

    protected synchronized void trimZeroDistances(Neighborhood n) {
        int index = 0;
        int i = 0;
        while (i < n.m_neighbors.numInstances()) {
            if (n.m_distances[i] > 0.0) {
                index = i;
                break;
            }
            ++i;
        }
        if (index > 0) {
            i = 0;
            while (i < index) {
                n.m_neighbors.remove(0);
                ++i;
            }
            double[] newDist = new double[n.m_distances.length - index];
            System.arraycopy(n.m_distances, index, newDist, 0, newDist.length);
            n.m_distances = newDist;
        }
    }

    protected void LOFFirstBatch() throws Exception {
        Neighborhood currentN;
        Instance current;
        Instances training = this.getInputFormat();
        this.init(training);
        int done = 10;
        int i = 0;
        while (i < training.numInstances()) {
            current = training.get(i);
            DecisionTableHashKey key = new DecisionTableHashKey(current, current.numAttributes(), !this.m_classSet);
            if (!this.m_kDistanceContainer.containsKey(key)) {
                Instances nn = this.m_nnSearch.kNearestNeighbours(current, this.m_ubK * 2);
                Neighborhood n = new Neighborhood();
                n.m_neighbors = nn;
                n.m_distances = this.m_nnSearch.getDistances();
                n.m_tempCardinality = new double[this.m_ubK - this.m_lbK];
                n.m_lrd = new double[this.m_ubK - this.m_lbK];
                n.m_lof = new double[this.m_ubK - this.m_lbK];
                this.trimZeroDistances(n);
                this.m_kDistanceContainer.put(key, n);
            }
            this.m_instKeys[i] = key;
            if (this.worker.isCancelled()) {
                throw new Exception("Cancelled");
            }
            done = (int)(10.0 + (double)i / (double)training.numInstances() * 3.0);
            this.worker.setDone(done);
            ++i;
        }
        int k = this.m_lbK;
        while (k < this.m_ubK) {
            int i2 = 0;
            while (i2 < training.numInstances()) {
                Instance current2 = training.instance(i2);
                Neighborhood currentN2 = this.m_kDistanceContainer.get(this.m_instKeys[i2]);
                int indexOfKDistanceForK = k - 1;
                while (indexOfKDistanceForK < currentN2.m_distances.length - 1 && currentN2.m_distances[indexOfKDistanceForK] == currentN2.m_distances[indexOfKDistanceForK + 1]) {
                    ++indexOfKDistanceForK;
                }
                double cardinality = 0.0;
                double sumReachability = 0.0;
                int j = 0;
                while (j <= indexOfKDistanceForK) {
                    Instance b = currentN2.m_neighbors.instance(j);
                    cardinality += b.weight();
                    sumReachability += this.reachability(current2, b, currentN2.m_distances[j], k);
                    ++j;
                }
                currentN2.m_lrd[k - this.m_lbK] = cardinality / sumReachability;
                currentN2.m_tempCardinality[k - this.m_lbK] = cardinality;
                ++i2;
            }
            i2 = 0;
            while (i2 < training.numInstances()) {
                double lofK;
                currentN = this.m_kDistanceContainer.get(this.m_instKeys[i2]);
                currentN.m_lof[k - this.m_lbK] = lofK = this.lof(currentN, k);
                ++i2;
            }
            if (this.worker.isCancelled()) {
                throw new Exception("Cancelled");
            }
            done = (int)(13.0 + (double)(k - this.m_lbK) / (double)this.m_ubK * 14.0);
            this.worker.setDone(done);
            ++k;
        }
        i = 0;
        while (i < training.numInstances()) {
            current = training.instance(i);
            currentN = this.m_kDistanceContainer.get(this.m_instKeys[i]);
            double maxLOF = currentN.m_lof[Utils.maxIndex(currentN.m_lof)];
            Instance inst = this.makeOutputInstance(current, maxLOF);
            this.push(inst);
            if (this.worker.isCancelled()) {
                throw new Exception("Cancelled");
            }
            done = (int)(27.0 + (double)i / (double)training.numInstances() * 3.0);
            this.worker.setDone(done);
            ++i;
        }
        done = 30;
        this.worker.setDone(done);
    }

    protected Instance makeOutputInstance(Instance original, double lof) {
        int numAtts = this.getInputFormat().numAttributes() + 1;
        double[] vals = new double[numAtts];
        int j = 0;
        while (j < original.numAttributes()) {
            vals[j] = original.value(j);
            ++j;
        }
        vals[numAtts - 1] = lof;
        AbstractInstance inst = null;
        inst = original instanceof SparseInstance ? new SparseInstance(original.weight(), vals) : new DenseInstance(original.weight(), vals);
        inst.setDataset(this.getOutputFormat());
        this.copyValues(inst, false, original.dataset(), this.getOutputFormat());
        inst.setDataset(this.getOutputFormat());
        return inst;
    }

    protected double lof(Neighborhood neighborhoodA, int k) {
        double sumlrdb = 0.0;
        int indexOfKDistanceForK = k - 1;
        while (indexOfKDistanceForK < neighborhoodA.m_distances.length - 1 && neighborhoodA.m_distances[indexOfKDistanceForK] == neighborhoodA.m_distances[indexOfKDistanceForK + 1]) {
            ++indexOfKDistanceForK;
        }
        int i = 0;
        while (i <= indexOfKDistanceForK) {
            Instance b = neighborhoodA.m_neighbors.get(i);
            DecisionTableHashKey bkey = null;
            try {
                bkey = new DecisionTableHashKey(b, b.numAttributes(), !this.m_classSet);
            }
            catch (Exception ex) {
                this.worker.addException(ex);
                throw new IllegalStateException(ex.getMessage());
            }
            Neighborhood bTemp = this.m_kDistanceContainer.get(bkey);
            sumlrdb += bTemp.m_lrd[k - this.m_lbK];
            ++i;
        }
        return sumlrdb / (neighborhoodA.m_tempCardinality[k - this.m_lbK] * neighborhoodA.m_lrd[k - this.m_lbK]);
    }

    protected double reachability(Instance a, Instance b, double distAB, int k) {
        DecisionTableHashKey bkey = null;
        try {
            bkey = new DecisionTableHashKey(b, b.numAttributes(), !this.m_classSet);
        }
        catch (Exception ex) {
            this.worker.addException(ex);
            throw new IllegalStateException(ex.getMessage());
        }
        Neighborhood bN = this.m_kDistanceContainer.get(bkey);
        double kDistanceB = bN.m_distances[--k];
        while (k < bN.m_distances.length - 1 && kDistanceB == bN.m_distances[k + 1]) {
            kDistanceB = bN.m_distances[++k];
        }
        return Math.max(kDistanceB, distAB);
    }

    @Override
    public void setEnvironment(Environment env) {
        this.m_env = env;
    }

    @Override
    public String getRevision() {
        return RevisionUtils.extract("$Revision: 8957 $");
    }

    protected class LOFFinder
    implements Runnable {
        protected Instances m_lofTrain;
        protected int m_k;

        public LOFFinder(Instances training, int k) {
            this.m_lofTrain = training;
            this.m_k = k;
        }

        public void run() {
            try {
                int i = 0;
                while (i < this.m_lofTrain.numInstances()) {
                    Instance current = this.m_lofTrain.instance(i);
                    Neighborhood currentN = LOF.this.m_kDistanceContainer.get(LOF.this.m_instKeys[i]);
                    int indexOfKDistanceForK = this.m_k - 1;
                    while (indexOfKDistanceForK < currentN.m_distances.length - 1 && currentN.m_distances[indexOfKDistanceForK] == currentN.m_distances[indexOfKDistanceForK + 1]) {
                        ++indexOfKDistanceForK;
                    }
                    double cardinality = 0.0;
                    double sumReachability = 0.0;
                    int j = 0;
                    while (j <= indexOfKDistanceForK) {
                        Instance b = currentN.m_neighbors.instance(j);
                        cardinality += b.weight();
                        sumReachability += LOF.this.reachability(current, b, currentN.m_distances[j], this.m_k);
                        ++j;
                    }
                    currentN.m_lrd[this.m_k - LOF.this.m_lbK] = cardinality / sumReachability;
                    currentN.m_tempCardinality[this.m_k - LOF.this.m_lbK] = cardinality;
                    ++i;
                }
                i = 0;
                while (i < this.m_lofTrain.numInstances()) {
                    double lofK;
                    Neighborhood currentN = LOF.this.m_kDistanceContainer.get(LOF.this.m_instKeys[i]);
                    currentN.m_lof[this.m_k - LOF.this.m_lbK] = lofK = LOF.this.lof(currentN, this.m_k);
                    ++i;
                }
                LOF.this.completedTask("LOF finder", true, LOF.this.m_ubK - LOF.this.m_lbK);
            }
            catch (Exception ex) {
                LOF.this.worker.addException(ex);
                LOF.this.completedTask("LOF finder", false, LOF.this.m_ubK - LOF.this.m_lbK);
            }
        }
    }

    protected class NNFinder
    implements Runnable {
        protected Instances m_nnTrain;
        protected int m_start;
        protected int m_end;
        protected NearestNeighbourSearch m_search;

        public NNFinder(Instances training, int start, int end, NearestNeighbourSearch search) {
            this.m_nnTrain = training;
            this.m_start = start;
            this.m_end = end;
            this.m_search = search;
        }

        public void run() {
            try {
                int i = this.m_start;
                while (i < this.m_end) {
                    Neighborhood n;
                    Instance current = this.m_nnTrain.get(i);
                    DecisionTableHashKey key = new DecisionTableHashKey(current, current.numAttributes(), !LOF.this.m_classSet);
                    if (LOF.this.addToKDistanceContainer(key, n = new Neighborhood())) {
                        Instances nn;
                        n.m_neighbors = nn = this.m_search.kNearestNeighbours(current, LOF.this.m_ubK * 2);
                        n.m_distances = this.m_search.getDistances();
                        n.m_tempCardinality = new double[LOF.this.m_ubK - LOF.this.m_lbK];
                        n.m_lrd = new double[LOF.this.m_ubK - LOF.this.m_lbK];
                        n.m_lof = new double[LOF.this.m_ubK - LOF.this.m_lbK];
                        LOF.this.trimZeroDistances(n);
                    }
                    LOF.this.m_instKeys[i] = key;
                    ++i;
                }
                LOF.this.completedTask("NN search", true, LOF.this.m_numExecutionSlots);
            }
            catch (Exception ex) {
                LOF.this.worker.addException(ex);
                LOF.this.completedTask("NN search", false, LOF.this.m_numExecutionSlots);
            }
        }
    }

    protected class Neighborhood
    implements Serializable {
        private static final long serialVersionUID = 3381174623146672703L;
        public Instances m_neighbors;
        public double[] m_distances;
        public double[] m_tempCardinality;
        public double[] m_lrd;
        public double[] m_lof;

        protected Neighborhood() {
        }
    }
}

