/*
 * Decompiled with CFR 0.152.
 */
package nl.siegmann.epublib.epub;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import nl.siegmann.epublib.domain.Book;
import nl.siegmann.epublib.domain.Guide;
import nl.siegmann.epublib.domain.GuideReference;
import nl.siegmann.epublib.domain.Resource;
import nl.siegmann.epublib.domain.Spine;
import nl.siegmann.epublib.domain.SpineReference;
import nl.siegmann.epublib.epub.EpubWriter;
import nl.siegmann.epublib.epub.PackageDocumentBase;
import nl.siegmann.epublib.epub.PackageDocumentMetadataWriter;
import nl.siegmann.epublib.service.MediatypeService;
import nl.siegmann.epublib.util.StringUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xmlpull.v1.XmlSerializer;

public class PackageDocumentWriter
extends PackageDocumentBase {
    private static final Logger log = LoggerFactory.getLogger(PackageDocumentWriter.class);

    public static void write(EpubWriter epubWriter, XmlSerializer serializer, Book book) throws IOException {
        try {
            serializer.startDocument("UTF-8", false);
            serializer.setPrefix("opf", "http://www.idpf.org/2007/opf");
            serializer.setPrefix("dc", "http://purl.org/dc/elements/1.1/");
            serializer.startTag("http://www.idpf.org/2007/opf", "package");
            serializer.attribute("", "version", "2.0");
            serializer.attribute("", "unique-identifier", "BookId");
            PackageDocumentMetadataWriter.writeMetaData(book, serializer);
            PackageDocumentWriter.writeManifest(book, epubWriter, serializer);
            PackageDocumentWriter.writeSpine(book, epubWriter, serializer);
            PackageDocumentWriter.writeGuide(book, epubWriter, serializer);
            serializer.endTag("http://www.idpf.org/2007/opf", "package");
            serializer.endDocument();
            serializer.flush();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private static void writeSpine(Book book, EpubWriter epubWriter, XmlSerializer serializer) throws IllegalArgumentException, IllegalStateException, IOException {
        serializer.startTag("http://www.idpf.org/2007/opf", "spine");
        serializer.attribute("", "toc", book.getSpine().getTocResource().getId());
        if (book.getCoverPage() != null && book.getSpine().findFirstResourceById(book.getCoverPage().getId()) < 0) {
            serializer.startTag("http://www.idpf.org/2007/opf", "itemref");
            serializer.attribute("", "idref", book.getCoverPage().getId());
            serializer.attribute("", "linear", "no");
            serializer.endTag("http://www.idpf.org/2007/opf", "itemref");
        }
        PackageDocumentWriter.writeSpineItems(book.getSpine(), serializer);
        serializer.endTag("http://www.idpf.org/2007/opf", "spine");
    }

    private static void writeManifest(Book book, EpubWriter epubWriter, XmlSerializer serializer) throws IllegalArgumentException, IllegalStateException, IOException {
        serializer.startTag("http://www.idpf.org/2007/opf", "manifest");
        serializer.startTag("http://www.idpf.org/2007/opf", "item");
        serializer.attribute("", "id", epubWriter.getNcxId());
        serializer.attribute("", "href", epubWriter.getNcxHref());
        serializer.attribute("", "media-type", epubWriter.getNcxMediaType());
        serializer.endTag("http://www.idpf.org/2007/opf", "item");
        for (Resource resource : PackageDocumentWriter.getAllResourcesSortById(book)) {
            PackageDocumentWriter.writeItem(book, resource, serializer);
        }
        serializer.endTag("http://www.idpf.org/2007/opf", "manifest");
    }

    private static List<Resource> getAllResourcesSortById(Book book) {
        ArrayList<Resource> allResources = new ArrayList<Resource>(book.getResources().getAll());
        Collections.sort(allResources, new Comparator<Resource>(){

            @Override
            public int compare(Resource resource1, Resource resource2) {
                return resource1.getId().compareToIgnoreCase(resource2.getId());
            }
        });
        return allResources;
    }

    private static void writeItem(Book book, Resource resource, XmlSerializer serializer) throws IllegalArgumentException, IllegalStateException, IOException {
        if (resource == null || resource.getMediaType() == MediatypeService.NCX && book.getSpine().getTocResource() != null) {
            return;
        }
        if (StringUtil.isBlank(resource.getId())) {
            log.error("resource id must not be empty (href: " + resource.getHref() + ", mediatype:" + resource.getMediaType() + ")");
            return;
        }
        if (StringUtil.isBlank(resource.getHref())) {
            log.error("resource href must not be empty (id: " + resource.getId() + ", mediatype:" + resource.getMediaType() + ")");
            return;
        }
        if (resource.getMediaType() == null) {
            log.error("resource mediatype must not be empty (id: " + resource.getId() + ", href:" + resource.getHref() + ")");
            return;
        }
        serializer.startTag("http://www.idpf.org/2007/opf", "item");
        serializer.attribute("", "id", resource.getId());
        serializer.attribute("", "href", resource.getHref());
        serializer.attribute("", "media-type", resource.getMediaType().getName());
        serializer.endTag("http://www.idpf.org/2007/opf", "item");
    }

    private static void writeSpineItems(Spine spine, XmlSerializer serializer) throws IllegalArgumentException, IllegalStateException, IOException {
        for (SpineReference spineReference : spine.getSpineReferences()) {
            serializer.startTag("http://www.idpf.org/2007/opf", "itemref");
            serializer.attribute("", "idref", spineReference.getResourceId());
            if (!spineReference.isLinear()) {
                serializer.attribute("", "linear", "no");
            }
            serializer.endTag("http://www.idpf.org/2007/opf", "itemref");
        }
    }

    private static void writeGuide(Book book, EpubWriter epubWriter, XmlSerializer serializer) throws IllegalArgumentException, IllegalStateException, IOException {
        serializer.startTag("http://www.idpf.org/2007/opf", "guide");
        PackageDocumentWriter.ensureCoverPageGuideReferenceWritten(book.getGuide(), epubWriter, serializer);
        for (GuideReference reference : book.getGuide().getReferences()) {
            PackageDocumentWriter.writeGuideReference(reference, serializer);
        }
        serializer.endTag("http://www.idpf.org/2007/opf", "guide");
    }

    private static void ensureCoverPageGuideReferenceWritten(Guide guide, EpubWriter epubWriter, XmlSerializer serializer) throws IllegalArgumentException, IllegalStateException, IOException {
        if (!guide.getGuideReferencesByType(GuideReference.COVER).isEmpty()) {
            return;
        }
        Resource coverPage = guide.getCoverPage();
        if (coverPage != null) {
            PackageDocumentWriter.writeGuideReference(new GuideReference(guide.getCoverPage(), GuideReference.COVER, GuideReference.COVER), serializer);
        }
    }

    private static void writeGuideReference(GuideReference reference, XmlSerializer serializer) throws IllegalArgumentException, IllegalStateException, IOException {
        if (reference == null) {
            return;
        }
        serializer.startTag("http://www.idpf.org/2007/opf", "reference");
        serializer.attribute("", "type", reference.getType());
        serializer.attribute("", "href", reference.getCompleteHref());
        if (StringUtil.isNotBlank(reference.getTitle())) {
            serializer.attribute("", "title", reference.getTitle());
        }
        serializer.endTag("http://www.idpf.org/2007/opf", "reference");
    }
}

