package lu.uni.minus.utils;

import java.io.BufferedReader;
import java.io.FileReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

import javax.swing.table.AbstractTableModel;

import lu.uni.minus.preferences.DataSet;

public class StatTableModel extends AbstractTableModel
{
  private static final long serialVersionUID = 712694630593475842L;
  private String[] columnNames = { "User", "Number of days", "Total number", "Min number in a day",
      "Max number in a day", "Average number" };
  private Object[][] data;

  public StatTableModel(List<String> selectedList, DataSet dataset, boolean sourceData,
      String selectedParaSetting) {
    if (sourceData || (dataset.getType().equals(DataSet.Type.SP))) {
      data = new Object[selectedList.size()][columnNames.length];
      String inputPath;
      if (sourceData) {
        inputPath = dataset.getOutputPath().toString()
            + "/Stats/SourceDataAndStayPoints/SourceData.txt";
      }
      else {
        inputPath = dataset.getOutputPath().toString() + "/Stats/StayPoints.txt";
      }
      try {
        String[] selectedUsers = selectedList.toArray(new String[0]);
        Arrays.sort(selectedUsers);
        int foundUsers = 0;

        BufferedReader br = new BufferedReader(new FileReader(inputPath));
        String aLine;
        while (foundUsers < selectedUsers.length && (aLine = br.readLine()) != null){
          String[] fields = aLine.split(" ");
          if (Arrays.binarySearch(selectedUsers, fields[0]) < 0) {
            continue;
          }
          else {
            for (int i = 0; i < 6; i++) {
              if (i != 5) {
                data[foundUsers][i] = fields[i];
              }
              else {
                data[foundUsers][i] = String.format("%1$.1f", Double.parseDouble(fields[i]));
              }
            }
            foundUsers++;
          }
        }
        br.close();
      }
      catch (Exception e) {
        e.printStackTrace();
      }

    }
    else {
      String inputPath = dataset.getOutputPath().toString() + "/Stats/SourceDataAndStayPoints/"
          + selectedParaSetting;
      ArrayList<String[]> initialData = new ArrayList<String[]>();
      try {
        String[] selectedUsers = selectedList.toArray(new String[0]);
        Arrays.sort(selectedUsers);
        int foundUsers = 0;

        BufferedReader br = new BufferedReader(new FileReader(inputPath));
        String aLine;
        while (foundUsers < selectedUsers.length && (aLine = br.readLine()) != null) {
          String[] fields = aLine.split(" ");
          if (Arrays.binarySearch(selectedUsers, fields[0]) < 0) {
            continue;
          }
          else {
            initialData.add(fields);
            foundUsers++;
          }
        }

        data = new Object[initialData.size()][columnNames.length];
        for (int i = 0; i < initialData.size(); i++) {
          String[] aRow = initialData.get(i);
          for (int j = 0; j < 6; j++) {
            if (j != 5) {
              data[i][j] = aRow[j];
            }
            else {
              data[i][j] = String.format("%1$.1f", Double.parseDouble(aRow[j]));
            }
          }
        }
        br.close();
      }
      catch (Exception e) {
        e.printStackTrace();
      }
    }
  }

  public int getColumnCount() {
    return columnNames.length;
  }

  public int getRowCount() {
    return data.length;
  }

  public Object getValueAt(int row, int col) {
    return data[row][col];
  }

  public String getColumnName(int col) {
    return columnNames[col];
  }

  public boolean isCellEditable(int row, int col) {
    return false;
  }

  public Class<? extends Object> getColumnClass(int c) {
    return Number.class;
  }
}
