package lu.uni.minus.utils;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;

import javax.swing.SwingWorker;

import lu.uni.minus.ui.Announcer;

public abstract class TextPaneWorker extends SwingWorker<Integer, String>
{
  /** The text area where messages are written. */
  private Announcer announcer;

  /**
   * Default constr
   */
  public TextPaneWorker() {
    announcer = null;
  }

  public TextPaneWorker(Announcer an) {
    announcer = an;
  }

  public void setAnnouncer(Announcer an) {
    announcer = an;
  }

  public void addMessage(String html) {
    if (announcer != null) {
      announcer.addMessage(html);
    }
  }

  public void addErrorMessage(String html) {
    if (announcer != null) {
      announcer.addMessage(formatError(html));
    }
  }

  public void addException(Exception e) {
    if (announcer != null) {
      Writer writer = new StringWriter();
      PrintWriter printWriter = new PrintWriter(writer);
      e.printStackTrace(printWriter);
      announcer.addMessage(formatError(writer.toString()));
    }
  }
  public void setDone(int i){
    setProgress(i);
  }
  /**
   * Formats error message
   *
   * @param message
   * @return
   */
  public String formatError(String message) {
    String result = "<div><font size=3 color=RED>[ERROR]" + message + "</font></div>";
    return result;
  }

  /**
   * Formats neutral message
   *
   * @param message
   * @return
   */
  public String formatMessage(String message) {
    String result = "<div><font size=3 color=BLACK>" + message + "</font></div>";
    return result;
  }

  /**
   * Formats positive message
   *
   * @param message
   * @return
   */
  public String formatOK(String message) {
    String result = "<div><font size=3 color=GREEN>[OK]" + message + "</font></div>";
    return result;
  }
}
