package lu.uni.minus.utils;

/**
 * Class holding the user statistics
 *
 * @author Piotr Kordy
 */
public class UserStatistics
{
  private String userID;
  private int numberOfDays, numberOfPoints, maxNumberOfPointsInADay, minNumberOfPointsInADay;

  public UserStatistics() {
    setMinNumberOfPointsInADay(Integer.MAX_VALUE);
    setMaxNumberOfPointsInADay(0);
    setNumberOfPoints(0);
    setNumberOfDays(0);
  }

  public String toString() {
    return userID + " " + numberOfDays + " " + numberOfPoints + " " + minNumberOfPointsInADay + " "
        + maxNumberOfPointsInADay + " " + (getAvgNoOfPointsPerDay()) + "\n";
  }

  public double getAvgNoOfPointsPerDay() {
    return (double) numberOfPoints / numberOfDays;
  }

  /**
   * @return the userID
   */
  public String getUserID() {
    return userID;
  }

  /**
   * @param userID
   *          the userID to set
   */
  public void setUserID(String userID) {
    this.userID = userID;
  }

  /**
   * @return the numberOfDays
   */
  public int getNumberOfDays() {
    return numberOfDays;
  }

  /**
   * @param numberOfDays
   *          the numberOfDays to set
   */
  public void setNumberOfDays(int numberOfDays) {
    this.numberOfDays = numberOfDays;
  }

  /**
   * @return the numberOfPoints
   */
  public int getNumberOfPoints() {
    return numberOfPoints;
  }

  /**
   * @param numberOfPoints
   *          the numberOfPoints to set
   */
  public void setNumberOfPoints(int numberOfPoints) {
    this.numberOfPoints = numberOfPoints;
  }

  /**
   * @return the maxNumberOfPointsInADay
   */
  public int getMaxNumberOfPointsInADay() {
    return maxNumberOfPointsInADay;
  }

  /**
   * @param maxNumberOfPointsInADay
   *          the maxNumberOfPointsInADay to set
   */
  public void setMaxNumberOfPointsInADay(int maxNumberOfPointsInADay) {
    this.maxNumberOfPointsInADay = maxNumberOfPointsInADay;
  }

  /**
   * @return the minNumberOfPointsInADay
   */
  public int getMinNumberOfPointsInADay() {
    return minNumberOfPointsInADay;
  }

  /**
   * @param minNumberOfPointsInADay
   *          the minNumberOfPointsInADay to set
   */
  public void setMinNumberOfPointsInADay(int minNumberOfPointsInADay) {
    this.minNumberOfPointsInADay = minNumberOfPointsInADay;
  }
}
