/**
 * Author: Piotr Kordy (piotr.kordy@uni.lu <mailto:piotr.kordy@uni.lu>)
 * Date:   06/06/2014
 * Copyright (c) 2014,2013 University of Luxembourg
 * All rights reserved.
 * Licensed under GNU Affero General Public License 3.0;
 *    This program is free software: you can redistribute it and/or modify
 *    it under the terms of the GNU Affero General Public License as
 *    published by the Free Software Foundation, either version 3 of the
 *    License, or (at your option) any later version.
 *
 *    This program is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU Affero General Public License for more details.
 *
 *    You should have received a copy of the GNU Affero General Public License
 *    along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
package lu.uni.minus.ui;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.io.IOException;
import java.net.URL;
import java.util.jar.Attributes;
import java.util.jar.Manifest;

import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.KeyStroke;
import javax.swing.border.Border;

import lu.uni.minus.Main;

public class AboutDialog extends JDialog
{
  private static final long serialVersionUID = -6414657787197465221L;

  /**
   * {@inheritDoc}
   *
   * @see JDialog#AboutDialog()
   */
  public AboutDialog(JFrame parent) {
    super(parent);
    initCloseListener();
    initUI();
  }

  /**
   * Create the dialog.
   */
  public final void initUI() {
    JPanel mainPane = new JPanel();
    JLabel name;
    ImageIcon icon;
    Border paneEdge = BorderFactory.createEmptyBorder(20, 20, 20, 20);
    mainPane.setBorder(paneEdge);
    mainPane.setBackground(Color.white);
    mainPane.setOpaque(true);
    mainPane.setLayout(new BoxLayout(mainPane, BoxLayout.Y_AXIS));
    String version = getVersionInfo();
    name = new JLabel("MinUS Tool " + version);
    name.setFont(new Font("Serif", Font.BOLD, 14));
    name.setAlignmentX(0.5f);
    mainPane.add(name);
    mainPane.add(Box.createRigidArea(new Dimension(0, 10)));
    // ADTool icon
    icon = createImageIcon("/icons/uniLogo.png", "University of Luxembourg");
    JLabel label = new JLabel(icon);
    label.setAlignmentX(0.5f);
    mainPane.add(label);
    mainPane.add(Box.createRigidArea(new Dimension(0, 10)));
    // "Supported by" text
    name = new JLabel("<html>" + "This program is directed by Dr. Jun Pang and Xihui Chen.<br/>"
        + "The code is contributed by Xihui Chen, Piotr Kordy, Ruipeng Lu, and Ran Xue.<br/>"
        + "This program uses the T-pattern mining tool coded by<br/>"
        + "Mirco Nanni and Fabio Pinelli of the University of Pisa, Italy.<br/><br/>"
        + "This program belongs to the SaToSS group of the University of Luxembourg.<br/>"
        + "</html>");

    name.setFont(new Font("Serif", Font.PLAIN, 13));
    name.setAlignmentX(0.5f);
    mainPane.add(name);
    mainPane.add(Box.createRigidArea(new Dimension(0, 10)));
    JButton close = new JButton("Close");
    close.addActionListener(new ActionListener()
    {
      public void actionPerformed(ActionEvent event) {
        dispose();
      }
    });
    close.setAlignmentX(0.5f);
    mainPane.add(close);
    add(mainPane);
    setModalityType(ModalityType.APPLICATION_MODAL);

    setTitle("About the MinUS Tool " + version);
    setDefaultCloseOperation(DISPOSE_ON_CLOSE);
    setLocationRelativeTo(null);
    pack();

  }

  private void initCloseListener() {
    getRootPane().getInputMap(JComponent.WHEN_IN_FOCUSED_WINDOW).put(
        KeyStroke.getKeyStroke(KeyEvent.VK_ESCAPE, 0), "close");
    getRootPane().getInputMap(JComponent.WHEN_IN_FOCUSED_WINDOW).put(
        KeyStroke.getKeyStroke(KeyEvent.VK_ENTER, 0), "close");
    getRootPane().getActionMap().put("close", new AbstractAction()
    {
      private static final long serialVersionUID = 2143956335533214473L;

      public void actionPerformed(ActionEvent e) {
        dispose();
      }
    });
  }

  public static String getVersionInfo() {
    String result = "";
    try {
      Class<Main> clazz = Main.class;
      String className = clazz.getSimpleName() + ".class";
      String classPath = clazz.getResource(className).toString();
      if (!classPath.startsWith("jar")) {
        // Class not from JAR
        return "No version info";
      }
      String manifestPath = classPath.substring(0, classPath.lastIndexOf("!") + 1)
          + "/META-INF/MANIFEST.MF";
      Manifest manifest = new Manifest(new URL(manifestPath).openStream());
      Attributes mainAttribs = manifest.getMainAttributes();
      result += mainAttribs.getValue("Implementation-Version") + " (";
      // result += mainAttribs.getValue("Implementation-Build");
      result += mainAttribs.getValue("Date-Build") + ")";
    }
    catch (IOException e1) {
      // Silently ignore wrong manifests on classpath?
    }
    return result;
  }

  /**
   * Returns an ImageIcon, or null if the path was invalid.
   */
  private ImageIcon createImageIcon(String path, String description) {
    java.net.URL imgURL = getClass().getResource(path);
    if (imgURL != null) {
      return new ImageIcon(imgURL, description);
    }
    else {
      System.err.println("Couldn't find file: " + path);
      return null;
    }
  }

}
