package lu.uni.minus.ui;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;

import javax.swing.JPanel;
import javax.swing.Scrollable;
import javax.swing.SwingConstants;

public class DataFlowPane extends JPanel implements Scrollable
{
	private static final long serialVersionUID = -2889703643441057016L;
	/**
   * Transformation doing scaling and moving.
   */
  private AffineTransform viewTransform = new AffineTransform();
  private final BasicStroke basicStroke =new BasicStroke(1, BasicStroke.CAP_ROUND, BasicStroke.JOIN_ROUND);
  private final BasicStroke thickStroke =new BasicStroke(3, BasicStroke.CAP_ROUND, BasicStroke.JOIN_ROUND);
  public DataFlowPane()
  {
    super();
    Polygon arrowHead = new Polygon();
    arrowHead.addPoint(-6,1);
    arrowHead.addPoint(3,1);
    arrowHead.addPoint(3,3);
    arrowHead.addPoint(6,0);
    arrowHead.addPoint(3,-3);
    arrowHead.addPoint(3,-1);
    arrowHead.addPoint(-6,-1);
    Dimension dim=new Dimension(900,500);
    setMinimumSize(dim);
    setPreferredSize(dim);
    revalidate();
  }
  /**
   * {@inheritDoc}
   * @see javax.swing.JComponent#paintComponent(Graphics)
   */
  public void paintComponent(final Graphics g)
  {
    super.paintComponent(g);
    final Graphics2D g2 = (Graphics2D) g;
    g2.setColor(Color.white);
    g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING,
          RenderingHints.VALUE_ANTIALIAS_ON);
    Rectangle r = g2.getClipBounds();
    if (r!= null){
      g2.fillRect(r.x,r.y,r.width,r.height);
    }
    viewTransform.setToIdentity();
//     viewTransform.scale(0.5,2);
    g2.transform(viewTransform);
    g2.setStroke(basicStroke);
    g2.setColor(Color.black);
    //900 x 500
    //30 +240 + 60 + 240 +60 + 30
    //Big rectangles
    //first column
    g2.drawRect(30,30,240,150);
    g2.drawRect(30,240,240,200);
    //second column
    g2.drawRect(330,30,240,300);
    g2.drawRect(330,380,240,60);
    //third column
    g2.drawRect(630,30,240,360);
    //title lines
    g2.setStroke(thickStroke);
    g2.drawLine(30,70,270,70);
    g2.drawLine(30,280,270,280);
    g2.drawLine(330,70,570,70);
    g2.drawLine(630,70,870,70);
    g2.setStroke(basicStroke);
    //titles
    Font font=new Font("SanSerif", Font.PLAIN, 17);
    g2.setColor(Color.blue);
    //first column
    drawCenteredString(g2,"Manage datasets",font,30, 270, 46);
    drawCenteredString(g2,"View statistics",font,30, 270, 255);
    //second column
    drawCenteredString(g2,"Construct user profile",font,330, 570, 46);
    drawCenteredString(g2,"Visualisation",font,330, 570, 395);
    drawCenteredString(g2,"View files",font,330, 570, 417);
    //third column
    drawCenteredString(g2,"Compare user similarity",font,630, 870, 45);
    //texts
    g2.setColor(new Color(57,131,26));
    //first column
    drawCenteredString(g2,"Add dataset",font,30, 270, 94);
    drawCenteredString(g2,"Edit dataset",font,30, 270, 125);
    drawCenteredString(g2,"Delete dataset",font,30, 270, 155);
    drawBoxedString(g2,"Datasets' stats",font,30, 270, 330);
    drawBoxedString(g2,"Users' stats",font,30, 270, 390);
    //third column
    drawBoxedString(g2,"MSTP",font,630, 870, 117);
    drawBoxedString(g2,"Improved MSTP",font,630, 870, 183);
    drawBoxedString(g2,"CPS-based",font,630, 870, 249);
    drawDBoxedString(g2,"Hausdorff distance", "based",font,630, 870, 315);
    //second column
    g2.setColor(new Color(207,140,42));
    drawBoxedString(g2,"Detect stay points",font,330, 570, 117);
    drawBoxedString(g2,"Generate RoIs",font,330, 570, 183);
    drawDBoxedString(g2,"Extract frequent","pattern sets",font,330, 570, 249);
    //arrows
    g2.setStroke(thickStroke);
    g2.setColor(Color.black);
    //horizontal
    drawArrow(g2,new Point(270,120),new Point(330,120));
    drawArrow(g2,new Point(570,120),new Point(630,120));
    //vertical
    drawArrow(g2,new Point(145,180),new Point(145,240));
    drawArrow(g2,new Point(450,330),new Point(450,380));
    drawArrow(g2,new Point(450,137),new Point(450,167));
    drawArrow(g2,new Point(450,203),new Point(450,233));
  }
  
  private void drawCenteredString(Graphics2D g2,String text,Font font,int x1, int x2, int y)
  {
    g2.setFont(font);
    final FontMetrics m = getFontMetrics(font);
    g2.drawString(text,(x2+x1)/2-(m.stringWidth(text))/2,y+(m.getHeight()/2));
  }
  private void drawBoxedString(Graphics2D g2,String text,Font font,int x1, int x2, int y)
  {
    final int padding=10;
    g2.setFont(font);
    final FontMetrics m = getFontMetrics(font);
    Point p=new Point((x2+x1)/2-(m.stringWidth(text))/2,y+(m.getHeight()/2));
    g2.drawString(text,p.x,p.y);
    Color c = g2.getColor();
    g2.setColor(Color.black);
    g2.drawRect(p.x-padding,p.y-m.getHeight()+4-padding,m.stringWidth(text)+2*padding,m.getHeight()-4+2*padding);
//     System.out.println("y1="+(new Integer(p.y-m.getHeight()+4-padding)).toString()+" y2="+(new Integer(m.getHeight()-4+2*padding)).toString());
    g2.setColor(c);
  }
  private void drawDBoxedString(Graphics2D g2,String text,String text2,Font font,int x1, int x2, int y)
  {
    final int padding=10;
    g2.setFont(font);
    final FontMetrics m = getFontMetrics(font);
    Point p=new Point((x2+x1)/2-(m.stringWidth(text))/2,y+(m.getHeight()/2));
    Point p2=new Point((x2+x1)/2-(m.stringWidth(text2))/2,y+(m.getHeight()/2));
    g2.drawString(text,p.x,p.y);
    g2.drawString(text2,p2.x,p2.y+m.getHeight());
    Color c = g2.getColor();
    g2.setColor(Color.black);
    g2.drawRect(p.x-padding,p.y-m.getHeight()+4-padding,m.stringWidth(text)+2*padding,2*m.getHeight()-4+2*padding);
//     System.out.println("yy1="+(new Integer(p.y-m.getHeight()+4-padding)).toString()+" yy2="+(new Integer(2*m.getHeight()-4+2*padding)).toString());
    g2.setColor(c);
  }

  private void drawArrow(Graphics2D g2, Point p1,Point p2)
  {
    final int arrowSize=5;
    double rotate = Math.atan2(p2.y - p1.y, p2.x - p1.x);
    AffineTransform transform = new AffineTransform();
    Polygon arrowPolygon = new Polygon();
    arrowPolygon.addPoint(0,0);
    arrowPolygon.addPoint(-2,-1);
    arrowPolygon.addPoint(-1,0);
    arrowPolygon.addPoint(-2,1);
    arrowPolygon.addPoint(0,0);

    transform.setToIdentity();
    transform.translate(p2.x, p2.y);
    transform.rotate(rotate);
    transform.scale(arrowSize,arrowSize);

    g2.drawLine(p1.x,p1.y,p2.x-(int)(arrowSize*Math.cos(rotate)),p2.y-(int)(arrowSize*Math.sin(rotate)));
    g2.fill(transform.createTransformedShape(arrowPolygon));
  }

  /**
   * {@inheritDoc}
   * @see Scrollable#getScrollableUnitIncrement(Rectangle,int,int)
   */
  public int getScrollableUnitIncrement(Rectangle visibleRect, int orientation,
      int direction)
  {
    return 0;
  }

  /**
   * {@inheritDoc}
   * @see Scrollable#getScrollableTracksViewportWidth()
   */
  public boolean getScrollableTracksViewportWidth()
  {
    return false;
  }

  /**
   * {@inheritDoc}
   * @see Scrollable#getScrollableTracksViewportHeight()
   */
  public boolean getScrollableTracksViewportHeight()
  {
    return false;
  }
  /**
   * {@inheritDoc}
   * @see Scrollable#getScrollableBlockIncrement(Rectangle,int,int)
   */
  public int getScrollableBlockIncrement(Rectangle visibleRect,
      int orientation, int direction)
  {
    int maxUnitIncrement = 1;
    if (orientation == SwingConstants.HORIZONTAL)
      return visibleRect.width - maxUnitIncrement;
    else
      return visibleRect.height - maxUnitIncrement;
  }

  /**
   * {@inheritDoc}
   * 
   * @see Scrollable#getPreferredScrollableViewportSize()
   */
  public Dimension getPreferredScrollableViewportSize()
  {
    return getPreferredSize();
  }


}
