package lu.uni.minus.ui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.HashSet;

import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

import lu.uni.minus.preferences.DataSet;
import lu.uni.minus.utils.ProcessRunner;

import org.apache.commons.io.FileUtils;

public class VisualisePanel extends JPanel
{
  private static final long serialVersionUID = -2391648635093066444L;
  private final MainWindow mw;
  private DataSet dataset;
  private final JList<String> userList = new JList<String>();
  private final JList<String> spList = new JList<String>();
  private final JList<String> roiList = new JList<String>();
  private final JButton btnStart = new JButton("Start");
  private final JButton btnClose = new JButton("Close");

  public VisualisePanel(MainWindow aMw, DataSet aDataset) {
    mw = aMw;
    dataset = aDataset;
    createGui();
  }

  private void createGui() {
    final JSplitPane leftSplitPane = new JSplitPane();
    final JSplitPane rightSplitPane = new JSplitPane();
    final JPanel userPanel = new JPanel();
    final JPanel spPanel = new JPanel();
    final JPanel roiPanel = new JPanel();
    final Dimension space = new Dimension(10, 10);
    final Dimension smallSpace = new Dimension(5, 5);

    JLabel tempLabel;
    JScrollPane scrollPane;

    setLayout(new BorderLayout(0, 0));
    userPanel.setMinimumSize(new Dimension(150, 150));
    spPanel.setMinimumSize(new Dimension(150, 150));
    roiPanel.setMinimumSize(new Dimension(150, 150));
    final String[] users = dataset.getUserList();
    final JLabel spLabel = new JLabel("Stay point file list");
    if (dataset.getType() == DataSet.Type.GPS) {
      add(leftSplitPane, BorderLayout.CENTER);
      leftSplitPane.setRightComponent(rightSplitPane);
      leftSplitPane.setLeftComponent(userPanel);
      userPanel.setLayout(new BoxLayout(userPanel, BoxLayout.Y_AXIS));
      tempLabel = new JLabel("GPS user list");
      tempLabel.setAlignmentX(Component.CENTER_ALIGNMENT);
      userPanel.add(Box.createRigidArea(space));
      userPanel.add(tempLabel);
      userPanel.add(Box.createRigidArea(space));
      scrollPane = new JScrollPane();
      scrollPane.setViewportView(userList);
      userList.setListData(users);
      userList.setSelectionMode(ListSelectionModel.SINGLE_SELECTION);
      userPanel.add(scrollPane);
      final JButton btnClearUsers = new JButton("Clear Selection");
      btnClearUsers.setAlignmentX(Component.CENTER_ALIGNMENT);
      userPanel.add(Box.createRigidArea(smallSpace));
      btnClearUsers.addActionListener(new ActionListener()
      {
        public void actionPerformed(ActionEvent e) {
          userList.clearSelection();
        }
      });
      userPanel.add(btnClearUsers);
      userPanel.add(Box.createRigidArea(smallSpace));
      spList.setToolTipText("<html>Each item is the parameter settings used when forming "
          + "the stay point file it represents.<br/>Its format is "
          + "\"distance threshold_time threshold_stay point merging threshold\".</html>");
      userList.addListSelectionListener(new ListSelectionListener()
      {
        public void valueChanged(ListSelectionEvent e) {
          String user = userList.getSelectedValue();
          if (user != null) {
            ArrayList<String> spParas = new ArrayList<String>();
            File[] spFiles = dataset.getSPFiles();
            for (File anSPDir : spFiles) {
              File supposedSPFile = new File(anSPDir + File.separator + user + ".txt");
              try {
                if (FileUtils.directoryContains(anSPDir, supposedSPFile)) {
                  spParas.add(anSPDir.getName());
                }
              }
              catch (IOException e1) {
                e1.printStackTrace();
              }
            }
            spLabel.setText("SP file list of user " + user);
            spList.setListData(spParas.toArray(new String[0]));
          }
        }
      });
    }
    else {
      add(rightSplitPane, BorderLayout.CENTER);
      spList.setListData(users);
    }
    rightSplitPane.setLeftComponent(spPanel);
    spPanel.setLayout(new BoxLayout(spPanel, BoxLayout.Y_AXIS));
    spLabel.setAlignmentX(Component.CENTER_ALIGNMENT);
    spPanel.add(Box.createRigidArea(space));
    spPanel.add(spLabel);
    spPanel.add(Box.createRigidArea(space));
    scrollPane = new JScrollPane();
    scrollPane.setViewportView(spList);
    spList.setSelectionMode(ListSelectionModel.SINGLE_SELECTION);
    spPanel.add(scrollPane);
    final JButton btnClearSp = new JButton("Clear Selection");
    btnClearSp.setAlignmentX(Component.CENTER_ALIGNMENT);
    btnClearSp.addActionListener(new ActionListener()
    {
      public void actionPerformed(ActionEvent e) {
        spList.clearSelection();
      }
    });
    spPanel.add(Box.createRigidArea(smallSpace));
    spPanel.add(btnClearSp);
    spPanel.add(Box.createRigidArea(smallSpace));

    rightSplitPane.setRightComponent(roiPanel);
    roiPanel.setLayout(new BoxLayout(roiPanel, BoxLayout.Y_AXIS));
    tempLabel = new JLabel("RoI file list");
    tempLabel.setAlignmentX(Component.CENTER_ALIGNMENT);
    roiPanel.add(Box.createRigidArea(space));
    roiPanel.add(tempLabel);
    roiPanel.add(Box.createRigidArea(space));
    scrollPane = new JScrollPane();
    scrollPane.setViewportView(roiList);
    roiList.setSelectionMode(ListSelectionModel.SINGLE_SELECTION);
    roiList
        .setToolTipText("<html>\r\nThe first part after splitting each item with \"-\" is a list of "
            + "all users separated by \"_\".<br/>The second part is the parameter "
            + "settings used when detecting stay points involved in forming the RoI file.<br/>"
            + "The format of the second part  is \"distance threshold_time threshold_stay point"
            + " merging threshold\".</html>");
    roiPanel.add(scrollPane);
    final JButton btnClearRoI = new JButton("Clear Selection");
    btnClearRoI.setAlignmentX(Component.CENTER_ALIGNMENT);
    btnClearRoI.addActionListener(new ActionListener()
    {
      public void actionPerformed(ActionEvent e) {
        roiList.clearSelection();
      }
    });
    roiPanel.add(Box.createRigidArea(smallSpace));
    roiPanel.add(btnClearRoI);
    roiPanel.add(Box.createRigidArea(smallSpace));

    rightSplitPane.setResizeWeight(0.5);
    leftSplitPane.setResizeWeight(0.333);
    JPanel buttonPanel = new JPanel();
    buttonPanel.setLayout(new BoxLayout(buttonPanel, BoxLayout.X_AXIS));
    buttonPanel.add(Box.createHorizontalGlue());
    buttonPanel.add(btnStart);
    buttonPanel.add(Box.createRigidArea(space));
    buttonPanel.add(btnClose);
    btnClose.addActionListener(new ActionListener()
    {
      public void actionPerformed(ActionEvent e) {
        mw.goHome();
      }
    });
    buttonPanel.add(Box.createHorizontalGlue());
    add(buttonPanel, BorderLayout.SOUTH);

    spList.addListSelectionListener(new ListSelectionListener()
    {
      public void valueChanged(ListSelectionEvent e) {
        String user;
        String spPara;
        spPara = spList.getSelectedValue();
        if (dataset.getType() == DataSet.Type.GPS) {
          user = userList.getSelectedValue();
        }
        else {
          user = spList.getSelectedValue();
        }

        if (spPara != null && user != null) {
          ArrayList<String> usableRoIFiles = new ArrayList<String>();
          if (dataset.isRoiDir(spPara)) {
            File selectedParaRoIDir = dataset.createRoIDir(spPara);
            String[] roiFiles = selectedParaRoIDir.list();
            for (String anRoIFile : roiFiles) {
              String[] fields = anRoIFile.split("-");
              String[] users = fields[0].split("_");
              HashSet<String> usersAnRoI = new HashSet<String>();
              for (String aUser : users) {
                usersAnRoI.add(aUser);
              }
              if (usersAnRoI.contains(user)) {
                usableRoIFiles.add(anRoIFile.substring(0, anRoIFile.length() - 4));
              }
            }
            roiList.setListData(usableRoIFiles.toArray(new String[0]));
          }
        }
        else {
          roiList.setListData(new String[0]);
        }
      }
    });

    btnStart.addActionListener(new ActionListener()
    {
      public void actionPerformed(ActionEvent e) {
        ArrayList<String> cmdBuilder = new ArrayList<String>();
        cmdBuilder.add("map.exe");
        if (dataset.getType() == DataSet.Type.GPS) {
          String user = userList.getSelectedValue();
          String sp = spList.getSelectedValue();
          String roi = roiList.getSelectedValue();

          if (user == null && sp == null && roi == null) {
            JOptionPane.showMessageDialog(VisualisePanel.this,
                "You must choose user, stay point and RoI.", "Information",
                JOptionPane.INFORMATION_MESSAGE);
            return;
          }
          if (user != null) {
            cmdBuilder.add("-gps");
            cmdBuilder.add(dataset.getUserInDir(user).toString());
          }
          if (sp != null) {
            cmdBuilder.add("-staypoint");
            cmdBuilder.add(dataset.getSPFile(sp, user).toString());
          }
          if (roi != null) {
            cmdBuilder.add("-roi");
            cmdBuilder.add(dataset.getOutputPath() + "/RoIs/" + sp + "/" + roi + ".txt");
          }

        }
        else {
          String sp = spList.getSelectedValue();
          String roi = roiList.getSelectedValue();

          if (sp == null && roi == null) {
            JOptionPane.showMessageDialog(VisualisePanel.this,
                "You haven't selected anything to be visualized.", "Information",
                JOptionPane.INFORMATION_MESSAGE);
            return;
          }

          if (sp != null) {
            cmdBuilder.add("-staypoint");
            cmdBuilder.add(dataset.getInputPath() + File.separator + sp + ".txt");
          }
          if (roi != null) {
            cmdBuilder.add("-roi");
            cmdBuilder.add(dataset.getOutputPath() + File.separator + "RoIs" + File.separator + roi
                + ".txt");
          }
        }
        String[] cmd = cmdBuilder.toArray(new String[0]);
        Process p = ProcessRunner.getMapProcess(cmd, mw);
        if (p == null) {
          JOptionPane.showMessageDialog((MainWindow) mw, "Could not start visualisation tool.",
              "Error", JOptionPane.ERROR_MESSAGE);
          return;
        }
        BufferedReader bri = new BufferedReader(new InputStreamReader(p.getInputStream()));
        BufferedReader bre = new BufferedReader(new InputStreamReader(p.getErrorStream()));
        String line;
        try {
          while ((line = bri.readLine()) != null) {
            System.out.println(line);
            // ePanel.addMessage(line + "\n");
          }
          bri.close();
          while ((line = bre.readLine()) != null) {
            System.err.println(line);
            // ePanel.addMessage(line + "\n");
          }
          bre.close();
        }
        catch (IOException e1) {
          // TODO Auto-generated catch block
          e1.printStackTrace();
        }
        // ePanel.addMessage("****************************************************************\n");

      }
    });

  }
}
