/*
 * Decompiled with CFR 0.152.
 */
package lu.uni.adcommand;

import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.io.StringReader;
import lu.uni.adtool.adtree.ADTNode;
import lu.uni.adtool.adtree.ADTParser;
import lu.uni.adtool.adtree.ParseException;
import lu.uni.adtool.adtree.TokenMgrError;
import lu.uni.adtool.domains.Domain;
import lu.uni.adtool.domains.Evaluator;
import lu.uni.adtool.domains.ValueAssignement;
import lu.uni.adtool.domains.predefined.SatProp;
import lu.uni.adtool.domains.rings.Bool;

public class Main {
    public static ADTParser parser = null;
    private Evaluator<Bool> evaluator;
    private Domain<Bool> domain = new SatProp();
    private ValueAssignement<Bool> valueAssPro;
    private ValueAssignement<Bool> valueAssOpp;
    private ADTNode terms;

    public Main() {
        this.evaluator = new Evaluator<Bool>(this.domain);
        this.valueAssPro = new ValueAssignement();
        this.valueAssOpp = new ValueAssignement();
        try {
            String str = this.readFile("terms.txt");
            this.fillAssigments();
            this.parse(str);
            this.evaluator.reevaluate(this.terms, this.valueAssPro, this.valueAssOpp);
            System.out.println("Value for root:" + this.evaluator.getValue(this.terms));
        }
        catch (IOException e) {
            System.err.println(e);
        }
    }

    public static void main(String[] args) {
        new Main();
    }

    public void parse(String str) {
        if (parser == null) {
            parser = new ADTParser(new StringReader(str));
        }
        ADTParser.ReInit(new StringReader(str));
        try {
            this.terms = ADTParser.parse();
        }
        catch (ParseException e) {
            System.err.println(e.getMessage());
        }
        catch (TokenMgrError e) {
            System.err.println(e.getMessage());
        }
    }

    private void fillAssigments() {
        this.valueAssPro.put("N_1", new Bool(false));
        this.valueAssOpp.put("N_2", new Bool(false));
    }

    private String readFile(String file) throws IOException {
        BufferedReader reader = new BufferedReader(new FileReader(file));
        String line = null;
        StringBuilder stringBuilder = new StringBuilder();
        String ls = System.getProperty("line.separator");
        while ((line = reader.readLine()) != null) {
            stringBuilder.append(line);
            stringBuilder.append(ls);
        }
        reader.close();
        return stringBuilder.toString();
    }
}

